/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.translator;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.base.communication.translator.IWorldMessageTranslator;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base.utils.logging.LogPublisher;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AliveMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BombInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.FlagInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.HelloControlServerHandshake;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemCategory;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemCategoryEnd;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemCategoryStart;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.MapList;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.MapListEnd;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.MapListStart;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointListEnd;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPointListStart;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PasswdOk;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Password;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerListEnd;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerListStart;
import cz.cuni.amis.pogamut.ut2004.communication.translator.WorldMessageTranslatorTestModule;
import cz.cuni.amis.pogamut.ut2004.communication.translator.testplan.ListsWrapperForConversion;
import cz.cuni.amis.pogamut.ut2004.communication.translator.testplan.ListsWrapperForConversionConverter;
import cz.cuni.amis.pogamut.ut2004.communication.translator.testplan.MyUnrealId;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004CommunicationModule;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class Test01_WorldMessageTranslator {
    protected UT2004CommunicationModule module;
    protected LinkedList<InfoMessage> messages = new LinkedList();
    protected LinkedList<IWorldChangeEvent> outputEvents = new LinkedList();
    protected String planFileName;
    protected Class<? extends IWorldMessageTranslator> worldMessageTranslatorClass;
    private AgentLogger logger;
    private LogCategory log;

    protected void setModule() {
        this.module = new WorldMessageTranslatorTestModule(this.worldMessageTranslatorClass);
    }

    public AgentLogger getLogger() {
        return this.logger;
    }

    public LogCategory getLog() {
        return this.log;
    }

    public Test01_WorldMessageTranslator(String worldMessageTranslatorClassName, String planFileName) {
        this.planFileName = planFileName;
        try {
            this.worldMessageTranslatorClass = Class.forName(worldMessageTranslatorClassName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            Assert.fail((String)("Could not find class to test: " + worldMessageTranslatorClassName));
        }
    }

    @Test
    public void WorldMessagesTranslatorTest() {
        this.doTest();
    }

    private void doTest() {
        this.deserializeTest(this.planFileName);
        this.setModule();
        Assert.assertTrue((String)"Module is null", (this.module != null ? 1 : 0) != 0);
        AgentId id = new AgentId("Test");
        this.module.newBindings(id, new SocketConnectionAddress("localhost", 3000));
        Injector injector = Guice.createInjector((Module[])new Module[]{this.module});
        IWorldMessageTranslator testSubject = (IWorldMessageTranslator)injector.getInstance(IWorldMessageTranslator.class);
        LogCategory log = new LogCategory("Test");
        log.addHandler(new LogPublisher.ConsolePublisher(id));
        log.info("Starting WorldMessageTranslatorTest of " + this.worldMessageTranslatorClass.getName() + " with plan " + this.planFileName);
        LinkedList<IWorldChangeEvent> worldEventQueue = new LinkedList<IWorldChangeEvent>();
        for (InfoMessage message : this.messages) {
            log.info("Notifying translator: " + message.toString());
            IWorldChangeEvent[] worldEvents = null;
            worldEvents = testSubject.processMessage(message);
            int i = 0;
            while (i < worldEvents.length) {
                log.info("Received event: " + worldEvents[i].toString());
                worldEventQueue.add(worldEvents[i]);
                ++i;
            }
        }
        int i = 0;
        for (IWorldChangeEvent event : this.outputEvents) {
            Assert.assertTrue((String)"Too few events returned, those returned were OK", (worldEventQueue.size() > 0 ? 1 : 0) != 0);
            String expected_message_string = event.toString();
            IWorldChangeEvent receivedWorldEvent = (IWorldChangeEvent)worldEventQueue.remove();
            Assert.assertTrue((String)("Wrong event returned at " + i + " (indexed from 0)\nReturned: " + receivedWorldEvent.toString() + "\nExpected: " + expected_message_string), (receivedWorldEvent.getClass().isInstance(event) && receivedWorldEvent.toString().equals(expected_message_string) ? 1 : 0) != 0);
            ++i;
        }
        Assert.assertTrue((String)"More events were returned than expected, preceeding events were OK", (worldEventQueue.size() == 0 ? 1 : 0) != 0);
    }

    protected static void assignAliasesToXStream(XStream xstream) {
        xstream.alias("TestPlan", ListsWrapperForConversion.class);
        xstream.autodetectAnnotations(true);
        xstream.alias("Id", UnrealId.class, MyUnrealId.class);
        xstream.alias("BotId", UnrealId.class, MyUnrealId.class);
        xstream.alias("Holder", UnrealId.class, MyUnrealId.class);
        xstream.autodetectAnnotations(false);
        xstream.aliasPackage("ut2004messages", "cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages");
        xstream.aliasPackage("coremessages", "cz.cuni.amis.pogamut.base.communication.worldview.objects");
        xstream.aliasPackage("worldview", "cz.cuni.amis.pogamut.ut2004.communication.worldview");
        xstream.aliasPackage("translator", "cz.cuni.amis.pogamut.ut2004.communication.translator");
    }

    protected static void assignConvertersToXStream(XStream xstream) {
        xstream.registerConverter((Converter)new ListsWrapperForConversionConverter());
    }

    protected void serializeTest(LinkedList<InfoMessage> messages, LinkedList<IWorldChangeEvent> defaultOutput, String planFileName) {
        Assert.assertTrue((String)"planFileName has to contain the name of the plan to execute.", (planFileName != null && !planFileName.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Input messages list cannot be null or empty.", (messages != null && !messages.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expected messages list cannot be null or empty.", (defaultOutput != null && !defaultOutput.isEmpty() ? 1 : 0) != 0);
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        Test01_WorldMessageTranslator.assignConvertersToXStream(xstream);
        Test01_WorldMessageTranslator.assignAliasesToXStream(xstream);
        try {
            FileWriter writer = new FileWriter("testplans/WorldMessageTranslator/" + this.worldMessageTranslatorClass.getName() + "/" + planFileName);
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            writer.write(xstream.toXML((Object)new ListsWrapperForConversion(messages, defaultOutput)));
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Failed to write plan: " + planFileName));
        }
    }

    protected void deserializeTest(String planFileName) {
        Assert.assertTrue((String)"planFileName has to contain the name of the plan to execute.", (planFileName != null && !planFileName.isEmpty() ? 1 : 0) != 0);
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        Test01_WorldMessageTranslator.assignConvertersToXStream(xstream);
        Test01_WorldMessageTranslator.assignAliasesToXStream(xstream);
        try {
            FileReader reader = new FileReader("testplans/WorldMessageTranslator/" + planFileName);
            while (reader.read() != 10) {
            }
            ListsWrapperForConversion wrapper = (ListsWrapperForConversion)xstream.fromXML((Reader)reader);
            this.messages = wrapper.messages;
            this.outputEvents = wrapper.defaultOutput;
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)("Failed to read plan file: " + planFileName));
        }
    }

    public static LinkedList<InfoMessage> testPlan() {
        LinkedList<InfoMessage> messages = new LinkedList<InfoMessage>();
        messages.add(new HelloControlServerHandshake());
        messages.add(new Password());
        messages.add(new PasswdOk());
        messages.add(new GameInfo());
        messages.add(new MapListStart());
        messages.add(new MapList("murder"));
        messages.add(new MapList("death"));
        messages.add(new MapList("kill"));
        messages.add(new MapListEnd());
        messages.add(new ItemCategoryStart());
        messages.add(new ItemCategory("cheese", new ItemType("dairy product"), ItemType.Category.HEALTH, false, false, false, "", false, false, false, false, false, false, false, false, false, 0.0, 0.0, 0, 0, 0.0, 0.0, 0, 0, 0.0, "", 0, 0, 0.0, "", false, false, false, false, false, false, "", 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "", false, false, false, false, false, false, false, false, false, 0.0, 0.0, 0, 0, 0.0, 0.0, 0, 0, 0.0, "", 0, 0, 0.0, "", false, false, false, false, false, false, "", 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0, false));
        messages.add(new ItemCategory("cabbage", new ItemType("vegetable"), ItemType.Category.AMMO, false, false, false, "", false, false, false, false, false, false, false, false, false, 0.0, 0.0, 0, 0, 0.0, 0.0, 0, 0, 0.0, "", 0, 0, 0.0, "", false, false, false, false, false, false, "", 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "", false, false, false, false, false, false, false, false, false, 0.0, 0.0, 0, 0, 0.0, 0.0, 0, 0, 0.0, "", 0, 0, 0.0, "", false, false, false, false, false, false, "", 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0, false));
        messages.add(new ItemCategory("cleese", new ItemType("comedian"), ItemType.Category.WEAPON, false, false, false, "", false, false, false, false, false, false, false, false, false, 0.0, 0.0, 0, 0, 0.0, 0.0, 0, 0, 0.0, "", 0, 0, 0.0, "", false, false, false, false, false, false, "", 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, "", false, false, false, false, false, false, false, false, false, 0.0, 0.0, 0, 0, 0.0, 0.0, 0, 0, 0.0, "", 0, 0, 0.0, "", false, false, false, false, false, false, "", 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0, false));
        messages.add(new ItemCategoryEnd());
        messages.add(new PlayerListStart());
        messages.add(new Player(UnrealId.get("debil"), "", "", "", false, null, null, null, 0, "", false, 0));
        messages.add(new Player(UnrealId.get("blbecek"), "", "", "", false, null, null, null, 0, "", false, 0));
        messages.add(new PlayerListEnd());
        messages.add(new NavPointListStart());
        messages.add(new NavPointListEnd());
        messages.add(new FlagInfo(UnrealId.get("red flag"), null, null, 0, false, false, ""));
        messages.add(new AliveMessage(2.0));
        messages.add(new BombInfo(UnrealId.get("what bomb?"), new Location(), UnrealId.get("bomb holder"), 0, false, false, "free"));
        return messages;
    }

    @Parameterized.Parameters
    public static Collection<String[]> data() {
        File mediator_test_dir = new File("testplans/WorldMessageTranslator/");
        LinkedList<String[]> output = new LinkedList<String[]>();
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        };
        String[] stringArray = mediator_test_dir.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String class_dir = stringArray[n2];
            File mediator_tests_for_class_dir = new File("testplans/WorldMessageTranslator/" + class_dir + "/");
            if (mediator_tests_for_class_dir.isDirectory() && !class_dir.equalsIgnoreCase(".svn")) {
                String[] stringArray2 = mediator_tests_for_class_dir.list(filter);
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String file = stringArray2[n4];
                    output.add(new String[]{class_dir, String.valueOf(class_dir) + "/" + file});
                    ++n4;
                }
            }
            ++n2;
        }
        return output;
    }
}

