/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.bot.navigation;

import cz.cuni.amis.pogamut.base.agent.navigation.PathEventType;
import cz.cuni.amis.pogamut.base.agent.navigation.PathExecutorListener;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.TabooSet;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetectors.StupidStuckDetector;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.utils.exception.PogamutException;

public class RunToNearesNavPoint
extends UT2004BotModuleController {
    TabooSet<NavPoint> tabooNavs;
    private NavPoint currentNav;
    private long start;

    @Override
    public void prepareBot(UT2004Bot bot) {
        this.tabooNavs = new TabooSet(bot);
        this.pathExecutor.addStuckDetector(new StupidStuckDetector(this.getWorldView(), 4.0));
        this.pathExecutor.addPathListener(new PathExecutorListener(){

            @Override
            public void onEvent(PathEventType eventType) {
                switch (eventType) {
                    case BOT_STUCKED: {
                        RunToNearesNavPoint.this.botStuck();
                        break;
                    }
                    case TARGET_REACHED: {
                        RunToNearesNavPoint.this.targetReached();
                    }
                }
            }
        });
        this.start = System.currentTimeMillis();
    }

    @Override
    public Initialize getInitializeCommand() {
        return new Initialize().setName("PathExecutorTester");
    }

    @Override
    public void logic() throws PogamutException {
        if (System.currentTimeMillis() - this.start > 600000L) {
            throw new RuntimeException("Failed to run around all " + this.getWorldView().getAll(NavPoint.class).size() + " in 10mins.");
        }
        if (!this.pathExecutor.isMoving()) {
            int remaining = this.tabooNavs.filter(this.world.getAll(NavPoint.class).values()).size();
            NavPoint nav = remaining % 2 == 1 ? DistanceUtils.getNearest(this.tabooNavs.filter(this.world.getAll(NavPoint.class).values()), this.info.getLocation()) : DistanceUtils.getSecondNearest(this.tabooNavs.filter(this.world.getAll(NavPoint.class).values()), this.info.getLocation());
            this.user.info("Remaining navpoints: " + remaining);
            if (nav == null) {
                this.bot.stop();
            } else {
                this.user.info("Running to: " + nav);
                this.tabooNavs.add(nav);
                this.pathExecutor.followPath(this.pathPlanner.computePath(nav));
            }
        }
    }

    protected void targetReached() {
        this.user.info("Target reached ok!");
        this.pathExecutor.stop();
    }

    protected void botStuck() {
        this.user.info("Path failed...");
        throw new RuntimeException("Can't get to the nav point: " + this.currentNav);
    }
}

