/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetectors;

import cz.cuni.amis.pogamut.base.agent.navigation.PathEventType;
import cz.cuni.amis.pogamut.base.agent.navigation.SimplePathExecutor;
import cz.cuni.amis.pogamut.base.agent.navigation.stuckdetectors.AbstractStuckDetector;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import java.util.logging.Logger;

public class StupidStuckDetector
extends AbstractStuckDetector {
    private static final Logger log = Logger.getLogger("StupidStuckDetector");
    private boolean onMyWay = false;
    private final double detectTime;
    private double lastPathElementReachedTime;
    private double actualTime;
    private Object next = null;
    private boolean firstTime = true;
    private IWorldEventListener<BeginMessage> timeListener = new IWorldEventListener<BeginMessage>(){

        @Override
        public void notify(BeginMessage event) {
            if (StupidStuckDetector.this.firstTime) {
                StupidStuckDetector.this.lastPathElementReachedTime = event.getTime();
                StupidStuckDetector.this.firstTime = false;
            }
            StupidStuckDetector.this.actualTime = event.getTime();
            if (StupidStuckDetector.this.onMyWay && StupidStuckDetector.this.actualTime > StupidStuckDetector.this.lastPathElementReachedTime + StupidStuckDetector.this.detectTime) {
                log.info("Stuck detected by StupidStuckDetector.");
                StupidStuckDetector.this.lastPathElementReachedTime = StupidStuckDetector.this.actualTime;
                StupidStuckDetector.this.fireEvent(PathEventType.BOT_STUCKED);
            }
        }
    };

    public StupidStuckDetector(IWorldView worldView, double detectTime) {
        this.detectTime = detectTime;
        this.lastPathElementReachedTime = detectTime;
        worldView.addEventListener(BeginMessage.class, this.timeListener);
    }

    @Override
    public void followPathCallSucessfull() {
        this.onMyWay = true;
    }

    @Override
    public void onEvent(PathEventType eventType) {
        switch (eventType) {
            case TARGET_REACHED: {
                this.onMyWay = false;
                break;
            }
            case PATH_STARTED: {
                this.lastPathElementReachedTime = this.actualTime;
                break;
            }
            case PATH_ELEMENT_REACHED: {
                this.lastPathElementReachedTime = this.actualTime;
                Object plannedNext = ((SimplePathExecutor)this.pathExecutor).getNextPathElement();
                if (this.next != plannedNext) {
                    log.fine("Bot planned same waypoint as target!");
                }
                this.next = plannedNext;
            }
        }
    }
}

