/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.steering.utils;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class UTLine2D {
    double a;
    double b;
    double c;
    Point2D beginning;
    Point2D direction;
    Point2D vector;

    public UTLine2D(Line2D segment) {
        this.beginning = segment.getP1();
        this.direction = segment.getP2();
        this.initLine();
    }

    public UTLine2D(Point2D beginning, Point2D end) {
        this.beginning = beginning;
        this.direction = end;
        this.initLine();
    }

    public Point2D getVector() {
        return this.vector;
    }

    public UTLine2D(Double x1, Double y1, Double x2, Double y2) {
        this.beginning = new Point2D.Double(x1, y1);
        this.direction = new Point2D.Double(x2, y2);
        this.initLine();
    }

    public UTLine2D(Location loc, Velocity vel) {
        this(loc.x, loc.y, vel.x, vel.y);
    }

    private void initLine() {
        this.vector = this.subtract(this.direction, this.beginning);
        this.vector = this.invert(this.vector);
        this.initialize(this.vector, this.direction);
    }

    private void initialize(Point2D vector, Point2D p2) {
        this.a = vector.getX();
        this.b = vector.getY();
        this.c = -(this.a * p2.getX() + this.b * p2.getY());
    }

    private Point2D invert(Point2D vector) {
        if (vector.getX() < 0.0) {
            return new Point2D.Double(vector.getY(), -vector.getX());
        }
        return new Point2D.Double(-vector.getY(), vector.getX());
    }

    public Point2D getIntersection(UTLine2D line) {
        double x;
        double y;
        double tmpY1 = this.c * line.a - line.c * this.a;
        double tmpY2 = this.a * line.b - this.b * line.a;
        double tmpX1 = line.b * this.c - line.c * this.b;
        double tmpX2 = line.a * this.b - line.b * this.a;
        if (tmpY2 != 0.0 && this.a != 0.0) {
            y = tmpY1 / tmpY2;
            x = (-this.c - this.b * y) / this.a;
        } else if (tmpX2 != 0.0 && this.b != 0.0) {
            x = tmpX1 / tmpX2;
            y = (-this.c - this.a * x) / this.b;
        } else {
            return null;
        }
        return new Point2D.Double(x, y);
    }

    public Point2D getDirectedIntersection(UTLine2D line) {
        Point2D result = this.getIntersection(line);
        if (result == null) {
            return null;
        }
        double distance1 = this.beginning.distance(result);
        double distance2 = line.beginning.distance(result);
        if (distance1 > this.direction.distance(result) && distance2 > line.direction.distance(result)) {
            return result;
        }
        return null;
    }

    public String toString() {
        return "a: " + this.a + " b: " + this.b + " c: " + this.c;
    }

    public Point2D subtract(Point2D p1, Point2D p2) {
        return new Point2D.Double(p1.getX() - p2.getX(), p1.getY() - p2.getY());
    }

    public static void main(String[] args) {
        UTLine2D.testIntersection(new UTLine2D(0.0, 1.0, 1.0, 0.0), new UTLine2D(1.0, 1.0, 0.0, 0.0));
        UTLine2D.testIntersection(new UTLine2D(2.0, 1.0, 3.0, 0.0), new UTLine2D(-2.0, 0.0, -1.0, 1.0));
        System.out.println("\n\n");
        UTLine2D.testDirectedIntersection(new UTLine2D(0.0, 1.0, 1.0, 0.0), new UTLine2D(1.0, 1.0, 0.0, 0.0));
        UTLine2D.testDirectedIntersection(new UTLine2D(3.0, 0.0, 2.0, 1.0), new UTLine2D(-2.0, 0.0, -1.0, 1.0));
    }

    private static void testDirectedIntersection(UTLine2D line1, UTLine2D line2) {
        System.out.println("Line1: " + line1);
        System.out.println("Line2: " + line2);
        Point2D point = line1.getDirectedIntersection(line2);
        System.out.println(point);
    }

    private static void testIntersection(UTLine2D line1, UTLine2D line2) {
        System.out.println("Line1: " + line1);
        System.out.println("Line2: " + line2);
        Point2D point = line1.getIntersection(line2);
        System.out.println(point);
    }
}

