/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.steering;

import cz.cuni.amis.pogamut.base.agent.navigation.PathEventType;
import cz.cuni.amis.pogamut.base.agent.navigation.PathExecutorListener;
import cz.cuni.amis.pogamut.base.agent.navigation.steering.SteeringEventListener;
import cz.cuni.amis.pogamut.base.agent.navigation.steering.SteeringEventType;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UTPathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.steering.AbstractUT2004SteeringExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.steering.DoorSteeringState;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;

public class DoorSteeringExecutor
extends AbstractUT2004SteeringExecutor
implements SteeringEventListener {
    private DoorSteeringState currentState = null;
    private IWorldObjectEventListener<Self, WorldObjectUpdatedEvent<Self>> selfListener;
    private static String[] doorRecognitionStrings = new String[]{"door", "Door"};

    public static void setDoorRecognitionStrings(String ... strings) {
        doorRecognitionStrings = strings;
    }

    public static String[] getDoorRecognitionStrings() {
        return doorRecognitionStrings;
    }

    public DoorSteeringExecutor(IWorldView worldView, UTPathExecutor executor) {
        super(worldView, executor);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.MAX_BEGIN_COUNT_FOR_ERROR = 10;
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        ((UTPathExecutor)this.executor).addPathListener(new PathExecutorListener(){

            @Override
            public void onEvent(PathEventType type) {
                if (type.equals((Object)PathEventType.PATH_ELEMENT_REACHED)) {
                    DoorSteeringExecutor.this.checkEnteringDoors();
                }
            }
        });
        this.selfListener = new IWorldObjectEventListener<Self, WorldObjectUpdatedEvent<Self>>(){

            @Override
            public void notify(WorldObjectUpdatedEvent<Self> event) {
                if (DoorSteeringExecutor.this.currentState != null && DoorSteeringExecutor.this.currentState.equals((Object)DoorSteeringState.STEPPING_BACK)) {
                    DoorSteeringExecutor.this.execute();
                }
            }
        };
        this.worldView.addObjectListener(Self.class, WorldObjectUpdatedEvent.class, this.selfListener);
    }

    private void checkEnteringDoors() {
        if ((Integer)this.flag.getFlag() == 0 && DoorSteeringState.ENTERING_DOORS.isInState(this.worldView, (UTPathExecutor)this.executor)) {
            this.currentState = DoorSteeringState.ENTERING_DOORS;
            ((UTPathExecutor)this.executor).logInfo("DOOR STEERING ---- flag to: 36");
            this.flag.setFlag(36);
        }
    }

    @Override
    public boolean execute() {
        super.execute();
        if (this.currentState == null) {
            ((UTPathExecutor)this.executor).logInfo("DOOR STEERING ---- end of execution.");
            this.terminate();
        }
        if (this.currentState != null && this.currentState.shouldSwitchToNext(this.worldView, (UTPathExecutor)this.executor)) {
            this.currentState = this.currentState.switchToNextState(this.worldView, (UTPathExecutor)this.executor);
            ((UTPathExecutor)this.executor).logInfo("DOOR STEERING ---- switching to state: " + (this.currentState == null ? "null" : this.currentState.name()));
        }
        if (this.currentState != null && this.currentState.isInState(this.worldView, (UTPathExecutor)this.executor)) {
            ((UTPathExecutor)this.executor).logInfo("DOOR STEERING ---- execution of state: " + (Object)((Object)this.currentState));
            this.currentState.execute(this.worldView, this.getCommandSerializer(), (UTPathExecutor)this.executor);
        } else {
            ((UTPathExecutor)this.executor).logInfo("DOOR STEERING ---- not in state: " + (Object)((Object)this.currentState));
            this.currentState = null;
            this.terminate();
        }
        return true;
    }

    @Override
    protected void terminate() {
        super.terminate();
        DoorSteeringState.restart();
    }

    private void softTerminate() {
        DoorSteeringState.restart();
        this.currentState = null;
    }

    @Override
    public void steeringEventOccured(SteeringEventType steeringEvent) {
        if (steeringEvent.equals((Object)SteeringEventType.BOT_STUCKED)) {
            this.softTerminate();
        }
    }
}

