/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation;

import cz.cuni.amis.pogamut.base.agent.navigation.SimplePathExecutor;
import cz.cuni.amis.pogamut.base.agent.navigation.steering.SteeringExecutor;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.command.ICommandListener;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.steering.GeneralSteeringExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.steering.LiftSteeringExecutor;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Move;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Respawn;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.SetRoute;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Stop;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.utils.exception.PogamutException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class UTPathExecutor
extends SimplePathExecutor<ILocated, ILocated> {
    static final Location offset = new Location(0.0, 0.0, 20.0);
    UT2004Bot bot = null;
    IWorldObjectEventListener<Self, WorldObjectUpdatedEvent<Self>> movementListener = new IWorldObjectEventListener<Self, WorldObjectUpdatedEvent<Self>>(){
        double lastDist = Double.MAX_VALUE;

        @Override
        public void notify(WorldObjectUpdatedEvent<Self> event) {
            Self self = (Self)event.getObject();
            if (UTPathExecutor.this.getNextPathElement() == null) {
                return;
            }
            if (UTPathExecutor.this.isMoving() && self.getLocation().getDistance(((ILocated)UTPathExecutor.this.getNextPathElement()).getLocation()) < 90.0) {
                UTPathExecutor.this.moveToNext();
            } else {
                ILocated located = (ILocated)UTPathExecutor.this.getNextPathElement(1);
                if (located != null && self.getLocation().getDistance(located.getLocation()) < 90.0) {
                    UTPathExecutor.this.moveToNextNext();
                }
            }
        }
    };
    protected LogCategory log;
    protected UnrealId focusTarget = null;
    protected Location focusLocation = null;
    private ICommandListener<CommandMessage> movingListener;

    public UTPathExecutor(UT2004Bot bot) {
        this.bot = bot;
        this.log = this.bot.getLogger().getCategory(this.getClass().getSimpleName());
        this.initSteeringExecutors();
        this.initWorldViewListener();
        this.initActListeners();
    }

    private void initActListeners() {
        this.movingListener = new ICommandListener<CommandMessage>(){

            @Override
            public void notify(CommandMessage event) {
                this.movementCommandIssued();
            }

            private void movementCommandIssued() {
                UTPathExecutor.this.stop();
            }
        };
        this.bot.getAct().addCommandListener(Respawn.class, this.movingListener);
    }

    private void initWorldViewListener() {
        this.bot.getWorldView().addObjectListener(Self.class, WorldObjectUpdatedEvent.class, this.movementListener);
    }

    @Override
    protected void initSteeringExecutors() {
        ArrayList<SteeringExecutor> executors = new ArrayList<SteeringExecutor>();
        executors.add(new GeneralSteeringExecutor(this.bot.getWorldView(), this));
        executors.add(new LiftSteeringExecutor(this.bot.getWorldView(), this));
        this.setSteeringExecutors(executors);
    }

    @Override
    protected void pathReceived(List<? extends ILocated> path) {
        super.pathReceived(path);
        SetRoute setRoute = new SetRoute().setErase(true);
        if (path != null) {
            int start;
            int N = path.size();
            int i = start = N > 32 ? N - 32 : 0;
            while (i < N && i <= 31) {
                try {
                    Method method = SetRoute.class.getMethod("setPoint" + i, Location.class);
                    method.invoke((Object)setRoute, path.get(i).getLocation().add(offset));
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                ++i;
            }
        }
        this.bot.getAct().act(setRoute);
    }

    @Override
    protected ILocated getAgentLocation() {
        Location loc = this.bot.getLocation();
        if (loc == null) {
            throw new PogamutException("Location not initialized yet.", (Object)this);
        }
        return loc;
    }

    public IAct getCommandSerializer() {
        return this.bot.getAct();
    }

    @Override
    public void stop() {
        this.bot.getAct().act(new Stop());
        super.stop();
    }

    @Override
    public void log(String s) {
        if (this.log != null) {
            this.log.fine(s);
        }
    }

    public void logInfo(String s) {
        if (this.log != null) {
            this.log.info(s);
        }
    }

    public void moveTo(Location location) {
        this.bot.getAct().act(new Move(location, null, this.focusTarget, this.focusLocation));
    }

    public void moveTo(Location location1, Location location2) {
        this.bot.getAct().act(new Move(location1, location2, this.focusTarget, this.focusLocation));
    }

    public UnrealId getFocusTarget() {
        return this.focusTarget;
    }

    public void setFocusTarget(UnrealId focusTarget) {
        this.focusTarget = focusTarget;
    }

    public Location getFocusLocation() {
        return this.focusLocation;
    }

    public void setFocusLocation(Location focusLocation) {
        this.focusLocation = focusLocation;
    }

    @Override
    public void moveToNext() {
        super.moveToNext();
    }
}

