/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation;

import cz.cuni.amis.pogamut.base.agent.navigation.AbstractPathHandle;
import cz.cuni.amis.pogamut.base.agent.navigation.PathNotConstructable;
import cz.cuni.amis.pogamut.base.communication.exception.CommunicationException;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UTPathHandle;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.GetPath;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PathList;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class UTAstarPathHandle
extends AbstractPathHandle<ILocated>
implements UTPathHandle {
    UT2004Bot bot;
    ILocated target;
    IWorldEventListener<Path> pathReceivedListener = null;
    String pathRequestID = null;

    public UTAstarPathHandle(final UT2004Bot bot, ILocated target) throws PathNotConstructable {
        this.bot = bot;
        this.target = target;
        try {
            this.pathReceivedListener = new IWorldEventListener<Path>(){

                @Override
                public void notify(Path event) {
                    if (event.getPathId().equals(UTAstarPathHandle.this.pathRequestID)) {
                        UTAstarPathHandle.this.pathFlag.setFlag(UTAstarPathHandle.this.translatePath(event));
                        bot.getWorldView().removeEventListener(Path.class, this);
                        bot.getWorldView().removeEventListener(Path.class, UTAstarPathHandle.this.pathReceivedListener);
                        UTAstarPathHandle.this.pathFlag.removeAllListeners();
                        UTAstarPathHandle.this.pathReceivedListener = null;
                        UTAstarPathHandle.this.isFinal = true;
                    }
                }
            };
            bot.getWorldView().addEventListener(Path.class, this.pathReceivedListener);
            this.pathRequestID = UUID.randomUUID().toString();
            bot.getAct().act(new GetPath(this.pathRequestID, null, target.getLocation()));
        }
        catch (CommunicationException ex) {
            throw new PathNotConstructable("Path request not send because of communication exception.", ex);
        }
    }

    @Override
    public String getTargetDescription() {
        return this.target.toString();
    }

    protected List<ILocated> translatePath(Path path) {
        ArrayList<ILocated> translated = new ArrayList<ILocated>();
        for (PathList pathElem : path.getPath()) {
            translated.add(this.bot.getWorldView().getAll(NavPoint.class).get(pathElem.getRouteId()));
        }
        return translated;
    }
}

