/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectFirstEncounteredEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.FlagInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Mutator;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.MutatorListObtained;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class Game
extends SensorModule<UT2004Bot> {
    GameInfo lastGameInfo = null;
    InitedMessage lastInitedMessage = null;
    BeginMessage lastBeginMessage = null;
    MutatorListObtained lastMutatorListObtained = null;
    Map<Integer, FlagInfo> allCTFFlags = new HashMap<Integer, FlagInfo>();
    GameInfoListener gameInfoListener = new GameInfoListener(this.worldView);
    InitedMessageListener initedMessageListener;
    BeginMessageListener beginMessageListener = new BeginMessageListener(this.worldView);
    MutatorListObtainedListener mutatorListObtainedListener;
    FlagInfoObjectListener flagInfoObjectListener;

    public GameType getGameType() {
        return GameType.getType(this.lastGameInfo.getGametype());
    }

    public String getMapName() {
        return this.lastGameInfo.getLevel();
    }

    public double getTime() {
        if (this.lastBeginMessage != null) {
            return this.lastBeginMessage.getTime();
        }
        return 0.0;
    }

    public double getTimeLimit() {
        return this.lastGameInfo.getTimeLimit();
    }

    public double getRemainingTime() {
        return this.getTimeLimit() - this.getTime();
    }

    public int getFragLimit() {
        return this.lastGameInfo.getFragLimit();
    }

    public int getTeamScoreLimit() {
        return (int)this.lastGameInfo.getGoalTeamScore();
    }

    public int getMaxTeams() {
        return this.lastGameInfo.getMaxTeams();
    }

    public int getMaxTeamSize() {
        return this.lastGameInfo.getMaxTeamSize();
    }

    public int getStartHealth() {
        return this.lastInitedMessage.getHealthStart();
    }

    public int getFullHealth() {
        return this.lastInitedMessage.getHealthFull();
    }

    public int getMaxHealth() {
        return this.lastInitedMessage.getHealthMax();
    }

    public int getMaxArmor() {
        return this.lastInitedMessage.getShieldStrengthMax();
    }

    public int getMaxLowArmor() {
        return 50;
    }

    public int getMaxHighArmor() {
        return 100;
    }

    public int getStartAdrenaline() {
        return (int)this.lastInitedMessage.getAdrenalineStart();
    }

    public int getTargetAdrenaline() {
        return (int)this.lastInitedMessage.getAdrenalineMax();
    }

    public int getMaxAdrenaline() {
        return (int)this.lastInitedMessage.getAdrenalineMax();
    }

    public boolean getWeaponsStay() {
        return this.lastGameInfo.isWeaponStay();
    }

    public int getMaxMultiJump() {
        return this.lastInitedMessage.getMaxMultiJump();
    }

    public List<Mutator> getMutators() {
        return this.lastMutatorListObtained.getMutators();
    }

    public boolean isPaused() {
        return this.lastGameInfo.isGamePaused();
    }

    public boolean isBotsPaused() {
        return this.lastGameInfo.isBotsPaused();
    }

    public Map<Integer, FlagInfo> getAllCTFFlags() {
        return this.allCTFFlags;
    }

    public Collection<FlagInfo> getAllCTFFlagsCollection() {
        return this.allCTFFlags.values();
    }

    public Game(UT2004Bot bot) {
        this(bot, (Logger)null);
    }

    public Game(UT2004Bot bot, Logger log) {
        super(bot, log);
        this.initedMessageListener = new InitedMessageListener(this.worldView);
        this.mutatorListObtainedListener = new MutatorListObtainedListener(this.worldView);
        this.flagInfoObjectListener = new FlagInfoObjectListener(this.worldView);
    }

    @Override
    protected void start() {
        super.start();
        this.lastGameInfo = null;
        this.lastInitedMessage = null;
        this.lastBeginMessage = null;
        this.lastMutatorListObtained = null;
    }

    private class BeginMessageListener
    implements IWorldEventListener<BeginMessage> {
        @Override
        public void notify(BeginMessage event) {
            Game.this.lastBeginMessage = event;
        }

        public BeginMessageListener(IWorldView worldView) {
            worldView.addEventListener(BeginMessage.class, this);
        }
    }

    private class FlagInfoObjectListener
    implements IWorldObjectEventListener<FlagInfo, WorldObjectFirstEncounteredEvent<FlagInfo>> {
        @Override
        public void notify(WorldObjectFirstEncounteredEvent<FlagInfo> event) {
            if (Game.this.allCTFFlags.containsKey(((FlagInfo)event.getObject()).getTeam())) {
                Game.this.log.warning("Saving second Flag for team: " + ((FlagInfo)event.getObject()).getTeam() + ". Bug?");
            }
            Game.this.allCTFFlags.put(((FlagInfo)event.getObject()).getTeam(), (FlagInfo)event.getObject());
        }

        public FlagInfoObjectListener(IWorldView worldView) {
            worldView.addObjectListener(FlagInfo.class, WorldObjectFirstEncounteredEvent.class, this);
        }
    }

    private class GameInfoListener
    implements IWorldObjectEventListener<GameInfo, IWorldObjectEvent<GameInfo>> {
        @Override
        public void notify(IWorldObjectEvent<GameInfo> event) {
            Game.this.lastGameInfo = event.getObject();
        }

        public GameInfoListener(IWorldView worldView) {
            worldView.addObjectListener(GameInfo.class, this);
        }
    }

    public static enum GameType {
        BotDeathMatch,
        BotTeamGame,
        BotCTFGame,
        BotBombingRun,
        BotDoubleDomination,
        Unknown;


        public static GameType getType(String type) {
            if (type.equalsIgnoreCase("BotDeathMatch")) {
                return BotDeathMatch;
            }
            if (type.equalsIgnoreCase("BotTeamGame")) {
                return BotTeamGame;
            }
            if (type.equalsIgnoreCase("BotCTFGame")) {
                return BotCTFGame;
            }
            if (type.equalsIgnoreCase("BotBombingRun")) {
                return BotBombingRun;
            }
            if (type.equalsIgnoreCase("BotDoubleDomination")) {
                return BotDoubleDomination;
            }
            return Unknown;
        }
    }

    private class InitedMessageListener
    implements IWorldObjectEventListener<InitedMessage, WorldObjectUpdatedEvent<InitedMessage>> {
        @Override
        public void notify(WorldObjectUpdatedEvent<InitedMessage> event) {
            Game.this.lastInitedMessage = (InitedMessage)event.getObject();
        }

        public InitedMessageListener(IWorldView worldView) {
            worldView.addObjectListener(InitedMessage.class, WorldObjectUpdatedEvent.class, this);
        }
    }

    private class MutatorListObtainedListener
    implements IWorldEventListener<MutatorListObtained> {
        @Override
        public void notify(MutatorListObtained event) {
            Game.this.lastMutatorListObtained = event;
        }

        public MutatorListObtainedListener(IWorldView worldView) {
            worldView.addEventListener(MutatorListObtained.class, this);
        }
    }
}

