/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectFirstEncounteredEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Game;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerScore;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.TeamScore;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.VolumeChanged;
import cz.cuni.amis.utils.NullCheck;
import java.util.logging.Logger;

public class AgentInfo
extends SensorModule<UT2004Bot> {
    public static final String NONE_WEAPON_ID = "None";
    public static final int TEAM_RED = 0;
    public static final int TEAM_BLUE = 1;
    public static final int TEAM_GREEN = 2;
    public static final int TEAM_GOLD = 3;
    public static final int TEAM_NONE = 255;
    public static final double AT_LOCATION_EPSILON = 120.0;
    public static final double IS_FACING_ANGLE = 6.0;
    Self self = null;
    int suicides = 0;
    int kills = 0;
    InitedMessage lastInitedMessage = null;
    PlayerScore lastPlayerScore = null;
    TeamScore lastTeamScore = null;
    VolumeChanged lastVolumeChanged = null;
    ConfigChange lastConfig = null;
    BotKilledListener botKilledListener;
    PlayerKilledListener playerKilledListener;
    private InitedMessageListener initedMessageListener;
    private PlayerScoreListener playerScoreListener;
    private TeamScoreListener teamScoreListener;
    private VolumeChangedListener volumeChangedListener;
    private SelfListener selfListener;
    private ConfigChangeListener configChangeListener;
    public Game game;

    public UnrealId getId() {
        return this.self.getId();
    }

    public String getName() {
        return this.self.getName();
    }

    public int getTeam() {
        return this.self.getTeam();
    }

    public boolean isEnemy(int team) {
        return team == 255 || team != this.getTeam();
    }

    public boolean isEnemy(Player player) {
        return this.isEnemy(player.getTeam());
    }

    public boolean isFriend(int team) {
        return team == this.getTeam();
    }

    public boolean isFriend(Player player) {
        return this.isFriend(player.getTeam());
    }

    public Location getLocation() {
        return this.self.getLocation();
    }

    public boolean atLocation(Location location) {
        return this.atLocation(location, 120.0);
    }

    public boolean atLocation(Location location, double epsilon) {
        if (location == null) {
            return false;
        }
        return this.getLocation().getPoint3d().distance(location.getPoint3d()) < epsilon;
    }

    public double getDistance(Location location) {
        return this.self.getLocation().getDistance(location);
    }

    public Rotation getRotation() {
        return this.self.getRotation();
    }

    public Velocity getVelocity() {
        return this.self.getVelocity();
    }

    public boolean isMoving() {
        return !this.getVelocity().isZero();
    }

    public boolean isCrouched() {
        return this.self.isCrouched();
    }

    public boolean isWalking() {
        return this.self.isWalking();
    }

    public boolean isFacing(ILocated location) {
        Location agentFaceVector;
        Location directionVector = location.getLocation().sub(this.getLocation()).getNormalized();
        return Math.acos(directionVector.dot(agentFaceVector = this.getRotation().toLocation().getNormalized())) <= Math.toRadians(6.0);
    }

    public boolean isFacing(ILocated location, double angle) {
        Location agentFaceVector;
        Location directionVector = location.getLocation().sub(this.getLocation()).getNormalized();
        return Math.acos(directionVector.dot(agentFaceVector = this.getRotation().toLocation().getNormalized())) <= Math.toRadians(angle);
    }

    public Location getFloorLocation() {
        return this.self.getFloorLocation();
    }

    public boolean isTouchingGround() {
        return this.getLocation().z - this.getFloorLocation().z < (double)(this.isCrouched() ? 50 : 80);
    }

    public double getRemainingUDamageTime() {
        return this.self.getUDamageTime() - this.getTime();
    }

    public boolean hasUDamage() {
        return this.getRemainingUDamageTime() > 0.0;
    }

    public boolean hasInvisibility() {
        return this.self.getCombo().equals("xGame.ComboInvis");
    }

    public boolean hasFastFire() {
        return this.self.getCombo().equals("xGame.ComboBerserk");
    }

    public boolean hasRegeneration() {
        return this.self.getCombo().equals("xGame.ComboDefensive");
    }

    public boolean hasSpeed() {
        return this.self.getCombo().equals("xGame.ComboSpeed");
    }

    public int getHealth() {
        return this.self.getHealth();
    }

    public boolean isHealthy() {
        return this.getHealth() >= this.game.getFullHealth();
    }

    public boolean isSuperHealthy() {
        return this.getHealth() >= this.game.getMaxHealth();
    }

    public int getArmor() {
        return this.self.getArmor();
    }

    public boolean hasArmor() {
        return this.getArmor() >= this.game.getMaxArmor();
    }

    public int getLowArmor() {
        return this.self.getSmallArmor();
    }

    public boolean hasLowArmor() {
        return this.getLowArmor() >= this.game.getMaxLowArmor();
    }

    public int getHighArmor() {
        return this.self.getArmor() - this.self.getSmallArmor();
    }

    public boolean hasHighArmor() {
        return this.getHighArmor() >= this.game.getMaxHighArmor();
    }

    public int getAdrenaline() {
        return this.self.getAdrenaline();
    }

    public boolean isAdrenalineSufficient() {
        return this.getAdrenaline() >= this.game.getTargetAdrenaline();
    }

    public boolean isAdrenalineFull() {
        return this.getAdrenaline() >= this.game.getMaxAdrenaline();
    }

    public UnrealId getCurrentWeapon() {
        return this.self.getWeapon();
    }

    public boolean hasWeapon() {
        return !this.self.getWeapon().getStringId().equalsIgnoreCase(NONE_WEAPON_ID);
    }

    public int getCurrentAmmo() {
        return this.self.getPrimaryAmmo();
    }

    public int getCurrentSecondaryAmmo() {
        return this.self.getSecondaryAmmo();
    }

    public boolean isShooting() {
        return this.self.isShooting();
    }

    public boolean isPrimaryShooting() {
        return this.isShooting() && !this.isSecondaryShooting();
    }

    public boolean isSecondaryShooting() {
        return this.self.isAltFiring();
    }

    public int getKills() {
        return this.kills;
    }

    public int getDeaths() {
        return this.lastPlayerScore.getDeaths();
    }

    public int getSuicides() {
        return this.suicides;
    }

    public int getScore() {
        return this.lastPlayerScore.getScore();
    }

    public int getTeamScore() {
        if (this.lastTeamScore == null) {
            return 0;
        }
        return this.lastTeamScore.getScore();
    }

    public Velocity getCurrentZoneVelocity() {
        return this.lastVolumeChanged.getZoneVelocity();
    }

    public Velocity getCurrentZoneGravity() {
        return this.lastVolumeChanged.getZoneGravity();
    }

    public double getCurrentVolumeGroundFriction() {
        return this.lastVolumeChanged.getGroundFriction();
    }

    public double getCurrentVolumeFluidFriction() {
        return this.lastVolumeChanged.getFluidFriction();
    }

    public double _getCurrentVolumeTerminalVelocity() {
        return this.lastVolumeChanged.getTerminalVelocity();
    }

    public boolean isCurrentVolumeWater() {
        return this.lastVolumeChanged.isWaterVolume();
    }

    public boolean isCurrentVolumePainCausing() {
        return this.lastVolumeChanged.isPainCausing();
    }

    public double getCurrentVolumeDamagePerSec() {
        return this.lastVolumeChanged.getDamagePerSec();
    }

    public boolean isCurrentVolumeDestructive() {
        return this.lastVolumeChanged.isDestructive();
    }

    public String getCurrentVolumeDamageType() {
        return this.lastVolumeChanged.getDamageType();
    }

    public boolean isCurrentVolumeBanningInventory() {
        return this.lastVolumeChanged.isNoInventory();
    }

    public boolean isCurrentVolumeAffectingProjectiles() {
        return this.lastVolumeChanged.isMoveProjectiles();
    }

    public boolean isCurrentZoneNeutral() {
        return this.lastVolumeChanged.isNeutralZone();
    }

    public double getDamageScaling() {
        return this.lastInitedMessage.getDamageScaling();
    }

    public double getBaseSpeed() {
        return this.lastInitedMessage.getGroundSpeed();
    }

    public double getAirSpeed() {
        return this.lastInitedMessage.getAirSpeed();
    }

    public double getLadderSpeed() {
        return this.lastInitedMessage.getLadderSpeed();
    }

    public double getWaterSpeed() {
        return this.lastInitedMessage.getWaterSpeed();
    }

    public double getFallSpeed() {
        return this.lastInitedMessage.getMaxFallSpeed();
    }

    public double getDodgeSpeedFactor() {
        return this.lastInitedMessage.getDodgeSpeedFactor();
    }

    public double getAccelerationRate() {
        return this.lastInitedMessage.getAccelRate();
    }

    public double getAirControl() {
        return this.lastInitedMessage.getAirControl();
    }

    public double getJumpZBoost() {
        return this.lastInitedMessage.getJumpZ();
    }

    public double getDodgeZBoost() {
        return this.lastInitedMessage.getDodgeSpeedZ();
    }

    public double getTime() {
        return this.game.getTime();
    }

    public ConfigChange getConfig() {
        return this.lastConfig;
    }

    public NavPoint getNearestNavPoint() {
        return DistanceUtils.getNearest(((UT2004Bot)this.agent).getWorldView().getAll(NavPoint.class).values(), this.getLocation());
    }

    public NavPoint getNearestVisibleNavPoint() {
        return DistanceUtils.getNearestVisible(((UT2004Bot)this.agent).getWorldView().getAll(NavPoint.class).values(), this.getLocation());
    }

    public Item getNearestItem() {
        return DistanceUtils.getNearest(((UT2004Bot)this.agent).getWorldView().getAll(Item.class).values(), this.getLocation());
    }

    public Item getNearestVisibleItem() {
        return DistanceUtils.getNearestVisible(((UT2004Bot)this.agent).getWorldView().getAll(Item.class).values(), this.getLocation());
    }

    public Player getNearestPlayer() {
        return DistanceUtils.getNearest(((UT2004Bot)this.agent).getWorldView().getAll(Player.class).values(), this.getLocation());
    }

    public Player getNearestVisiblePlayer() {
        return DistanceUtils.getNearestVisible(((UT2004Bot)this.agent).getWorldView().getAll(Player.class).values(), this.getLocation());
    }

    public Self getSelf() {
        return this.self;
    }

    public AgentInfo(UT2004Bot bot) {
        this(bot, new Game(bot), null);
    }

    public AgentInfo(UT2004Bot bot, Game game) {
        this(bot, game, null);
    }

    public AgentInfo(UT2004Bot bot, Game game, Logger log) {
        super(bot, log);
        this.game = game;
        NullCheck.check(this.game, "game");
        this.selfListener = new SelfListener(this.worldView);
        this.initedMessageListener = new InitedMessageListener(this.worldView);
        this.playerScoreListener = new PlayerScoreListener(this.worldView);
        this.teamScoreListener = new TeamScoreListener(this.worldView);
        this.volumeChangedListener = new VolumeChangedListener(this.worldView);
        this.botKilledListener = new BotKilledListener(this.worldView);
        this.playerKilledListener = new PlayerKilledListener(this.worldView);
        this.configChangeListener = new ConfigChangeListener(this.worldView);
    }

    @Override
    protected void start() {
        super.start();
        this.self = null;
        this.suicides = 0;
        this.kills = 0;
        this.lastInitedMessage = null;
        this.lastPlayerScore = null;
        this.lastTeamScore = null;
        this.lastVolumeChanged = null;
        this.lastConfig = null;
    }

    private class BotKilledListener
    implements IWorldEventListener<BotKilled> {
        public BotKilledListener(IWorldView worldView) {
            worldView.addEventListener(BotKilled.class, this);
        }

        @Override
        public void notify(BotKilled event) {
            if (AgentInfo.this.self == null) {
                return;
            }
            if (event.getKiller() == null || event.getKiller().equals(AgentInfo.this.getId())) {
                ++AgentInfo.this.suicides;
            }
        }
    }

    private class ConfigChangeListener
    implements IWorldObjectEventListener<ConfigChange, IWorldObjectEvent<ConfigChange>> {
        private IWorldView worldView;

        public ConfigChangeListener(IWorldView worldView) {
            worldView.addObjectListener(ConfigChange.class, WorldObjectFirstEncounteredEvent.class, this);
            this.worldView = worldView;
        }

        @Override
        public void notify(IWorldObjectEvent<ConfigChange> event) {
            AgentInfo.this.lastConfig = event.getObject();
        }
    }

    private class InitedMessageListener
    implements IWorldObjectEventListener<InitedMessage, WorldObjectUpdatedEvent<InitedMessage>> {
        @Override
        public void notify(WorldObjectUpdatedEvent<InitedMessage> event) {
            AgentInfo.this.lastInitedMessage = (InitedMessage)event.getObject();
        }

        public InitedMessageListener(IWorldView worldView) {
            worldView.addObjectListener(InitedMessage.class, WorldObjectUpdatedEvent.class, this);
        }
    }

    private class PlayerKilledListener
    implements IWorldEventListener<PlayerKilled> {
        public PlayerKilledListener(IWorldView worldView) {
            worldView.addEventListener(PlayerKilled.class, this);
        }

        @Override
        public void notify(PlayerKilled event) {
            if (AgentInfo.this.self == null) {
                return;
            }
            if (event.getKiller() != null && event.getKiller().equals(AgentInfo.this.getId())) {
                ++AgentInfo.this.kills;
            }
        }
    }

    private class PlayerScoreListener
    implements IWorldEventListener<PlayerScore> {
        @Override
        public void notify(PlayerScore event) {
            AgentInfo.this.lastPlayerScore = event;
        }

        public PlayerScoreListener(IWorldView worldView) {
            worldView.addEventListener(PlayerScore.class, this);
        }
    }

    private class SelfListener
    implements IWorldObjectEventListener<Self, WorldObjectFirstEncounteredEvent<Self>> {
        private IWorldView worldView;

        public SelfListener(IWorldView worldView) {
            this.worldView = worldView;
            worldView.addObjectListener(Self.class, WorldObjectFirstEncounteredEvent.class, this);
        }

        @Override
        public void notify(WorldObjectFirstEncounteredEvent<Self> event) {
            AgentInfo.this.self = (Self)event.getObject();
        }
    }

    private class TeamScoreListener
    implements IWorldObjectEventListener<TeamScore, WorldObjectUpdatedEvent<TeamScore>> {
        public TeamScoreListener(IWorldView worldView) {
            worldView.addEventListener(TeamScore.class, this);
        }

        @Override
        public void notify(WorldObjectUpdatedEvent<TeamScore> event) {
            AgentInfo.this.lastTeamScore = (TeamScore)event.getObject();
        }
    }

    private class VolumeChangedListener
    implements IWorldEventListener<VolumeChanged> {
        @Override
        public void notify(VolumeChanged event) {
            AgentInfo.this.lastVolumeChanged = event;
        }

        public VolumeChangedListener(IWorldView worldView) {
            worldView.addEventListener(VolumeChanged.class, this);
        }
    }
}

