/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging.jmx;

import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.jmx.PogamutJMX;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategories;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base.utils.logging.jmx.JMXLogCategories;
import cz.cuni.amis.utils.exception.PogamutException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class Test01_JMXLogCategories {
    CountDownLatch messageReceivedLatch = new CountDownLatch(1);
    String receivedMessage = null;

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void receiveLogEventThroughJMX() throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, MalformedObjectNameException, PogamutException, MalformedURLException, IOException, InterruptedException, MBeanException, InstanceNotFoundException, AttributeNotFoundException, ReflectionException {
        String testMsg = "TEST LOG MESSAGE FROM receiveLogEventThroughJMX()";
        ObjectName parentName = PogamutJMX.getObjectName("testDomain", "root", "test");
        LogCategories logCategories = new LogCategories();
        String testLogCategoryNameStr = "testLogCategory";
        LogCategory testLog = logCategories.getCategory(testLogCategoryNameStr);
        JMXLogCategories jmxLogCategories = new JMXLogCategories(logCategories, Pogamut.getPlatform().getMBeanServer(), parentName);
        MBeanServerConnection mbsc = Pogamut.getPlatform().getMBeanServerConnection();
        ObjectName logCatsName = jmxLogCategories.getJMXLogCategoriesName();
        String[] catNames = (String[])mbsc.getAttribute(logCatsName, "CategoryNames");
        boolean found = false;
        String[] stringArray = catNames;
        int n = catNames.length;
        int n2 = 0;
        while (n2 < n) {
            String catName = stringArray[n2];
            if (catName.equals(testLogCategoryNameStr)) {
                found = true;
                break;
            }
            ++n2;
        }
        junit.framework.Assert.assertTrue((String)(String.valueOf(testLogCategoryNameStr) + " must be among exported log category names"), (boolean)found);
        ObjectName testCategoryName = (ObjectName)mbsc.invoke(logCatsName, "getJMXLogCategoryName", new Object[]{testLogCategoryNameStr}, new String[]{"java.lang.String"});
        mbsc.addNotificationListener(testCategoryName, new NotificationListener(){

            @Override
            public void handleNotification(Notification notification, Object handback) {
                Test01_JMXLogCategories.this.receivedMessage = notification.getMessage();
                Test01_JMXLogCategories.this.messageReceivedLatch.countDown();
            }
        }, null, (Object)this);
        testLog.info("TEST LOG MESSAGE FROM receiveLogEventThroughJMX()");
        this.messageReceivedLatch.await(30000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)this.receivedMessage.contains("TEST LOG MESSAGE FROM receiveLogEventThroughJMX()"));
        System.out.println("---/// TEST OK ///---");
        Pogamut.getPlatform().close();
    }
}

