/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging;

import cz.cuni.amis.pogamut.base.utils.logging.ILogPublisher;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategoryFilter;
import cz.cuni.amis.pogamut.base.utils.logging.LogHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogCategory
extends Logger
implements Comparable<LogCategory> {
    private String categoryName;
    private Object mutex = new Object();
    private Logger parent;

    public LogCategory(String categoryName) {
        this(categoryName, (Logger)null);
    }

    public LogCategory(String categoryName, Logger parent) {
        super(categoryName, null);
        this.parent = parent;
        this.categoryName = categoryName;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    @Override
    public void setLevel(Level logLevel) throws SecurityException {
        if (this.getLevel() != null) {
            this.log(this.getLevel(), "Log level set to " + logLevel + ".");
        } else {
            this.log(Level.WARNING, "Log level set to " + logLevel + ".");
        }
        super.setLevel(logLevel);
    }

    public LogHandler addHandler() {
        return this.addHandler((ILogPublisher)null);
    }

    public LogHandler addHandler(ILogPublisher publisher) {
        LogHandler handler = new LogHandler();
        handler.setFilter(new LogCategoryFilter(this));
        handler.setPublisher(publisher);
        this.addHandler(handler);
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Level level, String msg, Object[] params) {
        Object object = this.mutex;
        synchronized (object) {
            if (params.length == 0) {
                super.log(level, msg, this.getCategoryName());
                if (this.parent != null) {
                    this.parent.log(level, msg, this.getCategoryName());
                }
            } else {
                Object[] finalParams = new Object[params.length + 1];
                finalParams[0] = this.getCategoryName();
                System.arraycopy(params, 0, finalParams, 1, params.length);
                super.log(level, msg, finalParams);
                if (this.parent != null) {
                    this.parent.log(level, msg, this.getCategoryName());
                }
            }
        }
    }

    @Override
    public void log(Level level, String msg) {
        this.log(level, msg, new Object[0]);
    }

    @Override
    public void log(Level level, String msg, Object param) {
        this.log(level, msg, new Object[]{param});
    }

    @Override
    public void finest(String msg) {
        this.log(Level.FINEST, msg);
    }

    public void finest(String msg, Object param) {
        this.log(Level.FINEST, msg, param);
    }

    public void finest(String msg, Object[] params) {
        this.log(Level.FINEST, msg, params);
    }

    @Override
    public void finer(String msg) {
        this.log(Level.FINER, msg);
    }

    public void finer(String msg, Object param) {
        this.log(Level.FINER, msg, param);
    }

    public void finer(String msg, Object[] params) {
        this.log(Level.FINER, msg, params);
    }

    @Override
    public void fine(String msg) {
        this.log(Level.FINE, msg);
    }

    public void fine(String msg, Object param) {
        this.log(Level.FINE, msg, param);
    }

    public void fine(String msg, Object[] params) {
        this.log(Level.FINE, msg, params);
    }

    @Override
    public void info(String msg) {
        this.log(Level.INFO, msg);
    }

    public void info(String msg, Object param) {
        this.log(Level.INFO, msg, param);
    }

    public void info(String msg, Object[] params) {
        this.log(Level.INFO, msg, params);
    }

    @Override
    public void warning(String msg) {
        this.log(Level.WARNING, msg);
    }

    public void warning(String msg, Object param) {
        this.log(Level.WARNING, msg, param);
    }

    public void warning(String msg, Object[] params) {
        this.log(Level.WARNING, msg, params);
    }

    @Override
    public void severe(String msg) {
        this.log(Level.SEVERE, msg);
    }

    public void severe(String msg, Object param) {
        this.log(Level.SEVERE, msg, param);
    }

    public void severe(String msg, Object[] params) {
        this.log(Level.SEVERE, msg, params);
    }

    public String toString() {
        return "LogCategory(" + this.getName() + ")";
    }

    @Override
    public int compareTo(LogCategory o) {
        if (o.categoryName == null) {
            if (this.categoryName == null) {
                return 0;
            }
            return -1;
        }
        if (this.categoryName == null) {
            return 1;
        }
        return o.categoryName.compareTo(this.categoryName);
    }
}

