/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.jmx;

import cz.cuni.amis.pogamut.base.utils.exception.PogamutJMXNameException;
import cz.cuni.amis.utils.NullCheck;
import javax.management.ObjectName;

public class PogamutJMX {
    public static final String AGENT_SUBTYPE = "agent";
    public static final String ACT_NAME = "act";
    public static final String LOGCATEGORIES_NAME = "logcat";
    public static final String LOGCATEGORIES_SUBTYPE = "logcategories";
    public static final String LOGCATEGORY_SUBTYPE = "logcategory";
    public static final String FLAGS_SUBTYPE = "flags";
    public static final String INTROSPECTION_NAME = "introspection";

    public static ObjectName getObjectName(ObjectName parent, String childName, String childTypeExtra) throws PogamutJMXNameException {
        NullCheck.check(parent, "parent");
        String parentDomain = parent.getDomain();
        String parentType = parent.getKeyProperty("type");
        String parentName = parent.getKeyProperty("name");
        if (childTypeExtra != null) {
            String[] childTypeParts = childTypeExtra.split(".");
            if (childTypeParts.length != 0) {
                int i = 0;
                while (i < childTypeParts.length) {
                    childTypeParts[i] = PogamutJMX.getSafeObjectNamePart(childTypeParts[i]);
                    ++i;
                }
                childTypeExtra = childTypeParts[0];
                i = 1;
                while (i < childTypeParts.length) {
                    childTypeExtra = String.valueOf(childTypeExtra) + "." + childTypeParts[i];
                    ++i;
                }
            } else {
                childTypeExtra = PogamutJMX.getSafeObjectNamePart(childTypeExtra);
            }
        }
        String childType = childTypeExtra == null ? String.valueOf(parentType) + "." + parentName : String.valueOf(parentType) + "." + parentName + "." + childTypeExtra;
        return PogamutJMX.getObjectName(parentDomain, childType, childName);
    }

    public static ObjectName getObjectName(ObjectName parent, String childName) throws PogamutJMXNameException {
        NullCheck.check(parent, "parent");
        NullCheck.check(childName, "childName");
        String parentDomain = parent.getKeyProperty("domain");
        String parentType = parent.getKeyProperty("type");
        String parentName = parent.getKeyProperty("name");
        String childType = String.valueOf(parentType) + "." + parentName;
        return PogamutJMX.getObjectName(parentDomain, childType, childName);
    }

    public static String getSafeObjectNamePart(String str) {
        return str.replace('[', '_').replace(']', '_').replace('(', '_').replace(')', '_').replace('.', '_').replace(',', '_').replace('/', '_').replace('*', '_').replace('?', '_').replace(':', '_');
    }

    public static ObjectName getObjectName(String jmxDomain, String type, String name) throws PogamutJMXNameException {
        if (name != null) {
            name = PogamutJMX.getSafeObjectNamePart(name);
        }
        String jmxName = name == null ? String.valueOf(jmxDomain) + ":type=" + type : String.valueOf(jmxDomain) + ":type=" + type + ",name=" + name;
        try {
            return ObjectName.getInstance(jmxName);
        }
        catch (Exception e) {
            throw new PogamutJMXNameException(jmxName, e);
        }
    }
}

