/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.component.stub;

import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentEvent;
import cz.cuni.amis.pogamut.base.utils.Const;
import cz.cuni.amis.utils.NullCheck;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;

public class CheckEvent {
    private List<Class> eventClasses = new ArrayList<Class>();
    private IComponent source = null;

    public CheckEvent(IComponentEvent checkEvent) {
        Class<?>[] classArray = checkEvent.getClass().getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> cls = classArray[n2];
            this.eventClasses.add(cls);
            ++n2;
        }
        this.source = checkEvent.getSource();
        NullCheck.check(this.source, "checkEvent.getSource()");
    }

    public CheckEvent(Class eventClass) {
        NullCheck.check(eventClass, "eventClass");
        this.eventClasses.add(eventClass);
    }

    public CheckEvent(Class eventClass, IComponent source) {
        NullCheck.check(eventClass, "eventClass");
        this.eventClasses.add(eventClass);
        this.source = source;
        NullCheck.check(this.source, "source");
    }

    public CheckEvent(IComponent source) {
        this.source = source;
        NullCheck.check(this.source, "source");
    }

    public void check(IComponentEvent event) {
        for (Class cls : this.eventClasses) {
            if (cls.isAssignableFrom(event.getClass())) continue;
            Assert.fail((String)(String.valueOf(Const.NEW_LINE) + "Expected event class: " + cls + Const.NEW_LINE + (this.source != null ? "From                : " + this.source + Const.NEW_LINE : "") + "Got class           : " + event.getClass() + Const.NEW_LINE + "From source         : " + event.getSource()));
        }
        if (this.source != null && this.source != event.getSource()) {
            Assert.fail((String)(String.valueOf(Const.NEW_LINE) + "Event          : " + event.getClass() + Const.NEW_LINE + "Expected source: " + this.source + Const.NEW_LINE + "Got            : " + event.getSource()));
        }
    }

    public boolean checkNoException(IComponentEvent event) {
        for (Class cls : this.eventClasses) {
            if (cls.isAssignableFrom(event.getClass())) continue;
            return false;
        }
        return this.source == null || this.source == event.getSource();
    }
}

