/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.component.controller;

import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.component.bus.ComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.IComponentEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.PausedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.PausingEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.ResumedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.ResumingEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.StartedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.StartingEvent;
import cz.cuni.amis.pogamut.base.component.controller.ComponentControlHelper;
import cz.cuni.amis.pogamut.base.component.controller.ComponentController;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.component.stub.AutoCheckComponent;
import cz.cuni.amis.pogamut.base.component.stub.CheckEvent;
import cz.cuni.amis.pogamut.base.component.stub.ManualCheckComponent;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import java.util.logging.Level;
import org.junit.Test;

public class Test01_ComponentController {
    @Test
    public void test() {
        AgentId agentId = new AgentId("Test01_ComponentController");
        AgentLogger logger = new AgentLogger(agentId);
        logger.addDefaultConsoleHandler();
        logger.setLevel(Level.ALL);
        ComponentBus bus = new ComponentBus(logger);
        AutoCheckComponent autoComp0 = new AutoCheckComponent(logger, bus);
        ComponentControlHelper emptyCtrl = new ComponentControlHelper(){};
        ManualCheckComponent manualComp0 = new ManualCheckComponent(logger, bus);
        ManualCheckComponent manualComp1 = new ManualCheckComponent(logger, bus);
        ManualCheckComponent manualComp2 = new ManualCheckComponent(logger, bus);
        ManualCheckComponent manualComp3 = new ManualCheckComponent(logger, bus);
        ComponentController manualCompCtrl1 = new ComponentController(manualComp1, emptyCtrl, bus, logger.getCategory(manualComp1.getComponentId().getToken()), new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add(manualComp0));
        ComponentController manualCompCtrl2 = new ComponentController(manualComp2, emptyCtrl, bus, logger.getCategory(manualComp2.getComponentId().getToken()), new ComponentDependencies(ComponentDependencyType.STARTS_AFTER).add(manualComp1));
        ComponentController manualCompCtrl3 = new ComponentController(manualComp3, emptyCtrl, bus, logger.getCategory(manualComp3.getComponentId().getToken()), new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add(manualComp2));
        IComponentEvent[] events = new IComponentEvent[]{new StartingEvent<ManualCheckComponent>(manualComp0), new StartingEvent<ManualCheckComponent>(manualComp1), new StartedEvent<ManualCheckComponent>(manualComp1), new StartingEvent<ManualCheckComponent>(manualComp2), new StartingEvent<ManualCheckComponent>(manualComp3), new StartedEvent<ManualCheckComponent>(manualComp3), new StartedEvent<ManualCheckComponent>(manualComp2), new StartedEvent<ManualCheckComponent>(manualComp0), new PausingEvent<ManualCheckComponent>(manualComp3), new PausedEvent<ManualCheckComponent>(manualComp3), new ResumingEvent<ManualCheckComponent>(manualComp3), new ResumedEvent<ManualCheckComponent>(manualComp3), new PausingEvent<ManualCheckComponent>(manualComp0), new PausingEvent<ManualCheckComponent>(manualComp1), new PausingEvent<ManualCheckComponent>(manualComp2), new PausingEvent<ManualCheckComponent>(manualComp3), new PausedEvent<ManualCheckComponent>(manualComp3), new PausedEvent<ManualCheckComponent>(manualComp2), new PausedEvent<ManualCheckComponent>(manualComp1), new PausedEvent<ManualCheckComponent>(manualComp0)};
        CheckEvent[] checkEvents = new CheckEvent[events.length];
        int i = 0;
        while (i < events.length) {
            checkEvents[i] = new CheckEvent(events[i]);
            ++i;
        }
        autoComp0.expect(checkEvents);
        bus.event(new StartingEvent<ManualCheckComponent>(manualComp0));
        bus.event(new StartedEvent<ManualCheckComponent>(manualComp0));
        manualCompCtrl3.manualPause("testing");
        manualCompCtrl3.manualResume("testing");
        bus.event(new PausingEvent<ManualCheckComponent>(manualComp0));
        bus.event(new PausedEvent<ManualCheckComponent>(manualComp0));
        autoComp0.checkExpectEmpty();
        System.out.println("---/// TEST OK ///---");
    }

    public static void main(String[] args) {
        Test01_ComponentController test = new Test01_ComponentController();
        test.test();
    }
}

