/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.component.controller;

import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.IComponentEvent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentEventListener;
import cz.cuni.amis.pogamut.base.component.bus.event.ComponentBusEvents;
import cz.cuni.amis.pogamut.base.component.bus.event.IFatalErrorEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IPausedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IPausingEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IResetEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IResumedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IResumingEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IStartedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IStartingEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IStoppedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IStoppingEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.FatalErrorEvent;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.component.controller.ComponentState;
import cz.cuni.amis.pogamut.base.component.controller.IComponentControlHelper;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantPauseException;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantResumeException;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantStartException;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantStopException;
import cz.cuni.amis.pogamut.base.component.exception.ComponentKilledException;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.IFlag;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import cz.cuni.amis.utils.flag.WaitForFlagChange;
import cz.cuni.amis.utils.token.IToken;
import cz.cuni.amis.utils.token.Tokens;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ComponentController
implements IComponent {
    private Object mutex = new Object();
    private ComponentDependencies dependencies;
    private Map<IToken, ComponentState> dependencyState = new HashMap<IToken, ComponentState>();
    private Map<ComponentState, Integer> stateCount = new HashMap<ComponentState, Integer>();
    private Flag<ComponentState> componentState = new Flag<ComponentState>(ComponentState.INSTANTIATED);
    private IFatalErrorEvent lastFatalError = null;
    private IComponentEventListener<IStartingEvent> startingListener = new IComponentEventListener<IStartingEvent>(){

        @Override
        public void notify(IStartingEvent event) {
            ComponentController.this.startingEvent(event, false);
        }
    };
    private IComponentEventListener<IStartedEvent> startedListener = new IComponentEventListener<IStartedEvent>(){

        @Override
        public void notify(IStartedEvent event) {
            ComponentController.this.startedEvent(event);
        }
    };
    private IComponentEventListener<IPausingEvent> pausingListener = new IComponentEventListener<IPausingEvent>(){

        @Override
        public void notify(IPausingEvent event) {
            ComponentController.this.pausingEvent(event, false);
        }
    };
    private IComponentEventListener<IPausedEvent> pausedListener = new IComponentEventListener<IPausedEvent>(){

        @Override
        public void notify(IPausedEvent event) {
            ComponentController.this.pausedEvent(event);
        }
    };
    private IComponentEventListener<IResumingEvent> resumingListener = new IComponentEventListener<IResumingEvent>(){

        @Override
        public void notify(IResumingEvent event) {
            ComponentController.this.resumingEvent(event, false);
        }
    };
    private IComponentEventListener<IResumedEvent> resumedListener = new IComponentEventListener<IResumedEvent>(){

        @Override
        public void notify(IResumedEvent event) {
            ComponentController.this.resumedEvent(event);
        }
    };
    private IComponentEventListener<IStoppingEvent> stoppingListener = new IComponentEventListener<IStoppingEvent>(){

        @Override
        public void notify(IStoppingEvent event) {
            ComponentController.this.stoppingEvent(event, false);
        }
    };
    private IComponentEventListener<IStoppedEvent> stoppedListener = new IComponentEventListener<IStoppedEvent>(){

        @Override
        public void notify(IStoppedEvent event) {
            ComponentController.this.stoppedEvent(event);
        }
    };
    private IComponentEventListener<IFatalErrorEvent> fatalErrorListener = new IComponentEventListener<IFatalErrorEvent>(){

        @Override
        public void notify(IFatalErrorEvent event) {
            ComponentController.this.fatalErrorEvent(event);
        }
    };
    private IComponentEventListener<IResetEvent> resetEventListener = new IComponentEventListener<IResetEvent>(){

        @Override
        public void notify(IResetEvent event) {
            ComponentController.this.resetEvent(event);
        }
    };
    private IToken controllerId;
    private IComponentControlHelper control;
    private IComponent component;
    private IComponentBus bus;
    private Logger log;
    private ComponentBusEvents componentEvents;
    private ComponentBusEvents controllerEvents;

    public ComponentController(IComponent component, IComponentControlHelper componentControlHelper, IComponentBus bus, Logger log, ComponentDependencyType dependencyType, Object ... dependencies) {
        this(component, componentControlHelper, bus, log, new ComponentDependencies(dependencyType, dependencies));
    }

    public ComponentController(IComponent component, IComponentControlHelper componentControlHelper, IComponentBus bus, Logger log, ComponentDependencies dependencies) {
        this.log = log;
        NullCheck.check(this.log, "log");
        this.bus = bus;
        NullCheck.check(this.bus, "bus");
        this.component = component;
        NullCheck.check(this.component, "component");
        this.control = componentControlHelper;
        NullCheck.check(this.control, "componentControlHelper");
        this.dependencies = dependencies;
        NullCheck.check(this.dependencies, "dependencies");
        this.bus.register(component);
        this.controllerId = Tokens.get(String.valueOf(component.getComponentId().getToken()) + "-controller");
        this.bus.register(this);
        this.componentEvents = new ComponentBusEvents(bus, this.component);
        this.controllerEvents = new ComponentBusEvents(bus, this);
        Object[] objectArray = dependencies.getDependencies();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IToken dependency = objectArray[n2];
            this.dependencyState.put(dependency, ComponentState.INSTANTIATED);
            this.bus.addEventListener(IStartingEvent.class, dependency, this.startingListener);
            this.bus.addEventListener(IStartedEvent.class, dependency, this.startedListener);
            this.bus.addEventListener(IStoppingEvent.class, dependency, this.stoppingListener);
            this.bus.addEventListener(IStoppedEvent.class, dependency, this.stoppedListener);
            this.bus.addEventListener(IPausingEvent.class, dependency, this.pausingListener);
            this.bus.addEventListener(IPausedEvent.class, dependency, this.pausedListener);
            this.bus.addEventListener(IResumingEvent.class, dependency, this.resumingListener);
            this.bus.addEventListener(IResumedEvent.class, dependency, this.resumedListener);
            ++n2;
        }
        objectArray = ComponentState.values();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            IToken state = objectArray[n2];
            this.stateCount.put((ComponentState)((Object)state), 0);
            ++n2;
        }
        this.stateCount.put(ComponentState.INSTANTIATED, dependencies.getCount());
        this.bus.addEventListener(IFatalErrorEvent.class, this.fatalErrorListener);
        this.bus.addEventListener(IResetEvent.class, this.resetEventListener);
        if (log.isLoggable(Level.INFO)) {
            log.info("In state " + (Object)((Object)this.componentState.getFlag()) + ".");
        }
    }

    public String toString() {
        if (this.getComponentId() == null) {
            return "ComponentController";
        }
        return "ComponentController[" + this.getComponentId().getToken() + "]";
    }

    @Override
    public IToken getComponentId() {
        return this.controllerId;
    }

    public IFatalErrorEvent getFatalError() {
        return this.lastFatalError;
    }

    public boolean isRunning() {
        return this.inState(ComponentState.PAUSING, ComponentState.PAUSED, ComponentState.RESUMING, ComponentState.RUNNING);
    }

    public boolean isPaused() {
        return this.inState(ComponentState.PAUSED, ComponentState.PAUSING, ComponentState.RESUMING);
    }

    public ImmutableFlag<ComponentState> getState() {
        return this.componentState.getImmutable();
    }

    public boolean inState(ComponentState ... states) {
        return ComponentState.inside(this.componentState.getFlag(), states);
    }

    public boolean notInState(ComponentState ... states) {
        return ComponentState.notInside(this.componentState.getFlag(), states);
    }

    public ComponentState awaitState(ComponentState ... states) throws ComponentKilledException {
        ComponentState resultState = (ComponentState)((Object)new WaitForFlagChange<AwaitState>((IFlag<AwaitState>)this.componentState, new AwaitState(states)).await());
        if (ComponentState.inside(resultState, ComponentState.KILLING, ComponentState.KILLED) && !ComponentState.partOf(states, ComponentState.KILLING, ComponentState.KILLED)) {
            throw new ComponentKilledException(this.component, (Object)this);
        }
        return resultState;
    }

    public ComponentState awaitState(long timeoutMillis, ComponentState ... states) throws ComponentKilledException {
        ComponentState resultState = (ComponentState)((Object)new WaitForFlagChange<AwaitState>((IFlag<AwaitState>)this.componentState, new AwaitState(states)).await(timeoutMillis, TimeUnit.MILLISECONDS));
        if (ComponentState.inside(resultState, ComponentState.KILLING, ComponentState.KILLED) && !ComponentState.partOf(states, ComponentState.KILLING, ComponentState.KILLED)) {
            throw new ComponentKilledException(this.component, (Object)this);
        }
        return resultState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void manualStart(String reason) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.notInState(ComponentState.KILLED, ComponentState.STOPPED, ComponentState.RESETED, ComponentState.INSTANTIATED)) {
                this.log.warning("Start requested, but the component is in state " + (Object)((Object)this.componentState.getFlag()) + ", unsupported.");
            } else {
                this.log.warning("Start requested.");
                if (this.inState(ComponentState.KILLED)) {
                    this.log.warning("Component is in state " + (Object)((Object)ComponentState.KILLED) + ", resetting.");
                    this.reset();
                }
                this.start(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void manualStop(String reason) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.inState(ComponentState.RUNNING, ComponentState.PAUSED)) {
                this.log.info("Stop requested, reason: " + reason);
                this.stop(true);
            } else {
                this.log.warning("Stop requested, but the component is in state " + (Object)((Object)this.componentState.getFlag()) + ", unsupported.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void manualKill(String reason) {
        Object object = this.mutex;
        synchronized (object) {
            this.log.severe("Kill requested, reason: " + reason);
            this.kill(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void manualPause(String reason) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.inState(ComponentState.RUNNING)) {
                this.log.info(String.valueOf(this.component.getComponentId().getToken()) + " pause requested, reason: " + reason);
                this.pause(true);
            } else {
                this.log.warning(String.valueOf(this.component.getComponentId().getToken()) + " pause requested, but the component is in state " + (Object)((Object)this.componentState.getFlag()) + ", unsupported.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void manualResume(String reason) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.inState(ComponentState.PAUSED)) {
                this.log.info(String.valueOf(this.component.getComponentId().getToken()) + " resume requested, reason: " + reason);
                this.resume(true);
            } else {
                this.log.warning(String.valueOf(this.component.getComponentId().getToken()) + " resume requested, but the component is in state " + (Object)((Object)this.componentState.getFlag()) + ", unsupported.");
            }
        }
    }

    public void fatalError(String message) {
        this.fatalError(message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fatalError(String message, Throwable e) {
        Flag<ComponentState> flag = this.componentState;
        synchronized (flag) {
            try {
                if (this.inState(ComponentState.KILLING, ComponentState.KILLED)) {
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.setState(ComponentState.KILLING);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            try {
                this.log.severe("Fatal error in " + this.component.getComponentId() + ": " + message);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.lastFatalError = new FatalErrorEvent<IComponent>(this.component, message, e);
            this.bus.event(this.lastFatalError);
        }
        finally {
            try {
                this.setState(ComponentState.KILLED);
            }
            catch (Exception exception) {}
        }
    }

    public boolean isDependent(IToken token) {
        return this.dependencies.isDependency(token);
    }

    public boolean isDependent(IComponent component) {
        return this.dependencies.isDependency(component);
    }

    private int getStateCount(ComponentState ... states) {
        int total = 0;
        ComponentState[] componentStateArray = states;
        int n = states.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentState state = componentStateArray[n2];
            total += this.stateCount.get((Object)state).intValue();
            ++n2;
        }
        if (total > this.dependencies.getCount()) {
            throw new IllegalStateException("Sum of ints from stateCount can't be greater than number of dependencies.");
        }
        return total;
    }

    private ComponentState getDependencyState(IComponent dependency) {
        return this.getDependencyState(dependency.getComponentId());
    }

    private ComponentState getDependencyState(IToken componentId) {
        return this.dependencyState.get(componentId);
    }

    private boolean setDependencyState(IComponent dependency, ComponentState newState) {
        return this.setDependencyState(dependency.getComponentId(), newState);
    }

    private boolean setDependencyState(IToken dependency, ComponentState newState) {
        ComponentState oldState = this.dependencyState.get(dependency);
        if (oldState == newState) {
            return false;
        }
        int count = this.stateCount.get((Object)oldState);
        if (count <= 0) {
            throw new IllegalStateException("There should not be a dependency in state " + (Object)((Object)oldState) + ", but still...");
        }
        this.stateCount.put(oldState, count - 1);
        this.dependencyState.put(dependency, newState);
        count = this.stateCount.get((Object)newState);
        this.stateCount.put(newState, count + 1);
        if (count + 1 > this.dependencies.getCount()) {
            throw new IllegalStateException("There are too many dependencies in state " + (Object)((Object)newState) + ", more than is possible...");
        }
        return true;
    }

    private boolean dependencyInState(IComponent dependency, ComponentState ... states) {
        return this.dependencyInState(dependency.getComponentId(), states);
    }

    private boolean dependencyInState(IToken componentId, ComponentState ... states) {
        ComponentState state = this.dependencyState.get(componentId);
        if (state == null) {
            return false;
        }
        ComponentState[] componentStateArray = states;
        int n = states.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentState s = componentStateArray[n2];
            if (state == s) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean dependencyNotInState(IComponent dependency, ComponentState ... states) {
        return this.dependencyInState(dependency.getComponentId(), new ComponentState[0]);
    }

    private boolean dependencyNotInState(IToken componentId, ComponentState ... states) {
        ComponentState state = this.dependencyState.get(componentId);
        if (state == null) {
            return true;
        }
        ComponentState[] componentStateArray = states;
        int n = states.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentState s = componentStateArray[n2];
            if (state == s) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private String id(IComponent component) {
        return component.getComponentId().getToken();
    }

    private void setState(ComponentState state) {
        if (state == this.componentState.getFlag()) {
            return;
        }
        this.log.finest("Switching to " + (Object)((Object)state) + ".");
        this.componentState.setFlag(state);
        this.log.info("In state " + (Object)((Object)state) + ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startingEvent(IComponentEvent event, boolean simulating) {
        Object object = this.mutex;
        synchronized (object) {
            NullCheck.check(event, "event");
            Object eventComponent = event.getSource();
            if (!this.isDependent((IComponent)eventComponent)) {
                return;
            }
            if (simulating) {
                this.log.finer("Simulating " + this.id((IComponent)eventComponent) + " starting event.");
            } else {
                this.log.finer("Received " + this.id((IComponent)eventComponent) + " starting event.");
            }
            if (this.dependencyInState((IComponent)eventComponent, ComponentState.STARTING)) {
                this.log.warning(String.valueOf(this.id((IComponent)eventComponent)) + " is broadcasting 'starting event' twice, ignoring.");
                return;
            }
            if (!this.dependencyInState((IComponent)eventComponent, ComponentState.INSTANTIATED, ComponentState.RESETED, ComponentState.STOPPED)) {
                throw new ComponentCantStartException(String.valueOf(this.id((IComponent)eventComponent)) + " is broadcasting 'starting event' while it is in state " + (Object)((Object)this.getDependencyState((IComponent)eventComponent)) + ", unsupported.", this.log, this.component);
            }
            if (this.setDependencyState((IComponent)eventComponent, ComponentState.STARTING)) {
                this.startingChangedByStartingEvent(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startedEvent(IStartedEvent event) {
        Object object = this.mutex;
        synchronized (object) {
            NullCheck.check(event, "event");
            Object eventComponent = event.getSource();
            if (!this.isDependent((IComponent)eventComponent)) {
                return;
            }
            this.log.finer("Received " + this.id((IComponent)eventComponent) + " started event.");
            if (this.dependencyInState((IComponent)eventComponent, ComponentState.RUNNING)) {
                this.log.warning(String.valueOf(this.id((IComponent)eventComponent)) + " is broadcasting 'started event' while running, ignoring.");
                return;
            }
            if (this.dependencyInState((IComponent)eventComponent, ComponentState.INSTANTIATED, ComponentState.RESETED, ComponentState.STOPPED)) {
                this.log.warning(String.valueOf(this.id((IComponent)eventComponent)) + " is broadcasting 'started event' but did not broadcast 'starting event' before, ill behavior, simulating the event.");
                this.startingEvent(event, true);
            }
            if (!this.dependencyInState((IComponent)eventComponent, ComponentState.STARTING)) {
                throw new ComponentCantStartException(String.valueOf(this.id((IComponent)eventComponent)) + " is broadcasting 'started event' while it is in state " + (Object)((Object)this.getDependencyState((IComponent)eventComponent)) + ", unsupported.", this.log, this.component);
            }
            if (this.setDependencyState((IComponent)eventComponent, ComponentState.RUNNING)) {
                this.runningChangedByStartedEvent(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pausingEvent(IComponentEvent event, boolean simulating) {
        Object object = this.mutex;
        synchronized (object) {
            NullCheck.check(event, "event");
            Object eventComponent = event.getSource();
            if (!this.isDependent((IComponent)eventComponent)) {
                return;
            }
            if (simulating) {
                this.log.finer("Simulating " + this.id((IComponent)eventComponent) + " pausing event.");
            } else {
                this.log.finer("Received " + this.id((IComponent)eventComponent) + " pausing event.");
            }
            if (this.dependencyInState((IComponent)eventComponent, ComponentState.PAUSING)) {
                this.log.warning(String.valueOf(this.id((IComponent)eventComponent)) + " is broadcasting 'pausing event' twice, ignoring.");
                return;
            }
            if (!this.dependencyInState((IComponent)eventComponent, ComponentState.RUNNING)) {
                throw new ComponentCantPauseException(String.valueOf(this.id((IComponent)eventComponent)) + " is broadcasting 'pausing event' while it is in state " + (Object)((Object)this.getDependencyState((IComponent)eventComponent)) + ", unsupported.", this.log, (Object)this.component);
            }
            if (this.setDependencyState((IComponent)eventComponent, ComponentState.PAUSING)) {
                this.pausingChangedByPausingEvent(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pausedEvent(IPausedEvent event) {
        Object object = this.mutex;
        synchronized (object) {
            NullCheck.check(event, "event");
            Object eventComponent = event.getSource();
            if (!this.isDependent((IComponent)eventComponent)) {
                return;
            }
            this.log.finer("Received " + this.id((IComponent)eventComponent) + " paused event.");
            if (this.dependencyInState((IComponent)eventComponent, ComponentState.PAUSED)) {
                this.log.warning(String.valueOf(this.id((IComponent)eventComponent)) + " is broadcasting 'paused event' twice, ignoring.");
                return;
            }
            if (this.dependencyInState((IComponent)eventComponent, ComponentState.RUNNING)) {
                this.log.warning(String.valueOf(this.id((IComponent)eventComponent)) + " is broadcasting 'paused event' but did not broadcast 'pausing event' before, ill behavior, simulating the event.");
                this.pausingEvent(event, true);
            }
            if (!this.dependencyInState((IComponent)eventComponent, ComponentState.PAUSING)) {
                throw new ComponentCantPauseException(String.valueOf(this.id((IComponent)eventComponent)) + " is broadcasting 'paused event' while it is in state " + (Object)((Object)this.getDependencyState((IComponent)eventComponent)) + ", unsupported.", this.log, (Object)this.component);
            }
            if (this.setDependencyState((IComponent)eventComponent, ComponentState.PAUSED)) {
                this.pausedChangedByPausedEvent(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumingEvent(IComponentEvent event, boolean simulating) {
        Object object = this.mutex;
        synchronized (object) {
            NullCheck.check(event, "event");
            Object eventComponent = event.getSource();
            if (!this.isDependent((IComponent)eventComponent)) {
                return;
            }
            if (simulating) {
                this.log.finer("Simulating " + this.id((IComponent)eventComponent) + " resuming event.");
            } else {
                this.log.finer("Received " + this.id((IComponent)eventComponent) + " resuming event.");
            }
            if (this.dependencyInState((IComponent)eventComponent, ComponentState.RESUMING)) {
                this.log.warning(String.valueOf(this.id((IComponent)eventComponent)) + " is broadcasting 'resuming event' twice, ignoring.");
                return;
            }
            if (!this.dependencyInState((IComponent)eventComponent, ComponentState.PAUSED)) {
                throw new ComponentCantResumeException(String.valueOf(this.id((IComponent)eventComponent)) + " is broadcasting 'resuming event' while it is in state " + (Object)((Object)this.getDependencyState((IComponent)eventComponent)) + ", unsupported.", this.log, (Object)this.component);
            }
            if (this.setDependencyState((IComponent)eventComponent, ComponentState.RESUMING)) {
                this.resumingChangedByResumingEvent(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumedEvent(IResumedEvent event) {
        Object object = this.mutex;
        synchronized (object) {
            NullCheck.check(event, "event");
            Object eventComponent = event.getSource();
            if (!this.isDependent((IComponent)eventComponent)) {
                return;
            }
            this.log.finer("Received " + this.id((IComponent)eventComponent) + " resumed event.");
            if (this.dependencyInState((IComponent)eventComponent, ComponentState.RUNNING)) {
                this.log.warning(String.valueOf(this.id((IComponent)eventComponent)) + " is broadcasting 'resumed event' while running, ignoring.");
                return;
            }
            if (this.dependencyInState((IComponent)eventComponent, ComponentState.PAUSED)) {
                this.log.warning(String.valueOf(this.id((IComponent)eventComponent)) + " is broadcasting 'resumed event' but did not broadcast 'resuming event' before, ill behavior, simulating the event.");
                this.resumingEvent(event, true);
            }
            if (!this.dependencyInState((IComponent)eventComponent, ComponentState.RESUMING)) {
                throw new ComponentCantResumeException(String.valueOf(this.id((IComponent)eventComponent)) + " is broadcasting 'resumed event' while it is in state " + (Object)((Object)this.getDependencyState((IComponent)eventComponent)) + ", unsupported.", this.log, (Object)this.component);
            }
            if (this.setDependencyState((IComponent)eventComponent, ComponentState.RUNNING)) {
                this.runningChangedByResumedEvent(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stoppingEvent(IComponentEvent event, boolean simulating) {
        Object object = this.mutex;
        synchronized (object) {
            NullCheck.check(event, "event");
            Object eventComponent = event.getSource();
            if (!this.isDependent((IComponent)eventComponent)) {
                return;
            }
            if (simulating) {
                this.log.finer("Simulating " + this.id((IComponent)eventComponent) + " stopping event.");
            } else {
                this.log.finer("Received " + this.id((IComponent)eventComponent) + " stopping event.");
            }
            if (this.dependencyInState((IComponent)eventComponent, ComponentState.STOPPING)) {
                this.log.warning(String.valueOf(this.id((IComponent)eventComponent)) + " is broadcasting 'stopping event' twice, ignoring.");
                return;
            }
            if (!this.dependencyInState((IComponent)eventComponent, ComponentState.PAUSED, ComponentState.PAUSING, ComponentState.RESUMING, ComponentState.RUNNING)) {
                throw new ComponentCantStopException(String.valueOf(this.id((IComponent)eventComponent)) + " is broadcasting 'stopping event' while it is in state " + (Object)((Object)this.getDependencyState((IComponent)eventComponent)) + ", unsupported.", this.log, (Object)this.component);
            }
            if (this.setDependencyState((IComponent)eventComponent, ComponentState.STOPPING)) {
                this.stoppingChangedByStoppingEvent(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stoppedEvent(IStoppedEvent event) {
        Object object = this.mutex;
        synchronized (object) {
            NullCheck.check(event, "event");
            Object eventComponent = event.getSource();
            if (!this.isDependent((IComponent)eventComponent)) {
                return;
            }
            this.log.finer("Received " + this.id((IComponent)eventComponent) + " stopped event.");
            if (this.dependencyInState((IComponent)eventComponent, ComponentState.STOPPED)) {
                this.log.warning(String.valueOf(this.id((IComponent)eventComponent)) + " is broadcasting 'stopped event' twice, ignoring.");
                return;
            }
            if (this.dependencyInState((IComponent)eventComponent, ComponentState.PAUSED, ComponentState.PAUSING, ComponentState.RESUMING, ComponentState.RUNNING)) {
                this.log.warning(String.valueOf(this.id((IComponent)eventComponent)) + " is broadcasting 'stopped event' but did not broadcast 'stopping event' before, ill behavior, simulating the event.");
                this.stoppingEvent(event, true);
            }
            if (!this.dependencyInState((IComponent)eventComponent, ComponentState.STOPPING)) {
                throw new ComponentCantStopException(String.valueOf(this.id((IComponent)eventComponent)) + " is broadcasting 'stopped event' while it is in state " + (Object)((Object)this.getDependencyState((IComponent)eventComponent)) + ", unsupported.", this.log, (Object)this.component);
            }
            if (this.setDependencyState((IComponent)eventComponent, ComponentState.STOPPED)) {
                this.stoppedChangedByStoppedEvent(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fatalErrorEvent(IFatalErrorEvent event) {
        Object object = this.mutex;
        synchronized (object) {
            if (event.getSource() == this.component) {
                this.log.finer("Fatal error received from the controlled component, discarding.");
                return;
            }
            this.lastFatalError = event;
            this.log.severe("Received fatal error from " + this.id((IComponent)event.getSource()) + ".");
            this.componentFatalError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetEvent(IResetEvent event) {
        Object object = this.mutex;
        synchronized (object) {
            this.log.warning("Received reset event.");
            this.reset();
        }
    }

    private void startingChangedByStartingEvent(IComponentEvent event) {
        if (this.dependencies.getType() == ComponentDependencyType.STARTS_AFTER) {
            return;
        }
        if (this.getStateCount(ComponentState.STARTING, ComponentState.RESUMING, ComponentState.RUNNING) == this.dependencies.getCount()) {
            if (this.inState(ComponentState.STOPPED, ComponentState.RESETED, ComponentState.INSTANTIATED)) {
                this.log.info("All dependencies are starting/resuming/has started, starting the component.");
                this.start(false);
            } else {
                throw new ComponentCantStartException("All dependencies are starting/resuming/has started, but can't start the component, it's in an ill state " + (Object)((Object)this.componentState.getFlag()) + ".", this.log, this.component);
            }
        }
    }

    private void runningChangedByStartedEvent(IStartedEvent event) {
        if (this.dependencies.getType() == ComponentDependencyType.STARTS_WITH) {
            return;
        }
        if (this.getStateCount(ComponentState.RUNNING) == this.dependencies.getCount()) {
            if (this.inState(ComponentState.STOPPED, ComponentState.RESETED, ComponentState.INSTANTIATED)) {
                this.log.info("All dependencies has started/resumed, starting the component.");
                this.start(false);
            } else {
                throw new ComponentCantStartException("All dependencies has started/resumed, but can't start the component, it's in an ill state " + (Object)((Object)this.componentState.getFlag()) + ".", this.log, this.component);
            }
        }
    }

    private void runningChangedByResumedEvent(IResumedEvent event) {
        if (this.dependencies.getType() == ComponentDependencyType.STARTS_WITH) {
            return;
        }
        if (this.getStateCount(ComponentState.RUNNING) == this.dependencies.getCount()) {
            if (this.inState(ComponentState.STOPPED, ComponentState.RESETED, ComponentState.INSTANTIATED)) {
                this.log.info("All dependencies has started/resumed, starting the component.");
                this.start(false);
            } else if (this.inState(ComponentState.PAUSED)) {
                this.log.info("All dependencies has started/resumed, resuming the component.");
                this.resume(false);
            } else {
                throw new ComponentCantStartException("All dependencies has started/resumed, but can't start/resume the component, it's in an ill state " + (Object)((Object)this.componentState.getFlag()) + ".", this.log, this.component);
            }
        }
    }

    private void pausingChangedByPausingEvent(IComponentEvent event) {
        if (this.inState(ComponentState.RUNNING)) {
            this.log.info("Dependency " + this.id((IComponent)event.getSource()) + " is pausing, pausing the component.");
            this.pause(false);
        }
    }

    private void pausedChangedByPausedEvent(IPausedEvent event) {
        if (this.inState(ComponentState.RUNNING)) {
            this.log.info("Dependency " + this.id((IComponent)event.getSource()) + " has paused, pausing the component.");
            this.pause(false);
        }
    }

    private void resumingChangedByResumingEvent(IComponentEvent event) {
        if (this.dependencies.getType() == ComponentDependencyType.STARTS_AFTER) {
            return;
        }
        if (this.getStateCount(ComponentState.STARTING, ComponentState.RESUMING, ComponentState.RUNNING) == this.dependencies.getCount()) {
            if (this.inState(ComponentState.STOPPED, ComponentState.RESETED, ComponentState.INSTANTIATED)) {
                this.log.info("All dependencies has started/resumed, starting the component.");
                this.start(false);
            } else if (this.inState(ComponentState.PAUSED)) {
                this.log.info("All dependencies are starting/resuming/has started, resuming the component.");
                this.resume(false);
            } else {
                throw new ComponentCantResumeException("All dependencies are starting/resuming/has started, but can't resume the component, it's in an ill state " + (Object)((Object)this.componentState.getFlag()) + ".", this.log, (Object)this.component);
            }
        }
    }

    private void stoppingChangedByStoppingEvent(IComponentEvent event) {
        if (this.inState(ComponentState.PAUSED, ComponentState.PAUSING, ComponentState.RESUMING, ComponentState.RUNNING)) {
            this.log.info("Dependency " + this.id((IComponent)event.getSource()) + " is stopping, stopping the component.");
            this.stop(false);
        }
    }

    private void stoppedChangedByStoppedEvent(IStoppedEvent event) {
        if (this.inState(ComponentState.PAUSED, ComponentState.PAUSING, ComponentState.RESUMING, ComponentState.RUNNING)) {
            this.log.info("Dependency " + this.id((IComponent)event.getSource()) + " is stopping, stopping the component.");
            this.stop(false);
        }
    }

    private void componentFatalError() {
        switch (this.componentState.getFlag()) {
            case INSTANTIATED: {
                this.log.warning("Component is in instantiated state, won't call kill().");
                return;
            }
            case RESETED: {
                this.log.warning("Component is resetted, won't call kill().");
                return;
            }
            case KILLED: {
                this.log.warning("Component has been already killed, won't call kill().");
                return;
            }
        }
        this.kill(false);
    }

    private void start(boolean manual) {
        this.setState(ComponentState.STARTING);
        this.log.fine("Sending " + this.component.getComponentId().getToken() + " starting event (transactional).");
        this.componentEvents.startingTransactional();
        this.log.fine("Calling " + this.component.getComponentId().getToken() + ".start().");
        this.control.start();
        this.log.info(String.valueOf(this.component.getComponentId().getToken()) + ".start()ed.");
        this.setState(ComponentState.RUNNING);
        this.log.fine("Sending " + this.component.getComponentId().getToken() + " started event (transactional).");
        this.componentEvents.startedTransactional();
    }

    private void pause(boolean manual) {
        this.setState(ComponentState.PAUSING);
        this.log.fine("Calling " + this.component.getComponentId().getToken() + ".prePause().");
        this.control.prePause();
        this.log.fine("Sending " + this.component.getComponentId().getToken() + " pausing event (transactional).");
        this.componentEvents.pausingTransactional();
        this.log.fine("Calling " + this.component.getComponentId().getToken() + ".pause().");
        this.control.pause();
        this.log.info(String.valueOf(this.component.getComponentId().getToken()) + ".paused()ed.");
        this.setState(ComponentState.PAUSED);
        this.log.fine("Sending " + this.component.getComponentId().getToken() + " paused event (transactional).");
        this.componentEvents.pausedTransactional();
    }

    private void resume(boolean manual) {
        this.setState(ComponentState.RESUMING);
        this.log.fine("Sending " + this.component.getComponentId().getToken() + " resuming event (transactional).");
        this.componentEvents.resumingTransactional();
        this.log.fine("Calling " + this.component.getComponentId().getToken() + ".resume().");
        this.control.resume();
        this.log.info(String.valueOf(this.component.getComponentId().getToken()) + ".resum()ed.");
        this.setState(ComponentState.RUNNING);
        this.log.fine("Sending " + this.component.getComponentId().getToken() + " resumed event (transactional).");
        this.componentEvents.resumedTransactional();
    }

    private void stop(boolean manual) {
        this.setState(ComponentState.STOPPING);
        this.log.fine("Calling " + this.component.getComponentId().getToken() + ".preStop().");
        this.control.preStop();
        this.log.fine("Sending " + this.component.getComponentId().getToken() + " stopping event (transactional).");
        this.componentEvents.stoppingTransactional();
        this.log.fine("Calling " + this.component.getComponentId().getToken() + ".stop().");
        this.control.stop();
        this.log.info(String.valueOf(this.component.getComponentId().getToken()) + ".stop()ed.");
        this.setState(ComponentState.STOPPED);
        this.componentEvents.stoppedTransactional();
    }

    private void kill(boolean manual) {
        try {
            this.setState(ComponentState.KILLING);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.log.warning("Calling " + this.component.getComponentId().getToken() + ".kill().");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.control.kill();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.log.severe(String.valueOf(this.component.getComponentId().getToken()) + ".kill()ed.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.setState(ComponentState.KILLED);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void reset() {
        this.setState(ComponentState.RESETING);
        this.log.fine("Reseting " + this.component.getComponentId().getToken() + "'s controller.");
        this.resetController();
        this.log.info(String.valueOf(this.component.getComponentId().getToken()) + "'s controller reseted.");
        this.log.fine("Calling " + this.component.getComponentId().getToken() + ".reset().");
        this.control.reset();
        this.log.info(String.valueOf(this.component.getComponentId().getToken()) + ".reset()ed.");
        this.setState(ComponentState.RESETED);
    }

    private void resetController() {
        Object[] objectArray = this.dependencies.getDependencies();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IToken dependency = objectArray[n2];
            this.dependencyState.put(dependency, ComponentState.RESETED);
            ++n2;
        }
        objectArray = ComponentState.values();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            IToken state = objectArray[n2];
            this.stateCount.put((ComponentState)((Object)state), 0);
            ++n2;
        }
        this.stateCount.put(ComponentState.RESETED, this.dependencies.getCount());
        this.lastFatalError = null;
    }

    private static class AwaitState
    implements WaitForFlagChange.IAccept<ComponentState> {
        Set<ComponentState> awaiting = new HashSet<ComponentState>();

        public AwaitState(ComponentState ... states) {
            ComponentState[] componentStateArray = states;
            int n = states.length;
            int n2 = 0;
            while (n2 < n) {
                ComponentState state = componentStateArray[n2];
                this.awaiting.add(state);
                ++n2;
            }
        }

        @Override
        public boolean accept(ComponentState flagValue) {
            return this.awaiting.contains((Object)flagValue);
        }
    }
}

