/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.component.bus.event;

import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.IComponentEvent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentEventListener;
import cz.cuni.amis.pogamut.base.component.bus.event.IFatalErrorEvent;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.token.Token;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class WaitForEvent {
    private final CountDownLatch eventLatch = new CountDownLatch(1);
    private final IComponentBus componentBus;
    private final IAcceptEvent acceptEvent;
    private final IComponentEventListener listener;
    private final IComponentEventListener fatalErrorListener;
    private boolean fatalError = false;

    public WaitForEvent(IComponentBus bus, IAcceptEvent accept) {
        this.componentBus = bus;
        NullCheck.check(this.componentBus, "bus");
        this.acceptEvent = accept;
        NullCheck.check(accept.getEventClass(), "accept.getEventClass()");
        this.listener = new IComponentEventListener<IComponentEvent>(){

            @Override
            public void notify(IComponentEvent event) {
                if (WaitForEvent.this.acceptEvent.accept(WaitForEvent.this.acceptEvent.getEventClass().cast(event))) {
                    try {
                        WaitForEvent.this.componentBus.removeEventListener(WaitForEvent.this.acceptEvent.getEventClass(), this);
                        WaitForEvent.this.componentBus.removeEventListener(IFatalErrorEvent.class, WaitForEvent.this.fatalErrorListener);
                    }
                    finally {
                        WaitForEvent.this.eventLatch.countDown();
                    }
                }
            }
        };
        this.fatalErrorListener = new IComponentEventListener<IComponentEvent>(){

            @Override
            public void notify(IComponentEvent event) {
                WaitForEvent.this.fatalError = true;
                try {
                    WaitForEvent.this.componentBus.removeEventListener(WaitForEvent.this.acceptEvent.getEventClass(), this);
                    WaitForEvent.this.componentBus.removeEventListener(IFatalErrorEvent.class, WaitForEvent.this.fatalErrorListener);
                }
                finally {
                    WaitForEvent.this.eventLatch.countDown();
                }
            }
        };
        if (!this.componentBus.isRunning()) {
            this.fatalError = true;
            this.eventLatch.countDown();
        } else {
            this.componentBus.addEventListener(IFatalErrorEvent.class, this.fatalErrorListener);
            this.componentBus.addEventListener(this.acceptEvent.getEventClass(), this.listener);
            if (!this.componentBus.isRunning()) {
                this.fatalError = true;
                this.eventLatch.countDown();
                try {
                    try {
                        this.componentBus.removeEventListener(IFatalErrorEvent.class, this.fatalErrorListener);
                    }
                    catch (Exception exception) {
                        try {
                            this.componentBus.removeEventListener(this.acceptEvent.getEventClass(), this.listener);
                        }
                        catch (Exception exception2) {}
                    }
                }
                finally {
                    try {
                        this.componentBus.removeEventListener(this.acceptEvent.getEventClass(), this.listener);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public boolean await() throws PogamutInterruptedException {
        try {
            this.eventLatch.await();
            return !this.fatalError;
        }
        catch (InterruptedException e) {
            throw new PogamutInterruptedException(e, (Object)this);
        }
    }

    public boolean await(long timeoutMillis) throws PogamutInterruptedException {
        try {
            this.eventLatch.await(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new PogamutInterruptedException(e, (Object)this);
        }
        return !this.fatalError && this.eventLatch.getCount() == 0L;
    }

    public void destroy() {
        this.componentBus.removeEventListener(this.acceptEvent.getEventClass(), this.listener);
        this.eventLatch.countDown();
    }

    public static interface IAcceptEvent<T> {
        public Class<T> getEventClass();

        public Class getComponentClass();

        public Token getComponentId();

        public boolean accept(T var1);
    }
}

