/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.component.bus.event;

import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.IComponentEventListener;
import cz.cuni.amis.pogamut.base.component.bus.event.IFatalErrorEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IStoppedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IStoppingEvent;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.token.IToken;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class BusAwareCountDownLatch
extends CountDownLatch {
    private final IComponentBus bus;
    private final IToken[] componentIds;
    private boolean stoppedEvent = false;
    private Object stopMutex = new Object();
    private boolean removed = false;
    private IComponentEventListener componentListener = new IComponentEventListener(){

        @Override
        public void notify(Object event) {
            BusAwareCountDownLatch.this.stopped();
        }
    };

    private static IToken[] getTokens(IComponent ... components) {
        if (components == null) {
            return null;
        }
        IToken[] tokens = new IToken[components.length];
        int i = 0;
        IComponent[] iComponentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            IComponent component = iComponentArray[n2];
            tokens[i++] = component.getComponentId();
            ++n2;
        }
        return tokens;
    }

    public BusAwareCountDownLatch(int count, IComponentBus bus) {
        this(count, bus, (IToken[])null);
    }

    public BusAwareCountDownLatch(int count, IComponentBus bus, IComponent ... components) {
        this(count, bus, BusAwareCountDownLatch.getTokens(components));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public BusAwareCountDownLatch(int count, IComponentBus bus, IToken ... componentIds) {
        super(count);
        this.bus = bus;
        NullCheck.check(bus, "bus");
        this.componentIds = componentIds;
        NullCheck.check(componentIds, "componentIds");
        if (!bus.isRunning()) {
            this.removed = true;
            this.stopped();
            return;
        }
        if (count > 0) {
            this.removed = false;
            bus.addEventListener(IFatalErrorEvent.class, this.componentListener);
            IToken[] iTokenArray = this.componentIds;
            // MONITORENTER : this.componentIds
            IToken[] iTokenArray2 = componentIds;
            int n = componentIds.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    // MONITOREXIT : iTokenArray
                    break;
                }
                IToken componentId = iTokenArray2[n2];
                bus.addEventListener(IStoppingEvent.class, componentId, this.componentListener);
                bus.addEventListener(IStoppedEvent.class, componentId, this.componentListener);
                ++n2;
            }
        }
        if (bus.isRunning()) return;
        this.stopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopped() {
        if (this.stoppedEvent) {
            return;
        }
        Object object = this.stopMutex;
        synchronized (object) {
            if (this.stoppedEvent) {
                return;
            }
            this.stoppedEvent = true;
        }
        this.removeListeners();
        this.totalCountDown();
    }

    private void totalCountDown() {
        while (this.getCount() > 0L) {
            this.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void removeListeners() {
        if (this.removed) {
            return;
        }
        IToken[] iTokenArray = this.componentListener;
        synchronized (this.componentListener) {
            if (this.removed) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.removed = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.bus.removeEventListener(IFatalErrorEvent.class, this.componentListener);
            if (this.componentIds == null) return;
            iTokenArray = this.componentIds;
            synchronized (this.componentIds) {
                IToken[] iTokenArray2 = this.componentIds;
                int n = this.componentIds.length;
                int n2 = 0;
                while (n2 < n) {
                    IToken token = iTokenArray2[n2];
                    this.bus.removeEventListener(IStoppingEvent.class, token, this.componentListener);
                    this.bus.removeEventListener(IStoppedEvent.class, token, this.componentListener);
                    ++n2;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    @Override
    public void countDown() {
        super.countDown();
        if (this.getCount() <= 0L) {
            this.removeListeners();
        }
    }

    @Override
    public void await() throws BusStoppedInterruptedException, PogamutInterruptedException {
        try {
            super.await();
        }
        catch (InterruptedException e) {
            throw new PogamutInterruptedException(e, (Object)this);
        }
        this.checkBusStop();
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws BusStoppedInterruptedException, PogamutInterruptedException {
        boolean val;
        try {
            val = super.await(timeout, unit);
        }
        catch (InterruptedException e) {
            throw new PogamutInterruptedException(e, (Object)this);
        }
        this.checkBusStop();
        return val;
    }

    protected void checkBusStop() throws BusStoppedInterruptedException {
        if (this.stoppedEvent) {
            throw new BusStoppedInterruptedException(this);
        }
    }

    @Override
    public String toString() {
        return "BusAwareCountDownLatch";
    }

    public static class BusStoppedInterruptedException
    extends PogamutInterruptedException {
        public BusStoppedInterruptedException(Object origin) {
            super("Interrupted because bus was stopped (fatal error, or watched component stopped) while waiting on the latch.", origin);
        }
    }
}

