/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.component.bus;

import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.ComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.IComponentEventListener;
import cz.cuni.amis.pogamut.base.component.bus.event.IStartedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.StartedEvent;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.utils.StopWatch;
import cz.cuni.amis.utils.maps.LazyMap;
import cz.cuni.amis.utils.sets.ConcurrentLinkedHashSet;
import cz.cuni.amis.utils.token.IToken;
import cz.cuni.amis.utils.token.Tokens;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import org.junit.Assert;
import org.junit.Test;

public class Test06_ComponentBus {
    private static final IToken[] TOKENS = new IToken[]{Tokens.get("token1"), Tokens.get("token2"), Tokens.get("token3")};
    private CountDownLatch latch;

    @Test
    public void test() {
        AgentId agentId = new AgentId("Test06_ComponentBus");
        AgentLogger logger = new AgentLogger(agentId);
        logger.setLevel(Level.OFF);
        ComponentBus bus = new ComponentBus(logger);
        ConcurrentLinkedHashSet set = new ConcurrentLinkedHashSet();
        Thread[] threads = new Thread[32];
        int i = 0;
        while (i < threads.length) {
            threads[i] = new Thread(new BusManager(bus, i + 1));
            ++i;
        }
        this.latch = new CountDownLatch(threads.length);
        StopWatch watch = new StopWatch();
        int i2 = 0;
        while (i2 < threads.length) {
            threads[i2].start();
            ++i2;
        }
        try {
            this.latch.await();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Exception waiting for threads...");
        }
        System.out.println("Total time: " + watch.stopStr());
        System.out.println("---/// TEST OK ///---");
    }

    public static void main(String[] args) {
        Test06_ComponentBus test = new Test06_ComponentBus();
        test.test();
    }

    private class BusManager
    implements Runnable {
        private Random random = new Random(System.currentTimeMillis());
        private IComponentBus bus;
        private int num;
        private int notified = 0;
        private Map<IToken, Set<IComponentEventListener<IStartedEvent>>> listeners = new LazyMap<IToken, Set<IComponentEventListener<IStartedEvent>>>(){

            @Override
            protected Set<IComponentEventListener<IStartedEvent>> create(IToken key) {
                return new HashSet<IComponentEventListener<IStartedEvent>>();
            }
        };

        private void addListener() {
            IToken token = TOKENS[this.random.nextInt(TOKENS.length)];
            IComponentEventListener<IStartedEvent> listener = new IComponentEventListener<IStartedEvent>(){

                @Override
                public void notify(IStartedEvent event) {
                    BusManager busManager = BusManager.this;
                    busManager.notified = busManager.notified + 1;
                }
            };
            this.bus.addEventListener(IStartedEvent.class, listener);
            this.listeners.get(token).add(listener);
        }

        private void removeListener() {
            IToken token = TOKENS[this.random.nextInt(TOKENS.length)];
            Set<IComponentEventListener<IStartedEvent>> set = this.listeners.get(token);
            if (set.size() > 0) {
                IComponentEventListener<IStartedEvent> listener = set.iterator().next();
                this.bus.removeEventListener(IStartedEvent.class, listener);
                set.remove(listener);
            }
        }

        private void event() {
            final IToken token = TOKENS[this.random.nextInt(TOKENS.length)];
            this.bus.event(new StartedEvent<3>(new IComponent(){

                @Override
                public IToken getComponentId() {
                    return token;
                }
            }));
        }

        public BusManager(IComponentBus bus, int num) {
            this.bus = bus;
            this.num = num;
        }

        @Override
        public void run() {
            StopWatch watch = new StopWatch();
            this.addListener();
            this.event();
            int i = 0;
            while (i < 1000) {
                switch (this.random.nextInt(6)) {
                    case 0: {
                        try {
                            Thread.sleep(2L);
                        }
                        catch (InterruptedException interruptedException) {}
                        break;
                    }
                    case 1: {
                        this.addListener();
                        break;
                    }
                    case 2: {
                        this.addListener();
                        break;
                    }
                    case 3: {
                        this.removeListener();
                        break;
                    }
                    case 4: {
                        this.event();
                        break;
                    }
                    case 5: {
                        this.event();
                    }
                }
                ++i;
            }
            System.out.println("Thread " + this.num + ": notified = " + this.notified + ".");
            System.out.println("Thread " + this.num + ": 2000 operations took " + watch.stopStr());
            Test06_ComponentBus.this.latch.countDown();
            Assert.assertTrue((String)("At least one notification of thread " + this.num + " listener must go through."), (this.notified > 0 ? 1 : 0) != 0);
        }
    }
}

