/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.component.bus;

import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.component.bus.ComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.IComponentEvent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentEventListener;
import cz.cuni.amis.pogamut.base.component.bus.event.IFatalErrorEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IPausedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IStartedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IStartingEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IStoppedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.PausedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.PausingEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.ResumedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.ResumingEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.StartedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.StartingEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.StoppedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.StoppingEvent;
import cz.cuni.amis.pogamut.base.component.stub.AutoCheckComponent;
import cz.cuni.amis.pogamut.base.component.stub.CheckEvent;
import cz.cuni.amis.pogamut.base.component.stub.ManualCheckComponent;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.utils.token.Tokens;
import java.util.logging.Level;
import org.junit.Test;

public class Test02_ComponentBus {
    @Test
    public void test() {
        AgentId agentId = new AgentId("Test02_ComponentBus");
        AgentLogger logger = new AgentLogger(agentId);
        logger.addDefaultConsoleHandler();
        logger.setLevel(Level.ALL);
        ComponentBus bus = new ComponentBus(logger);
        AutoCheckComponent autoComp0 = new AutoCheckComponent(logger, bus);
        final ManualCheckComponent manualComp0 = new ManualCheckComponent(logger, bus);
        final ManualCheckComponent manualComp1 = new ManualCheckComponent(logger, bus);
        final ManualCheckComponent manualComp2 = new ManualCheckComponent(logger, bus);
        final ManualCheckComponent manualComp3 = new ManualCheckComponent(logger, bus);
        final ManualCheckComponent manualComp4 = new ManualCheckComponent(logger, bus);
        final ManualCheckComponent manualComp5 = new ManualCheckComponent(logger, bus);
        IComponentEvent[] events = new IComponentEvent[]{new StartingEvent<AutoCheckComponent>(autoComp0), new StartedEvent<AutoCheckComponent>(autoComp0), new PausingEvent<AutoCheckComponent>(autoComp0), new PausedEvent<AutoCheckComponent>(autoComp0), new ResumingEvent<AutoCheckComponent>(autoComp0), new ResumedEvent<AutoCheckComponent>(autoComp0), new StoppingEvent<AutoCheckComponent>(autoComp0), new StoppedEvent<AutoCheckComponent>(autoComp0)};
        CheckEvent[] checkEvents = new CheckEvent[events.length];
        int i = 0;
        while (i < events.length) {
            checkEvents[i] = new CheckEvent(events[i]);
            ++i;
        }
        autoComp0.expect(checkEvents);
        IComponentEventListener<IComponentEvent> listener2 = new IComponentEventListener<IComponentEvent>(){

            @Override
            public void notify(IComponentEvent event) {
                manualComp0.manualNotify(event);
            }
        };
        IComponentEventListener<IComponentEvent> listener3 = new IComponentEventListener<IComponentEvent>(){

            @Override
            public void notify(IComponentEvent event) {
                manualComp1.manualNotify(event);
            }
        };
        IComponentEventListener<IComponentEvent> listener4 = new IComponentEventListener<IComponentEvent>(){

            @Override
            public void notify(IComponentEvent event) {
                manualComp2.manualNotify(event);
            }
        };
        IComponentEventListener<IComponentEvent> listener5 = new IComponentEventListener<IComponentEvent>(){

            @Override
            public void notify(IComponentEvent event) {
                manualComp3.manualNotify(event);
            }
        };
        IComponentEventListener<IComponentEvent> listener6 = new IComponentEventListener<IComponentEvent>(){

            @Override
            public void notify(IComponentEvent event) {
                manualComp4.manualNotify(event);
            }
        };
        IComponentEventListener<IComponentEvent> listener7 = new IComponentEventListener<IComponentEvent>(){

            @Override
            public void notify(IComponentEvent event) {
                manualComp5.manualNotify(event);
            }
        };
        bus.addEventListener(IComponentEvent.class, autoComp0.getClass(), listener2);
        manualComp0.expect(checkEvents);
        bus.addEventListener(IStartedEvent.class, autoComp0.getClass(), listener3);
        manualComp1.expect(checkEvents[1]);
        bus.addEventListener(IStoppedEvent.class, autoComp0.getClass(), listener4);
        manualComp2.expect(checkEvents[7]);
        bus.addEventListener(IFatalErrorEvent.class, listener5);
        bus.addEventListener(IStartingEvent.class, Test02_ComponentBus.class, listener6);
        bus.addEventListener(IPausedEvent.class, Tokens.get("No_Component"), listener7);
        IComponentEvent[] iComponentEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentEvent event = iComponentEventArray[n2];
            bus.event(event);
            ++n2;
        }
        autoComp0.checkExpectEmpty();
        manualComp0.checkExpectEmpty();
        manualComp1.checkExpectEmpty();
        manualComp2.checkExpectEmpty();
        manualComp3.checkExpectEmpty();
        manualComp4.checkExpectEmpty();
        manualComp5.checkExpectEmpty();
        System.out.println("---/// TEST OK ///---");
    }

    public static void main(String[] args) {
        Test02_ComponentBus test = new Test02_ComponentBus();
        test.test();
    }
}

