/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.worldview.object;

import cz.cuni.amis.utils.token.Token;
import cz.cuni.amis.utils.token.Tokens;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class WorldObjectId
implements Serializable {
    protected Token token;
    private static Map<String, WorldObjectId> map = new HashMap<String, WorldObjectId>();
    private static Map<Long, WorldObjectId> mapLong = new HashMap<Long, WorldObjectId>();

    protected WorldObjectId(String name) {
        this.token = Tokens.get(name);
    }

    protected WorldObjectId(long id) {
        this.token = Tokens.get(id);
    }

    protected WorldObjectId(Token token) {
        this.token = token;
    }

    public int hashCode() {
        return this.token.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof WorldObjectId)) {
            return false;
        }
        return this.token.equals(((WorldObjectId)o).token);
    }

    public String getStringId() {
        return this.token.getToken();
    }

    public long getLongId() {
        return Long.parseLong(this.token.getToken());
    }

    public String toString() {
        return "WorldObjectId[" + this.getStringId() + "]";
    }

    public static synchronized WorldObjectId get(String name) {
        WorldObjectId id = null;
        id = map.get(name);
        if (id != null) {
            return id;
        }
        id = new WorldObjectId(name);
        map.put(name, id);
        return id;
    }

    public static synchronized WorldObjectId get(long objId) {
        WorldObjectId id = null;
        id = mapLong.get(objId);
        if (id != null) {
            return id;
        }
        id = new WorldObjectId(objId);
        mapLong.put(objId, id);
        return id;
    }
}

