/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.IListenerRegistrator;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.ListenerLevel;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.EventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectClassEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectClassListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.exception.ListenerMethodParametersException;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.exception.MissingConstructorException;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.exception.MoreThanOneListenerLevelAnnotationException;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.exception.ListenersAlreadyRegisteredException;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.utils.ClassUtils;
import cz.cuni.amis.utils.Lazy;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.maps.LazyMap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class AnnotationListenerRegistrator
implements IListenerRegistrator {
    private IWorldView worldView;
    private Object obj;
    private boolean listenersRegistered = false;
    private Lazy<List<Method>> methods = new Lazy<List<Method>>(){

        @Override
        protected List<Method> create() {
            return AnnotationListenerRegistrator.this.probeMethods();
        }
    };
    private Map<ListenerLevel, List<IWorldEventListener>> listeners = new LazyMap<ListenerLevel, List<IWorldEventListener>>(){

        @Override
        protected List<IWorldEventListener> create(ListenerLevel key) {
            return new ArrayList<IWorldEventListener>();
        }
    };
    private Logger log;

    public static WorldObjectId getId(Method method, ObjectListener annotation) {
        try {
            return annotation.idClass().getConstructor(String.class).newInstance(annotation.objectId());
        }
        catch (Exception e) {
            throw new MissingConstructorException(method, annotation.idClass(), AnnotationListenerRegistrator.class);
        }
    }

    public static WorldObjectId getId(Method method, ObjectEventListener annotation) {
        try {
            return annotation.idClass().getConstructor(String.class).newInstance(annotation.objectId());
        }
        catch (Exception e) {
            throw new MissingConstructorException(method, annotation.idClass(), AnnotationListenerRegistrator.class);
        }
    }

    public static ListenerLevel getListenerLevel(Method method) {
        ListenerLevel level = null;
        if (method.isAnnotationPresent(EventListener.class)) {
            level = ListenerLevel.A;
        }
        if (method.isAnnotationPresent(ObjectClassListener.class)) {
            if (level != null) {
                throw new MoreThanOneListenerLevelAnnotationException(method, AnnotationListenerRegistrator.class);
            }
            level = ListenerLevel.B;
        }
        if (method.isAnnotationPresent(ObjectClassEventListener.class)) {
            if (level != null) {
                throw new MoreThanOneListenerLevelAnnotationException(method, AnnotationListenerRegistrator.class);
            }
            level = ListenerLevel.C;
        }
        if (method.isAnnotationPresent(ObjectListener.class)) {
            if (level != null) {
                throw new MoreThanOneListenerLevelAnnotationException(method, AnnotationListenerRegistrator.class);
            }
            level = ListenerLevel.D;
        }
        if (method.isAnnotationPresent(ObjectEventListener.class)) {
            if (level != null) {
                throw new MoreThanOneListenerLevelAnnotationException(method, AnnotationListenerRegistrator.class);
            }
            level = ListenerLevel.E;
        }
        return level;
    }

    public AnnotationListenerRegistrator(Object obj, IWorldView worldView, Logger log) {
        this.worldView = worldView;
        NullCheck.check(this.worldView, "worldView");
        this.obj = obj;
        NullCheck.check(this.obj, "obj");
        this.log = log;
        NullCheck.check(this.log, "log");
    }

    private List<Method> probeMethods() {
        ArrayList<Method> methods = new ArrayList<Method>();
        Method[] methodArray = this.obj.getClass().getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (AnnotationListenerRegistrator.getListenerLevel(method) != null) {
                methods.add(method);
            }
            ++n2;
        }
        return methods;
    }

    @Override
    public synchronized void addListeners() throws ListenersAlreadyRegisteredException {
        if (this.listenersRegistered) {
            throw new ListenersAlreadyRegisteredException(this);
        }
        this.log.finer(this.obj + " -> " + this.worldView + ": Registering listeners.");
        for (Method method : this.methods.getVal()) {
            switch (AnnotationListenerRegistrator.getListenerLevel(method)) {
                case A: {
                    this.log.fine(this.obj + " -> " + this.worldView + ": Registering level A listener for " + ClassUtils.getMethodSignature(method));
                    LevelAListener listenerA = new LevelAListener(method);
                    this.worldView.addEventListener(listenerA.getEventClass(), listenerA);
                    this.listeners.get((Object)ListenerLevel.A).add(listenerA);
                    break;
                }
                case B: {
                    this.log.fine(this.obj + " -> " + this.worldView + ": Registering level B listener for " + ClassUtils.getMethodSignature(method));
                    LevelBListener listenerB = new LevelBListener(method);
                    this.worldView.addObjectListener(listenerB.getObjectClass(), listenerB);
                    this.listeners.get((Object)ListenerLevel.B).add(listenerB);
                    break;
                }
                case C: {
                    this.log.fine(this.obj + " -> " + this.worldView + ": Registering level C listener for " + ClassUtils.getMethodSignature(method));
                    LevelCListener listenerC = new LevelCListener(method);
                    this.worldView.addObjectListener(listenerC.getObjectClass(), listenerC.getEventClass(), listenerC);
                    this.listeners.get((Object)ListenerLevel.C).add(listenerC);
                    break;
                }
                case D: {
                    this.log.fine(this.obj + " -> " + this.worldView + ": Registering level D listener for " + ClassUtils.getMethodSignature(method));
                    LevelDListener listenerD = new LevelDListener(method);
                    this.worldView.addObjectListener(listenerD.getObjectId(), listenerD);
                    this.listeners.get((Object)ListenerLevel.D).add(listenerD);
                    break;
                }
                case E: {
                    this.log.fine(this.obj + " -> " + this.worldView + ": Registering level E listener for " + ClassUtils.getMethodSignature(method));
                    LevelEListener listenerE = new LevelEListener(method);
                    this.worldView.addObjectListener(listenerE.getObjectId(), listenerE.getEventClass(), listenerE);
                    this.listeners.get((Object)ListenerLevel.E).add(listenerE);
                }
            }
        }
        this.log.info(this.obj + " -> " + this.worldView + ": Registered " + this.listeners.size() + " listeners.");
    }

    public int getListenersCount() {
        return this.listeners.get((Object)ListenerLevel.A).size() + this.listeners.get((Object)ListenerLevel.B).size() + this.listeners.get((Object)ListenerLevel.C).size() + this.listeners.get((Object)ListenerLevel.D).size() + this.listeners.get((Object)ListenerLevel.E).size();
    }

    @Override
    public synchronized void removeListeners() {
        if (!this.listenersRegistered) {
            return;
        }
        this.log.finer(this.obj + " -> " + this.worldView + ": Removing " + this.getListenersCount() + " listeners.");
        for (IWorldEventListener l : this.listeners.get((Object)ListenerLevel.A)) {
            LevelAListener listenerA = (LevelAListener)l;
            this.worldView.removeEventListener(listenerA.getEventClass(), listenerA);
        }
        for (IWorldEventListener l : this.listeners.get((Object)ListenerLevel.B)) {
            LevelBListener listenerB = (LevelBListener)l;
            this.worldView.removeObjectListener(listenerB.getObjectClass(), listenerB);
        }
        for (IWorldEventListener l : this.listeners.get((Object)ListenerLevel.C)) {
            LevelCListener listenerC = (LevelCListener)l;
            this.worldView.removeObjectListener(listenerC.getObjectClass(), listenerC.getEventClass(), listenerC);
        }
        for (IWorldEventListener l : this.listeners.get((Object)ListenerLevel.D)) {
            LevelDListener listenerD = (LevelDListener)l;
            this.worldView.removeObjectListener(listenerD.getObjectId(), listenerD);
        }
        for (IWorldEventListener l : this.listeners.get((Object)ListenerLevel.E)) {
            LevelEListener listenerE = (LevelEListener)l;
            this.worldView.removeObjectListener(listenerE.getObjectId(), listenerE.getEventClass(), listenerE);
        }
        this.log.info(this.obj + " -> " + this.worldView + ": Listeners removed.");
    }

    private class LevelAListener
    implements IWorldEventListener {
        Method method;

        public LevelAListener(Method method) {
            if (method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].isAssignableFrom(method.getAnnotation(EventListener.class).eventClass())) {
                throw new ListenerMethodParametersException(method, method.getAnnotation(EventListener.class), AnnotationListenerRegistrator.this);
            }
            this.method = method;
        }

        public EventListener getAnnotation() {
            return this.method.getAnnotation(EventListener.class);
        }

        public Class getEventClass() {
            return this.getAnnotation().eventClass();
        }

        @Override
        public void notify(Object event) {
            try {
                this.method.setAccessible(true);
                this.method.invoke(AnnotationListenerRegistrator.this.obj, event);
                this.method.setAccessible(false);
            }
            catch (Exception e) {
                throw new PogamutException("Could not invoke LevelA listener " + ClassUtils.getMethodSignature(this.method) + " with parameter of class " + event.getClass() + ".", (Throwable)e, AnnotationListenerRegistrator.this.log, this);
            }
        }
    }

    private class LevelBListener
    implements IWorldObjectListener {
        Method method;

        public LevelBListener(Method method) {
            if (method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].isAssignableFrom(IWorldObjectEvent.class)) {
                throw new ListenerMethodParametersException(method, method.getAnnotation(ObjectClassListener.class), AnnotationListenerRegistrator.this);
            }
            this.method = method;
        }

        public ObjectClassListener getAnnotation() {
            return this.method.getAnnotation(ObjectClassListener.class);
        }

        public Class getObjectClass() {
            return this.getAnnotation().objectClass();
        }

        @Override
        public void notify(Object event) {
            try {
                this.method.setAccessible(true);
                this.method.invoke(AnnotationListenerRegistrator.this.obj, event);
                this.method.setAccessible(false);
            }
            catch (Exception e) {
                throw new PogamutException("Could not invoke LevelB listener " + ClassUtils.getMethodSignature(this.method) + " with parameter of class " + event.getClass() + ".", (Throwable)e, AnnotationListenerRegistrator.this.log, this);
            }
        }
    }

    private class LevelCListener
    implements IWorldObjectEventListener {
        Method method;

        public LevelCListener(Method method) {
            if (method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].isAssignableFrom(method.getAnnotation(ObjectClassEventListener.class).eventClass())) {
                throw new ListenerMethodParametersException(method, method.getAnnotation(ObjectClassEventListener.class), AnnotationListenerRegistrator.this);
            }
            this.method = method;
        }

        public ObjectClassEventListener getAnnotation() {
            return this.method.getAnnotation(ObjectClassEventListener.class);
        }

        public Class getEventClass() {
            return this.getAnnotation().eventClass();
        }

        public Class getObjectClass() {
            return this.getAnnotation().objectClass();
        }

        @Override
        public void notify(Object event) {
            try {
                this.method.setAccessible(true);
                this.method.invoke(AnnotationListenerRegistrator.this.obj, event);
                this.method.setAccessible(false);
            }
            catch (Exception e) {
                throw new PogamutException("Could not invoke LevelC listener " + ClassUtils.getMethodSignature(this.method) + " with parameter of class " + event.getClass() + ".", (Throwable)e, AnnotationListenerRegistrator.this.log, this);
            }
        }
    }

    private class LevelDListener
    implements IWorldObjectListener {
        Method method;
        WorldObjectId objectId;

        public LevelDListener(Method method) {
            if (method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].isAssignableFrom(IWorldObjectEvent.class)) {
                throw new ListenerMethodParametersException(method, method.getAnnotation(ObjectListener.class), AnnotationListenerRegistrator.this);
            }
            this.method = method;
            this.objectId = AnnotationListenerRegistrator.getId(method, this.getAnnotation());
        }

        public ObjectListener getAnnotation() {
            return this.method.getAnnotation(ObjectListener.class);
        }

        public WorldObjectId getObjectId() {
            return this.objectId;
        }

        @Override
        public void notify(Object event) {
            try {
                this.method.setAccessible(true);
                this.method.invoke(AnnotationListenerRegistrator.this.obj, event);
                this.method.setAccessible(false);
            }
            catch (Exception e) {
                throw new PogamutException("Could not invoke LevelD listener " + ClassUtils.getMethodSignature(this.method) + " with parameter of class " + event.getClass() + ".", (Throwable)e, AnnotationListenerRegistrator.this.log, this);
            }
        }
    }

    private class LevelEListener
    implements IWorldObjectEventListener {
        Method method;
        WorldObjectId objectId;

        public LevelEListener(Method method) {
            if (method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].isAssignableFrom(method.getAnnotation(ObjectEventListener.class).eventClass())) {
                throw new ListenerMethodParametersException(method, method.getAnnotation(ObjectEventListener.class), AnnotationListenerRegistrator.this);
            }
            this.method = method;
            this.objectId = AnnotationListenerRegistrator.getId(method, this.getAnnotation());
        }

        public ObjectEventListener getAnnotation() {
            return this.method.getAnnotation(ObjectEventListener.class);
        }

        public WorldObjectId getObjectId() {
            return this.objectId;
        }

        public Class getEventClass() {
            return this.getAnnotation().eventClass();
        }

        @Override
        public void notify(Object event) {
            try {
                this.method.setAccessible(true);
                this.method.invoke(AnnotationListenerRegistrator.this.obj, event);
                this.method.setAccessible(false);
            }
            catch (Exception e) {
                throw new PogamutException("Could not invoke LevelE listener " + ClassUtils.getMethodSignature(this.method) + " with parameter of class " + event.getClass() + ".", (Throwable)e, AnnotationListenerRegistrator.this.log, this);
            }
        }
    }
}

