/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.mediator;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.communication.mediator.ExpectedAnswersOfMediator;
import cz.cuni.amis.pogamut.base.communication.mediator.IMediator;
import cz.cuni.amis.pogamut.base.communication.mediator.MockMediatorInput;
import cz.cuni.amis.pogamut.base.communication.mediator.MockMediatorOutput;
import cz.cuni.amis.pogamut.base.communication.mediator.impl.Mediator;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEventOutput;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldChangeEventInput;
import cz.cuni.amis.pogamut.base.component.bus.ComponentBus;
import cz.cuni.amis.pogamut.base.factory.guice.GuiceAgentModule;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.utils.flag.FlagListener;
import java.util.logging.Level;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.easymock.IArgumentMatcher;
import org.easymock.IMocksControl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Test01_Mediator {
    private static IMocksControl ctrl;
    private GuiceAgentModule module;
    private IWorldChangeEventOutput mockOutput;
    private MockMediatorOutput mediatorOutput;
    private IWorldChangeEventInput mockInput;
    private MockMediatorInput mediatorInput;
    private IMediator mediator;
    private Thread mainThread;
    private RunningListener runningListener = new RunningListener();
    private String error = null;
    private String planFileName;
    private Class<? extends IMediator> mediatorClass = Mediator.class;
    private IAgentId agentId = new AgentId("MediatorTestCase");
    private IAgentLogger logger = new AgentLogger(this.agentId);
    private LogCategory log = this.logger.getCategory("Test");

    @Before
    public void startUp() {
        this.mainThread = Thread.currentThread();
        ctrl = EasyMock.createStrictControl();
    }

    @Test
    public void testMediator() {
        this.doTest();
    }

    public IWorldChangeEvent eqEvent(ExpectedAnswersOfMediator event) {
        EasyMock.reportMatcher((IArgumentMatcher)new AnswerMatcher(event));
        return null;
    }

    public void doTest() {
        this.logger.addDefaultConsoleHandler();
        this.logger.setLevel(Level.ALL);
        ComponentBus bus = new ComponentBus(this.logger);
        this.mockOutput = (IWorldChangeEventOutput)ctrl.createMock(IWorldChangeEventOutput.class);
        this.mockInput = (IWorldChangeEventInput)ctrl.createMock(IWorldChangeEventInput.class);
        this.mediatorOutput = new MockMediatorOutput(this.logger, bus, this.mockOutput);
        this.mediatorInput = new MockMediatorInput(this.logger, bus, this.mockInput);
        this.mediator = new Mediator(this.mediatorOutput, bus, this.logger);
        this.mediator.setConsumer(this.mediatorInput);
        this.log.info("Starting MediatorTestCase of " + this.mediator.getClass().getName() + ".");
        ExpectedAnswersOfMediator expectedAnswersOfMediator = new ExpectedAnswersOfMediator(this.log, this.mediator);
        Assert.assertTrue((String)"Plan cannot be empty.", (expectedAnswersOfMediator.getNumberOfQueuedEvents() > 0 ? 1 : 0) != 0);
        ctrl.checkOrder(false);
        this.mockOutput.getEvent();
        EasyMock.expectLastCall().andAnswer((IAnswer)expectedAnswersOfMediator).atLeastOnce();
        this.mockInput.notify(this.eqEvent(expectedAnswersOfMediator));
        EasyMock.expectLastCall().times(expectedAnswersOfMediator.getNumberOfQueuedEvents());
        ctrl.replay();
        this.mediatorInput.getController().manualStart("starting test");
        this.mediatorOutput.getController().manualStart("starting test");
        Boolean result = expectedAnswersOfMediator.getEventsQueueEmpty().waitFor(10000L, (T[])new Boolean[]{true});
        junit.framework.Assert.assertTrue((String)"all events must be processed", (result != null && result != false ? 1 : 0) != 0);
        this.mediatorInput.getController().manualStop("stopping the test");
        ctrl.verify();
        System.out.println("---/// TEST OK ///---");
    }

    class AnswerMatcher
    implements IArgumentMatcher {
        private ExpectedAnswersOfMediator expectedAnswersOfMediator;

        public void appendTo(StringBuffer buffer) {
            buffer.append(Test01_Mediator.this.error);
        }

        public boolean matches(Object argument) {
            IWorldChangeEvent last = this.expectedAnswersOfMediator.getLastEvent();
            if (argument instanceof IWorldChangeEvent && last.toString().equals(((IWorldChangeEvent)argument).toString())) {
                Test01_Mediator.this.log.info("Argument equals to event: " + last.toString());
                return true;
            }
            Test01_Mediator.this.error = "Unexpected argument received for an AnswerMatcher object: " + argument.toString() + " doesnt equal expected " + last.toString();
            Thread.currentThread().interrupt();
            Test01_Mediator.this.mainThread.interrupt();
            return false;
        }

        public AnswerMatcher(ExpectedAnswersOfMediator expectedAnswersOfMediator) {
            this.expectedAnswersOfMediator = expectedAnswersOfMediator;
        }
    }

    private class RunningListener
    implements FlagListener<Boolean> {
        private RunningListener() {
        }

        @Override
        public void flagChanged(Boolean changedValue) {
            if (!changedValue.booleanValue()) {
                Test01_Mediator.this.mainThread.interrupt();
            }
        }
    }
}

