/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.mediator;

import cz.cuni.amis.pogamut.base.communication.mediator.IMediator;
import cz.cuni.amis.pogamut.base.communication.mediator.testevents.BeginMessage;
import cz.cuni.amis.pogamut.base.communication.mediator.testevents.BombInfo;
import cz.cuni.amis.pogamut.base.communication.mediator.testevents.BotDamaged;
import cz.cuni.amis.pogamut.base.communication.mediator.testevents.Bumped;
import cz.cuni.amis.pogamut.base.communication.mediator.testevents.EndMessage;
import cz.cuni.amis.pogamut.base.communication.mediator.testevents.GameInfo;
import cz.cuni.amis.pogamut.base.communication.mediator.testevents.HearPickup;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import java.util.LinkedList;
import org.easymock.IAnswer;
import org.junit.Assert;

public class ExpectedAnswersOfMediator
implements IAnswer<IWorldChangeEvent> {
    private LinkedList<IWorldChangeEvent> eventsQueue = new LinkedList();
    private IWorldChangeEvent lastEvent;
    private LogCategory logger;
    private IMediator testedMediator;
    private Flag<Boolean> eventsQueueEmpty = new Flag<Boolean>(true);

    public ExpectedAnswersOfMediator(LogCategory logger, IMediator testedMediator) {
        Assert.assertTrue((String)"Passed logger cannot be empty.", (logger != null ? 1 : 0) != 0);
        this.logger = logger;
        this.eventsQueue.add(new BeginMessage());
        this.eventsQueue.add(new BombInfo());
        this.eventsQueue.add(new BotDamaged());
        this.eventsQueue.add(new Bumped());
        this.eventsQueue.add(new EndMessage());
        this.eventsQueue.add(new GameInfo());
        this.eventsQueue.add(new HearPickup());
        this.eventsQueueEmpty.setFlag(false);
        this.logger = logger;
        this.testedMediator = testedMediator;
    }

    public ImmutableFlag<Boolean> getEventsQueueEmpty() {
        return this.eventsQueueEmpty.getImmutable();
    }

    public IWorldChangeEvent answer() throws Throwable {
        if (this.eventsQueue.size() > 0) {
            this.lastEvent = this.eventsQueue.pop();
            this.logger.info("Returned event: " + this.lastEvent.toString());
        } else {
            this.eventsQueueEmpty.setFlag(true);
            this.lastEvent = null;
            this.logger.info("Event queue empty");
            Thread.currentThread().interrupt();
        }
        return this.lastEvent;
    }

    public IWorldChangeEvent getLastEvent() {
        return this.lastEvent;
    }

    public int getNumberOfQueuedEvents() {
        return this.eventsQueue.size();
    }

    public LinkedList<IWorldChangeEvent> getList() {
        return this.eventsQueue;
    }
}

