/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.connection.impl.socket;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import cz.cuni.amis.pogamut.base.communication.connection.exception.ConnectionException;
import cz.cuni.amis.pogamut.base.communication.connection.impl.AbstractConnection;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.ISocketConnectionAddress;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Socket;

@AgentScoped
public class SocketConnection
extends AbstractConnection<ISocketConnectionAddress> {
    public static final String CONNECTION_DEPENDENCY = "ConnectionDependency";
    public static final String CONNECTION_ADDRESS_DEPENDENCY = "ConnectionAddressDependency";
    private Socket socket = null;
    private InputStreamReader socketReader = null;
    private OutputStreamWriter socketWriter = null;

    @Inject
    public SocketConnection(@Named(value="ConnectionAddressDependency") ISocketConnectionAddress address, @Named(value="ConnectionDependency") ComponentDependencies dependencies, IComponentBus bus, IAgentLogger logger) {
        super(address, dependencies, bus, logger);
    }

    public SocketConnection(ComponentDependencies dependencies, IComponentBus bus, IAgentLogger logger) {
        super(dependencies, bus, logger);
    }

    @Override
    protected Reader getConnectionReader() throws ConnectionException {
        return this.socketReader;
    }

    @Override
    protected Writer getConnectionWriter() throws ConnectionException {
        return this.socketWriter;
    }

    @Override
    protected void unsyncClose() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception e) {
                this.log.severe("Can't close socket - " + e.getMessage());
            }
            try {
                this.socketReader.close();
            }
            catch (Exception e) {
                this.log.severe("Can't close socket reader - " + e.getMessage());
            }
            try {
                this.socketWriter.close();
            }
            catch (Exception e) {
                this.log.severe("Can't close socket writer - " + e.getMessage());
            }
            this.socket = null;
        }
    }

    @Override
    protected void unsyncConnect(ISocketConnectionAddress address) throws ConnectionException {
        this.socket = new Socket();
        try {
            this.socket.connect(new InetSocketAddress(address.getHost(), address.getPort()));
            this.socketReader = new InputStreamReader(this.socket.getInputStream());
            this.socketWriter = new OutputStreamWriter(this.socket.getOutputStream());
        }
        catch (IOException e) {
            throw new ConnectionException(e + " (" + address.getHost() + ":" + address.getPort() + ")", (Object)this.log);
        }
    }

    @Override
    public String toString() {
        return "SocketConnection[" + String.valueOf(this.address) + ",connected:" + (this.controller == null ? "false" : Boolean.valueOf(this.controller.isRunning())) + ")";
    }
}

