/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.connection;

import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.communication.connection.CommunicationTestCase;
import cz.cuni.amis.pogamut.base.communication.connection.exception.ConnectionException;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnection;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.component.bus.ComponentBus;
import cz.cuni.amis.pogamut.base.component.controller.ComponentControlHelper;
import cz.cuni.amis.pogamut.base.component.controller.ComponentController;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.component.stub.ManualCheckComponent;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import org.junit.Test;

public class Test02_SocketConnection
extends CommunicationTestCase {
    private String[] responses = new String[]{"Hello", "Bye"};

    @Override
    public String[] getResponses() {
        return this.responses;
    }

    @Test
    public void test() {
        AgentId agentId = new AgentId("Test02_SocketConnection");
        AgentLogger logger = new AgentLogger(agentId);
        logger.addDefaultConsoleHandler();
        logger.setLevel(Level.ALL);
        ComponentBus bus = new ComponentBus(logger);
        ManualCheckComponent starter = new ManualCheckComponent(logger, bus);
        ComponentController starterCtrl = new ComponentController(starter, new ComponentControlHelper(), bus, logger.getCategory(starter), new ComponentDependencies());
        ComponentDependencies connDepend = new ComponentDependencies(ComponentDependencyType.STARTS_WITH, starter);
        SocketConnection conn = new SocketConnection(connDepend, bus, logger);
        BufferedReader in = null;
        PrintWriter out = null;
        try {
            in = new BufferedReader(conn.getReader());
        }
        catch (ConnectionException e) {
            Test02_SocketConnection.fail((String)("can't get reader for the connection: " + e.getMessage()));
        }
        try {
            out = new PrintWriter(conn.getWriter());
        }
        catch (ConnectionException e) {
            Test02_SocketConnection.fail((String)("can't get writer for the connection: " + e.getMessage()));
        }
        int iter = 0;
        while (iter < 10) {
            bus.reset();
            this.reinitServer();
            Test02_SocketConnection.assertTrue((String)"server not started correctly", (boolean)this.getServer().consume("Server started"));
            conn.setAddress(new SocketConnectionAddress("127.0.0.1", this.getServer().getPort()));
            starterCtrl.manualStart("manual start");
            out.println("get");
            out.flush();
            try {
                int i = 0;
                while (in.ready()) {
                    if (i >= this.getResponses().length) {
                        Test02_SocketConnection.fail((String)"server sent too many response lines");
                    }
                    String line = in.readLine();
                    Test02_SocketConnection.assertTrue((String)("wrong response, EXPECTED: " + this.getResponses()[i] + ", GOT: " + line), (boolean)line.equals(this.getResponses()[i++]));
                }
            }
            catch (IOException e) {
                Test02_SocketConnection.fail((String)("can't read whole response: " + e.getMessage()));
            }
            out.println("quit");
            out.flush();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            Test02_SocketConnection.assertTrue((String)"server didn't receive GET command", (boolean)this.getServer().consume("Received: get"));
            String[] stringArray = this.getResponses();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                Test02_SocketConnection.assertTrue((String)"server wrong reply", (boolean)this.getServer().consume("Sent: " + str));
                ++n2;
            }
            Test02_SocketConnection.assertTrue((String)"server didn't receive QUIT command", (boolean)this.getServer().consume("Received: quit"));
            Test02_SocketConnection.assertTrue((String)"server didn't terminate", (boolean)this.getServer().consume("Server terminated"));
            starterCtrl.manualStop("manual stop");
            Test02_SocketConnection.assertTrue((String)"some server output left", (boolean)this.getServer().isClear(true));
            ++iter;
        }
        System.out.println("---/// TEST OK ///---");
    }

    public static void main(String[] args) {
        Test02_SocketConnection test = new Test02_SocketConnection();
        test.setUp();
        test.test();
        test.tearDown();
    }
}

