/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.utils.runner.impl;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.utils.runner.IAgentRunner;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnectionAddress;
import cz.cuni.amis.pogamut.base.factory.IRemoteAgentFactory;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;

public abstract class RemoteAgentRunner<T extends IAgent>
implements IAgentRunner<T> {
    private static int agentCounter = 0;
    private static Object agentCounterMutex = new Object();
    protected String name = "Unnamed";
    protected IRemoteAgentFactory factory;

    public RemoteAgentRunner(IRemoteAgentFactory factory, String name) {
        this.factory = factory;
        NullCheck.check(this.factory, "factory");
        this.name = name;
        NullCheck.check(this.name, "name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentId getAgentId() {
        Object object = agentCounterMutex;
        synchronized (object) {
            return new AgentId(String.valueOf(this.name) + ++agentCounter);
        }
    }

    public abstract IWorldConnectionAddress getAddress();

    @Override
    public T startAgent() throws PogamutException {
        IAgent agent = null;
        this.preInitHook();
        agent = this.factory.newAgent(this.getAgentId(), this.getAddress());
        agent.getLogger().addDefaultConsoleHandler();
        this.preStartHook(agent);
        agent.start();
        try {
            this.postStartHook(agent);
        }
        catch (Exception e1) {
            try {
                agent.stop();
            }
            catch (Exception e2) {
                throw new PogamutException("Could not start the agent, postStartHook() failed with: " + ExceptionToString.process(e1) + ", and the agent could not be stopped: " + e2.getMessage(), e2, (Object)this);
            }
            throw new PogamutException("Could not start the agent, postStartHook() failed.", e1, (Object)this);
        }
        return (T)agent;
    }

    protected void preInitHook() throws PogamutException {
    }

    protected void preStartHook(T agent) throws PogamutException {
    }

    protected void postStartHook(T agent) throws PogamutException {
    }
}

