/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.utils;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.state.impl.AgentState;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateGoingDown;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateGoingUp;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateUp;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateInstantiated;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.FlagListener;

public abstract class AgentHeartbeatKeepAlive {
    private Object keepAliveMutex = new Object();
    private LogCategory log;
    private HeartbeatKeepAlive keepAlive = null;
    private Flag<Boolean> shouldStart = new Flag<Boolean>(false);
    private boolean firstStart = false;
    private IAgent agent;
    private boolean running = false;
    private long reconnectMillis;
    private FlagListener<AgentState> stateListener = new FlagListener<AgentState>(){

        @Override
        public void flagChanged(AgentState changedValue) {
            AgentState serverState = changedValue;
            if (serverState instanceof IAgentStateInstantiated) {
                throw new PogamutException("Invalid server state, server can't switch back to instantiated state, state: " + serverState + ".", (Object)this);
            }
            if (serverState instanceof IAgentStateGoingUp) {
                return;
            }
            if (serverState instanceof IAgentStateGoingDown) {
                return;
            }
            if (serverState instanceof IAgentStateDown) {
                AgentHeartbeatKeepAlive.this.shouldStart.setFlag(true);
            }
        }
    };

    public AgentHeartbeatKeepAlive(IAgent agent, long reconnectWaitMillis) {
        this.agent = agent;
        NullCheck.check(this.agent, "agent");
        this.log = agent.getLogger().getCategory(this.getClass().getSimpleName());
        NullCheck.check(this.log, "log initialization");
        this.reconnectMillis = reconnectWaitMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.keepAliveMutex;
        synchronized (object) {
            if (this.running) {
                return;
            }
            IAgentState state = this.agent.getState().getFlag();
            this.shouldStart.setFlag(!(state instanceof IAgentStateGoingUp) && !(state instanceof IAgentStateUp));
            this.firstStart = true;
            this.keepAlive = new HeartbeatKeepAlive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.keepAliveMutex;
        synchronized (object) {
            if (this.keepAlive != null) {
                this.keepAlive.stop();
                this.keepAlive = null;
            }
        }
    }

    public abstract boolean isHeartbeatReceived();

    public long getHearbeatMaxDelayMillis() {
        return 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getNextRestart() {
        Object object = this.keepAliveMutex;
        synchronized (object) {
            block4: {
                if (this.running) break block4;
                return null;
            }
            return this.keepAlive.getNextRestart();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    private class HeartbeatKeepAlive
    implements Runnable {
        private Thread reconnectThread = null;
        private boolean shouldRun = true;
        private long sleepMillis = -1L;
        private long lastPingSent = -1L;

        public HeartbeatKeepAlive() {
            this.reconnectThread = new Thread((Runnable)this, String.valueOf(AgentHeartbeatKeepAlive.this.agent.getName()) + " reconnector");
            this.reconnectThread.start();
        }

        public void stop() {
            AgentHeartbeatKeepAlive.this.log.warning("Stopping KeepAlive.");
            this.shouldRun = false;
            this.reconnectThread.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Long getNextRestart() {
            Object object = AgentHeartbeatKeepAlive.this.keepAliveMutex;
            synchronized (object) {
                block4: {
                    if (this.sleepMillis >= 0L) break block4;
                    return null;
                }
                return System.currentTimeMillis() - this.sleepMillis - AgentHeartbeatKeepAlive.this.reconnectMillis;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            Boolean result = null;
            while (this.shouldRun) {
                try {
                    if (!((Boolean)AgentHeartbeatKeepAlive.this.shouldStart.getFlag()).booleanValue()) {
                        object = AgentHeartbeatKeepAlive.this.keepAliveMutex;
                        synchronized (object) {
                            this.sleepMillis = -1L;
                        }
                        result = AgentHeartbeatKeepAlive.this.shouldStart.waitFor(AgentHeartbeatKeepAlive.this.reconnectMillis, (T[])new Boolean[]{true});
                        if (result == null) {
                            continue;
                        }
                    } else if (!AgentHeartbeatKeepAlive.this.firstStart) {
                        object = AgentHeartbeatKeepAlive.this.keepAliveMutex;
                        synchronized (object) {
                            this.sleepMillis = System.currentTimeMillis();
                        }
                        AgentHeartbeatKeepAlive.this.log.finer("Next reconnect attempt in " + AgentHeartbeatKeepAlive.this.reconnectMillis + " ms.");
                        Thread.sleep(AgentHeartbeatKeepAlive.this.reconnectMillis);
                    }
                    if (!this.shouldRun) break;
                    try {
                        IAgentState state = AgentHeartbeatKeepAlive.this.agent.getState().getFlag();
                        if (state instanceof IAgentStateUp || state instanceof IAgentStateGoingUp) {
                            AgentHeartbeatKeepAlive.this.shouldStart.setFlag(false);
                            continue;
                        }
                        if (AgentHeartbeatKeepAlive.this.firstStart) {
                            AgentHeartbeatKeepAlive.this.log.info("Starting agent.");
                            AgentHeartbeatKeepAlive.this.firstStart = false;
                        } else {
                            AgentHeartbeatKeepAlive.this.log.info("Restarting agent.");
                        }
                        AgentHeartbeatKeepAlive.this.agent.start();
                        AgentHeartbeatKeepAlive.this.log.info("Agent started.");
                    }
                    catch (Exception e1) {
                        if (!this.shouldRun) break;
                        AgentHeartbeatKeepAlive.this.log.info("Agent did not start, killing agent (cleaning up).");
                        try {
                            AgentHeartbeatKeepAlive.this.agent.kill();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception e) {
                    if (!this.shouldRun) break;
                    AgentHeartbeatKeepAlive.this.log.severe(ExceptionToString.process("Unhandled exception, stopping " + AgentHeartbeatKeepAlive.this.getClass().getSimpleName() + ".", e));
                    break;
                }
            }
            this.reconnectThread = null;
            object = AgentHeartbeatKeepAlive.this.keepAliveMutex;
            synchronized (object) {
                if (AgentHeartbeatKeepAlive.this.keepAlive == this) {
                    AgentHeartbeatKeepAlive.this.running = false;
                    AgentHeartbeatKeepAlive.this.keepAlive = null;
                }
            }
            AgentHeartbeatKeepAlive.this.log.warning("Stopped.");
        }
    }
}

