/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.navigation.stuckdetectors;

import cz.cuni.amis.pogamut.base.agent.navigation.AbstractPathExecutor;
import cz.cuni.amis.pogamut.base.agent.navigation.PathEventType;
import cz.cuni.amis.pogamut.base.agent.navigation.PathExecutorListener;
import cz.cuni.amis.pogamut.base.agent.navigation.stuckdetectors.StuckDetector;
import java.util.logging.Logger;

public abstract class AbstractStuckDetector
implements StuckDetector {
    protected boolean enabled = true;
    protected AbstractPathExecutor pathExecutor = null;
    private long hits = 0L;

    @Override
    public void disable() {
        this.enabled = false;
    }

    @Override
    public void enable() {
        this.enabled = true;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setCurrentPathExecutor(AbstractPathExecutor pathExecutor) {
        this.pathExecutor = pathExecutor;
    }

    protected void fireEvent(PathEventType eventType) {
        PathExecutorListener[] list;
        if (this.pathExecutor == null) {
            throw new RuntimeException("pathExecutor is set to null! Register your StuckDetector by PathExecutor.addStuckDetector() method!");
        }
        ++this.hits;
        PathExecutorListener[] pathExecutorListenerArray = list = this.pathExecutor.getAllPathListeners();
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            PathExecutorListener listener = pathExecutorListenerArray[n2];
            try {
                listener.onEvent(eventType);
            }
            catch (Exception ex) {
                Logger.getLogger("AbstractStuckDetector").warning("Error while distributing path event thru listeners! I'll continue with next one. Error: " + ex.getMessage());
            }
            ++n2;
        }
    }

    @Override
    public long getStuckDetectedCount() {
        return this.hits;
    }
}

