/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.navigation;

import cz.cuni.amis.pogamut.base.agent.navigation.AbstractPathExecutor;
import cz.cuni.amis.pogamut.base.agent.navigation.PathEventType;
import cz.cuni.amis.pogamut.base.agent.navigation.PathExecutor;
import cz.cuni.amis.pogamut.base.agent.navigation.PathExecutorListener;
import cz.cuni.amis.pogamut.base.agent.navigation.PathHandle;
import cz.cuni.amis.pogamut.base.agent.navigation.PathPlanner;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class TripExecutor<T extends ILocated>
extends AbstractPathExecutor<List<T>>
implements PathExecutorListener {
    PathExecutor<ILocated> executor = null;
    private final LinkedList<T> targets = new LinkedList();
    private final PathPlanner<ILocated, ILocated> pathPlanner;

    public TripExecutor(PathExecutor<ILocated> executor, PathPlanner<ILocated, ILocated> pathPlanner) {
        this.executor = executor;
        this.pathPlanner = pathPlanner;
        executor.addPathListener(this);
    }

    protected void moveToNext() {
        if (this.targets.isEmpty()) {
            this.fireEvent(PathEventType.TARGET_REACHED);
        } else {
            ILocated loc = (ILocated)this.targets.pop();
            this.executor.followPath(this.pathPlanner.computePath(loc));
        }
    }

    @Override
    public void followPath(Collection<T> listOfTargets) {
        this.targets.addAll(listOfTargets);
        if (!this.isMoving()) {
            this.moveToNext();
        }
    }

    @Override
    public void followPath(PathHandle<List<T>> path) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void stop() {
        this.executor.stop();
        this.targets.clear();
    }

    @Override
    public boolean isMoving() {
        return this.executor.isMoving();
    }

    @Override
    public void onEvent(PathEventType eventType) {
        if (eventType.equals((Object)PathEventType.TARGET_REACHED)) {
            this.moveToNext();
        }
    }
}

