/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.module;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.exceptions.AgentException;
import cz.cuni.amis.pogamut.base.agent.module.AgentModule;
import cz.cuni.amis.pogamut.base.agent.module.IAgentLogic;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.event.AcceptEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.IStartedEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.WaitForEvent;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.component.controller.ComponentState;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantPauseException;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantResumeException;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantStartException;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantStopException;
import cz.cuni.amis.pogamut.base.utils.Const;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.token.Token;
import java.util.logging.Level;
import java.util.logging.Logger;

@AgentScoped
public class LogicModule<AGENT extends IAgent>
extends AgentModule<AGENT> {
    private static long THREAD_COUNTER = 0L;
    private static final long LOGIC_WAIT_TIME_PLUS_MILLIS = 1000L;
    public static final long MIN_LOGIC_PERIOD_MILLIS = 1L;
    public static final double MIN_LOGIC_FREQUENCY = 0.0;
    protected Object mutex = new Object();
    protected IAgentLogic logic;
    protected Thread logicThread = null;
    protected boolean logicShouldRun = true;
    protected Flag<Boolean> logicRunning = new Flag<Boolean>(false);
    protected Flag<Boolean> logicShouldPause = new Flag<Boolean>(false);
    protected Flag<Boolean> logicPaused = new Flag<Boolean>(false);
    protected double logicFrequency = 5.0;
    protected double logicPeriod = 200.0;
    protected long lastLogicRun = 0L;

    @Inject
    public LogicModule(AGENT agent, IAgentLogic logic) {
        this(agent, logic, null, new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add((IComponent)agent));
    }

    public LogicModule(AGENT agent, IAgentLogic logic, Logger log) {
        this(agent, logic, log, new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add((IComponent)agent));
    }

    public LogicModule(AGENT agent, IAgentLogic logic, Logger log, ComponentDependencies dependencies) {
        super(agent, log, dependencies);
        this.logic = logic;
    }

    private void clearLogicRunningVars() {
        this.logicShouldPause.setFlag(false);
        this.logicPaused.setFlag(false);
        this.logicRunning.setFlag(false);
        this.logicShouldRun = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void start() throws AgentException {
        super.start();
        Object object = this.mutex;
        synchronized (object) {
            if (this.logicThread != null) {
                this.log.warning("Logic thread is not null! Sending interrupt and dropping the reference, possibly leaking resources.");
                this.logicThread.interrupt();
                this.logicThread = null;
            }
            long counter = THREAD_COUNTER++;
            String name = String.valueOf(this.agent.getName()) + "'s logic (" + counter + ")";
            this.clearLogicRunningVars();
            this.logicThread = new Thread((Runnable)new LogicRunner("Thread " + counter), String.valueOf(this.agent.getName()) + " logic");
        }
        this.log.fine("Starting logic thread.");
        this.logicThread.start();
        long waitTime = this.logic.getLogicInitializeTime() + 1000L;
        this.log.info("Waiting for the logic to initialize (" + waitTime + " ms).");
        Boolean result = this.logicRunning.waitFor(waitTime, (T[])new Boolean[]{true});
        if (!this.controller.inState(ComponentState.STARTING)) {
            throw new ComponentCantStartException("Woke up, module state differs. It is not " + (Object)((Object)ComponentState.STARTING) + " but " + (Object)((Object)this.controller.getState().getFlag()) + ".", this.log, (IComponent)this);
        }
        if (result == null) {
            throw new ComponentCantStartException("Logic initialization is taking too long, did you correctly specified initialize time via getInitializeTime() method?", this.log, (IComponent)this);
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (Thread.currentThread() == this.logicThread) {
            this.inThreadStopping();
        } else {
            this.logicShouldRun = false;
            this.logicShouldPause.setFlag(false);
            long waitTime = (long)this.logicPeriod + 1000L;
            this.log.info("Waiting for the logic to stop (" + waitTime + " ms).");
            Boolean result = this.logicRunning.waitFor(waitTime, (T[])new Boolean[]{false});
            if (result == null) {
                throw new ComponentCantStopException("Logic thread is still running! Is your logic too cpu-demanding?", this.log, (Object)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void kill() {
        super.kill();
        if (Thread.currentThread() == this.logicThread) {
            this.inThreadKilling();
        } else {
            this.logicShouldRun = false;
            this.logicShouldPause.setFlag(false);
            Object object = this.mutex;
            synchronized (object) {
                if (this.logicThread == null) {
                    return;
                }
            }
            long waitTime = (long)this.logicPeriod + 1000L;
            this.log.info("Waiting for the logic to stop (" + waitTime + " ms).");
            Boolean result = this.logicRunning.waitFor(waitTime, (T[])new Boolean[]{false});
            Object object2 = this.mutex;
            synchronized (object2) {
                if (this.logicThread == null) {
                    return;
                }
                if (result != null) {
                    return;
                }
                this.log.warning("Logic thread is still running, sending interrupt.");
                this.logicThread.interrupt();
            }
            this.log.info("Waiting for the logic to stop (" + waitTime + " ms).");
            result = this.logicRunning.waitFor(waitTime, (T[])new Boolean[]{false});
            object2 = this.mutex;
            synchronized (object2) {
                if (this.logicThread == null) {
                    return;
                }
                if (result == null) {
                    this.log.warning("Logic thread is still running, is your logic too much cpu demanding?");
                }
            }
        }
    }

    @Override
    protected void pause() {
        super.pause();
        if (Thread.currentThread() == this.logicThread) {
            this.inThreadPausing();
        } else {
            this.logicShouldPause.setFlag(true);
            long waitTime = (long)this.logicPeriod + 1000L;
            this.log.info("Waiting for the logic to pause (" + waitTime + " ms).");
            Boolean result = this.logicPaused.waitFor(waitTime, (T[])new Boolean[]{true});
            if (result == null) {
                throw new ComponentCantPauseException("Logic is still running, is your logic cpu demanding too much?", this.log, (Object)this);
            }
        }
    }

    @Override
    protected void resume() {
        super.resume();
        if (Thread.currentThread() == this.logicThread) {
            this.inThreadResuming();
        } else {
            this.logicShouldPause.setFlag(false);
            long waitTime = (long)this.logicPeriod + 1000L;
            this.log.info("Waiting for the logic to resume (" + waitTime + " ms).");
            Boolean result = this.logicPaused.waitFor(waitTime, (T[])new Boolean[]{false});
            if (result == null) {
                throw new ComponentCantResumeException("Logic did not resumed.", this.log, (Object)this);
            }
        }
    }

    protected void inThreadStopping() {
        this.inThreadWarning("Stopping", "stopped", "stop");
        this.logicShouldRun = false;
        this.logicShouldPause.setFlag(false);
    }

    protected void inThreadKilling() {
        this.inThreadWarning("Killing", "killed", "kill");
        this.logicShouldRun = false;
        this.logicShouldPause.setFlag(false);
        this.logicThread.interrupt();
    }

    protected void inThreadPausing() {
        this.inThreadWarning("Pausing", "paused", "pause");
        this.logicShouldPause.setFlag(true);
    }

    protected void inThreadResuming() {
        this.inThreadWarning("Resuming", "resumed", "resume");
        this.logicShouldPause.setFlag(false);
    }

    private void inThreadWarning(String str1, String str2, String str3) {
        String warning = "In-Logic-Thread " + str1 + " happens. This occurs whenever the LogicModule is being " + str2 + " from within its own thread. While this may proceed as you have expected, it is unsupported operation with uncertain result." + Const.NEW_LINE + "It is adviced to perform the troubling operation in different thread, e.g.:" + Const.NEW_LINE + "    new Thread(new Runnable() {" + Const.NEW_LINE + "        @Override" + Const.NEW_LINE + "        public void run() {" + Const.NEW_LINE + "            // do something that happens to " + str3 + " the logic module //" + Const.NEW_LINE + "        }" + Const.NEW_LINE + "    }).start();";
        if (this.log.isLoggable(Level.WARNING)) {
            this.log.warning(warning);
        } else {
            this.log.severe(warning);
        }
    }

    protected void beforeLogic(String threadName) {
    }

    protected void afterLogic(String threadName) {
    }

    protected void afterLogicException(String threadName, Throwable e) {
    }

    protected boolean shouldExecuteLogic() {
        return true;
    }

    protected void logicLatch(String threadName) {
    }

    public double getLogicPeriod() {
        return this.logicPeriod;
    }

    public double getLogicFrequency() {
        return this.logicFrequency;
    }

    public void setLogicFrequency(double frequency) {
        this.logicFrequency = frequency;
        if (this.logicFrequency <= 0.0) {
            this.logicPeriod = Double.POSITIVE_INFINITY;
            this.logicPeriod = 1.0;
        } else {
            this.logicPeriod = 1000.0 / this.logicFrequency;
            this.logicFrequency = 1000.0;
        }
        if (this.logicPeriod < 0.0 || this.logicFrequency <= 0.0) {
            this.logicPeriod = 1.0;
            this.logicFrequency = 1000.0;
        }
    }

    static /* synthetic */ void access$1(LogicModule logicModule) {
        logicModule.clearLogicRunningVars();
    }

    private class LogicRunner
    implements Runnable {
        private String name;
        private WaitForEvent startedEvent;

        public LogicRunner(String name) {
            this.startedEvent = new WaitForEvent(LogicModule.this.eventBus, new AcceptEvent<IStartedEvent>(IStartedEvent.class, (Token)LogicModule.this.getComponentId()));
            if (name == null) {
                name = "unnamed";
            }
            this.name = name;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

