class TraceLine extends xEmitter;

#exec OBJ LOAD FILE=XEffectMat.utx

var Vector	StartEffect, EndEffect;
var bool	bHitSomething;

//----------

var rotator BeamDirection; //Relative Beam Direction
var float BeamLength; //Beam Length

//----------


replication
{

    reliable if (Role == ROLE_Authority)
         bHitSomething;

    reliable if (Role == ROLE_Authority) //&& (!bNetOwner || bDemoRecording || bRepClientDemo)  )
        StartEffect, EndEffect;
}


simulated function Destroyed()
{
    Super.Destroyed();
}

simulated function SetBeamLocation()
{
	StartEffect = Instigator.Controller.Pawn.Location;
}

simulated function Vector SetBeamRotation()
{
	local vector  FloorLocation, FloorNormal;
	local vector  RealRayDirection;


	RealRayDirection = vector(Instigator.Controller.Pawn.Rotation + BeamDirection);
	//we have to take into account also angle of the floor we are standing on
	FloorNormal = vect(0,0,0);
	Trace(FloorLocation,FloorNormal,Instigator.Controller.Pawn.Location + vect(0,0,-100),Instigator.Controller.Pawn.Location, false, ,);
	RealRayDirection += FloorNormal * (Normal(RealRayDirection) dot FloorNormal) * -1;

	EndEffect = StartEffect + (RealRayDirection * BeamLength);

    SetRotation( Rotator(EndEffect - Location) );

	return Normal(EndEffect - Location);
}

simulated function Tick(float dt)
{

	if ( Instigator == None || Instigator.Controller == None ||	Instigator.Controller.Pawn == none ||
	RemoteBot(Instigator.Controller).bAutoTrace == false || RemoteBot(Instigator.Controller).bDrawTraceLines == false)
    {
    	Destroy();
		return;
    }

	// set beam start location

	//SetLocation(Instigator.Controller.Pawn.Location);
	SetBeamLocation();
	SetBeamRotation();

    mSpawnVecA = EndEffect;
}

defaultproperties
{
     mParticleType=PT_Beam
     mMaxParticles=3
     mSpinRange(0)=45000.000000
     mSizeRange(0)=11.000000
     mColorRange(0)=(B=240,G=240,R=240)
     mColorRange(1)=(B=240,G=240,R=240)
     mAttenuate=False
     mAttenKa=0.000000
     mBendStrength=3.000000
     mWaveLockEnd=True
     LightType=LT_Steady
     LightHue=100
     LightSaturation=100
     LightBrightness=255.000000
     LightRadius=4.000000
     bDynamicLight=True
     bNetTemporary=False
     LifeSpan=60.750000
     bReplicateInstigator=True
     bAlwaysRelevant=True
     RemoteRole=ROLE_SimulatedProxy
     Skins(0)=FinalBlend'XEffectMat.Link.LinkBeamGreenFB'
     Style=STY_Additive
}





