class BotTeamGame extends TeamGameCopy;

#exec OBJ LOAD FILE=TeamSymbols.utx

var int MaxTeams; //TODO: This is a hack, can we get this correctly? Now = 2

function string GetGameInfo()
{
	local string ib, as, ae;
	local string outStr;

	ib = theBotServer.ib;
	as = theBotServer.as;
	ae = theBotServer.ae;

	outStr = (ib$as$ "GoalTeamScore" $ib$ GoalScore $ae$ib$as$
					"TimeLimit" $ib$ RemainingTime $ae$ib$as$
					"MaxTeams" $ib$ MaxTeams $ae$ib$as$
					"MaxTeamSize" $ib$ MaxTeamSize $ae);

	return outStr;
}


function string GetGameStatus(optional RemoteBot theBot)
{
	local string ib, as, ae;
	local string outStr;
	local int i;
	local Controller C;

	ib = theBotServer.ib;
	as = theBotServer.as;
	ae = theBotServer.ae;

	outStr = "GAM";

	outStr = ( outStr $ib$as$ "PlayerScores" );
	for ( C=Level.ControllerList; C!=None; C=C.NextController )
	{
		if( (C.IsA('RemoteBot') || C.IsA('GBxPlayer') || C.IsA('GBxBot')) && !C.IsA('Spectator') )
			outStr = ( outStr $ib$as$ C $ib$ int(C.PlayerReplicationInfo.Score) $ae );
	}
	outStr = ( outStr $ae );

	outStr = ( outStr $ib$as$ "TeamScores" );
	for (i=0;i<MaxTeams;i++)
	{
		outStr = ( outStr $ib$as$ Teams[i].TeamIndex $ib$ int(Teams[i].Score) $ae );
	}
	outStr = ( outStr $ae );

	return outStr;
}

function bool AddRemoteBotToTeam(Bot NewBot, int TeamNum)
{
	local int i, DesiredTeam, MinSize, NextBotTeam;

	if ( bBalanceTeams )
	{
		MinSize = Teams[0].Size;
		DesiredTeam = 0;
		for ( i=1; i<MaxTeams; i++ )
			if ( Teams[i].Size < MinSize )
			{
				MinSize = Teams[i].Size;
				DesiredTeam = i;
			}
	}
	else
		DesiredTeam = TeamNum;

	//NewBot.PlayerReplicationInfo.Team = 255;

	NewBot.PlayerReplicationInfo.bBot = True;

	if ( (DesiredTeam != 255) && ChangeTeam(NewBot, DesiredTeam, true) )
	{
		return true;
	}
	else
	{
		log("Error adding bot to team "$DesiredTeam$" CRAP. :-)");
		for (NextBotTeam = 0; NextBotTeam < MaxTeams; NextBotTeam++)
		{
			if (ChangeTeam(NewBot, NextBotTeam, true))
			{
				return true;
			}
		}
		log("Adding to teams failed!!");
		return false;
	}
}

function UnrealTeamInfo GetEpicBotTeam(optional int TeamNumber)
{
	if ( bBalanceTeams )
	{
		return GetBotTeam();
	}
	else
	{
	 	if ((TeamNumber >= 0) && (TeamNumber < MaxTeams))
	 	{
			return Teams[TeamNumber];
		}
		return GetBotTeam();
	}

}

defaultproperties
{
	DefaultEnemyRosterClass="xGame.xTeamRoster"
	MapListType="XInterface.MapListTeamDeathMatch"
	DeathMessageClass=XGame.xDeathMessage
	ScreenShotName="UT2004Thumbnails.TDMShots"
	DecoTextName="XGame.TeamGame"
	Acronym="TDM"
	NetWait=2
	CountDown=0
	bAllowControlServer=true
	PlayerControllerClassName="BotAPI.GBxPlayer"
	HUDType="xInterface.HudCTeamDeathMatch"
	GameName="Remote Bot Team Deathmatch"
	MaxTeams=2  //TODO: Hack, should find out somehow properly
	GameClass="BotTeamGame"
	MapPrefix="DM"
}

