//=============================================================================
// BotDomination.
//=============================================================================
class BotDoubleDomination extends xDoubleDomCopy
	config(BotAPI);

function string GetGameStatus(optional RemoteBot theBot)
{
	local string ib, as, ae;
	local string outStr;
	local int j, teamNum;

	ib = theBotServer.ib;
	as = theBotServer.as;
	ae = theBotServer.ae;

	outStr = super.GetGameStatus();

	outStr = ( outStr $ib$as$ "DomPoints" );
	//Control Points changed to xDomPoints and just 2 of them in a map now
	for ( j=0; j<2; j++ )
		if ( xDomPoints[j] != None )
		{
			if( xDomPoints[j].ControllingTeam == none )
				teamNum = 255;
			else
				teamNum = xDomPoints[j].ControllingTeam.TeamIndex;

			outStr = ( outStr $ib$as$ xDomPoints[j] $ib$ teamNum $ae );
		}
	outStr = ( outStr $ae );

	return outStr;
}

defaultproperties
{
	bBalanceTeams=False
    DefaultEnemyRosterClass="xGame.xTeamRoster"
	MapListType="XInterface.MapListDoubleDomination"
	GoalScore=3
	ScreenShotName="UT2004Thumbnails.DOMShots"
	DecoTextName="XGame.DoubleDom"
	NetWait=2
	CountDown=0
	Acronym="DOM2"
	bPauseable=True
	bAllowControlServer=true
	PlayerControllerClassName="BotAPI.GBxPlayer"
	HUDType="XInterface.HudCDoubleDomination"
	GameName="Remote Bot Double Domination"
	GameClass="BotDoubleDomination"
	MapPrefix="DOM"

}

