/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils;

import cz.cuni.utils.Settings;
import java.io.File;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;

public class Config {
    public static final boolean LOG_TO_CONSOLE = false;
    public static final String PYTHON_PATH = "python.path";
    public static final String PYTHON_PATH_DELIMITER = File.pathSeparator;
    protected static String PROJECTS_DIR = "projects";

    public static void stopLoggingToConsole() {
        Logger actual = Logger.getAnonymousLogger();
        Logger previous = null;
        while (!actual.equals(previous)) {
            Handler[] handlers;
            for (Handler h : handlers = actual.getHandlers()) {
                if (!(h instanceof ConsoleHandler)) continue;
                actual.removeHandler(h);
            }
            previous = actual;
            if ((actual = actual.getParent()) != null) continue;
            break;
        }
    }

    private Config() {
    }

    public static String getPlatformPath() {
        return (String)Settings.get(Settings.Setting.PLATFORM_DIR);
    }

    public static String getProjectsPath() {
        return Config.getPlatformPath() + File.separator + PROJECTS_DIR;
    }

    public static String getPythonModulePath() {
        return Config.getPlatformPath() + File.separator + "scripting" + File.separator + "python";
    }

    public static String getJythonJarPath() {
        return Config.getPlatformPath() + File.separator + "scriptEngines" + File.separator + "jython.jar";
    }

    public static String fixPythonPath(String path) {
        StringBuffer sb = new StringBuffer(path.length() + 5);
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) == '\\') {
                sb.append('\\');
                sb.append('\\');
                continue;
            }
            sb.append(path.charAt(i));
        }
        return sb.toString();
    }

    static {
        Config.stopLoggingToConsole();
    }
}

