/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.server;

import cz.cuni.pogamut.exceptions.UCCStartException;
import cz.cuni.pogamut.server.UTServer;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UCCWrapper {
    public static final String UNREAL_HOME = "pogamut.unreal.home";
    public static final String UCC_EXEC = "pogamut.unreal.serverexec";
    protected static Collection<UCCWrapper> uccPool = Collections.synchronizedList(new ArrayList());
    protected static Collection<UCCWrapper> uccUnreleased = Collections.synchronizedList(new ArrayList());
    protected Timer poolCleanerTimer = new Timer("UCC pool cleaner");
    protected TimerTask terminationTask = null;
    protected static int fileCounter = 0;
    Process uccProcess = null;
    protected int gbPort = -1;
    protected int controlPort = -1;
    protected UTServer utServer = null;
    public static long stamp = System.currentTimeMillis();
    protected long killAfter = 120000L;
    private static Object poolRetrievalLock = new Object();
    protected boolean released = false;

    public UTServer getUTServer() {
        return this.utServer;
    }

    protected static String getUnrealHome() {
        return System.getProperty(UNREAL_HOME);
    }

    protected static UCCWrapper createNewInstance() throws UCCStartException {
        try {
            int gbPort = -1;
            int controlerPort = -1;
            String id = System.currentTimeMillis() + "a" + fileCounter++;
            String fileWithPorts = "GBports" + id;
            String uccHomePath = UCCWrapper.getUnrealHome();
            String systemDirPath = uccHomePath + File.separator + "System" + File.separator;
            String execStr = systemDirPath + System.getProperty(UCC_EXEC);
            String options = "";
            if (!System.getProperty("os.name").contains("Windows")) {
                options = " -nohomedir";
            }
            ProcessBuilder procBuilder = new ProcessBuilder(execStr, "server", "CTF-1on1-Joust?game=BotAPI.BotCTFGame?PortsLog=" + fileWithPorts + "?bRandomPorts=true?Mutator=UnrealGame.MutGameSpeed?GameSpeed=3" + options);
            procBuilder.directory(new File(systemDirPath));
            Process uccProcess = procBuilder.start();
            ScannerSink scanner = new ScannerSink(uccProcess.getInputStream());
            scanner.start();
            new StreamSink(uccProcess.getErrorStream()).start();
            scanner.portsBindedLatch.await();
            if (scanner.exception != null) {
                uccProcess.destroy();
                throw scanner.exception;
            }
            UTServer server = new UTServer();
            server.setAutomaticallyReconnect(false);
            server.setGamebotsControlConnectionURI(URI.create("ut://localhost:" + scanner.controlPort));
            server.setGamebotsBotURI(URI.create("ut://localhost:" + scanner.botsPort));
            return new UCCWrapper(scanner.botsPort, scanner.controlPort, uccProcess, server);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(UCCWrapper.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static UCCWrapper create(long maxTimeInPool) throws UCCStartException {
        UCCWrapper ucc = UCCWrapper.create();
        ucc.killAfter = maxTimeInPool;
        return ucc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UCCWrapper create() throws UCCStartException {
        UCCWrapper ucc = null;
        System.out.println("UCCWRAP " + stamp);
        Object object = poolRetrievalLock;
        synchronized (object) {
            if (uccPool.isEmpty()) {
                ucc = UCCWrapper.createNewInstance();
            } else {
                ucc = uccPool.iterator().next();
                ucc.terminationTask.cancel();
                uccPool.remove(ucc);
                if (ucc.poolCleanerTimer == null) {
                    ucc.poolCleanerTimer = new Timer("UCC pool cleaner");
                }
            }
            uccUnreleased.add(ucc);
            ucc.released = false;
        }
        return ucc;
    }

    protected UCCWrapper(int gbPort, int controlPort, Process uccProcess, UTServer utServer) {
        Runtime.getRuntime().addShutdownHook(new Thread("UCC wrapper finalizer"){

            public void run() {
                while (!uccPool.isEmpty()) {
                    uccPool.iterator().next().close();
                }
                while (!uccUnreleased.isEmpty()) {
                    uccUnreleased.iterator().next().close();
                }
            }
        });
        this.gbPort = gbPort;
        this.controlPort = controlPort;
        this.uccProcess = uccProcess;
        this.utServer = utServer;
    }

    public Process getProcess() {
        return this.uccProcess;
    }

    public void kill() {
        this.uccProcess.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        Object object = poolRetrievalLock;
        synchronized (object) {
            if (uccPool.remove(this)) {
                this.utServer.terminate();
                this.uccProcess.destroy();
                this.poolCleanerTimer.cancel();
                this.poolCleanerTimer = null;
            }
        }
    }

    public synchronized void release() {
        if (!this.released) {
            uccUnreleased.remove(this);
            uccPool.add(this);
            if (this.killAfter > 0L) {
                this.terminationTask = new TimerTask(){

                    public void run() {
                        UCCWrapper.this.close();
                    }
                };
                this.poolCleanerTimer.schedule(this.terminationTask, this.killAfter);
            } else {
                this.close();
            }
            this.released = true;
        }
    }

    public int getGbPort() {
        return this.gbPort;
    }

    public int getControlPort() {
        return this.controlPort;
    }

    public static class ScannerSink
    extends StreamSink {
        public long startingTimeout = 120000L;
        public UCCStartException exception = null;
        public CountDownLatch portsBindedLatch = new CountDownLatch(1);
        public int controlPort = -1;
        public int botsPort = -1;
        Timer timer = new Timer("UCC start timeout");
        TimerTask task = null;
        private final Pattern portPattern = Pattern.compile("ControlServerPort:(\\d*) BotServerPort:(\\d*)");
        private final Pattern commandletNotFoundPattern = Pattern.compile("Commandlet server not found");

        public ScannerSink(InputStream is) {
            super(is);
            this.task = new TimerTask(){

                public void run() {
                    ScannerSink.this.exception = new UCCStartException("Starting timed out. Ports weren't bound in the required time (" + ScannerSink.this.startingTimeout + " ms).");
                    ScannerSink.this.timer.cancel();
                    ScannerSink.this.portsBindedLatch.countDown();
                }
            };
            this.timer.schedule(this.task, this.startingTimeout);
        }

        protected void handleInput(String str) {
            if (this.portsBindedLatch.getCount() != 0L) {
                Matcher matcher = this.portPattern.matcher(str);
                if (matcher.find()) {
                    this.controlPort = Integer.parseInt(matcher.group(1));
                    this.botsPort = Integer.parseInt(matcher.group(2));
                    this.raiseLatch();
                }
                if ((matcher = this.commandletNotFoundPattern.matcher(str)).find()) {
                    this.exception = new UCCStartException("UCC failed to start due to: Commandlet server not found");
                    this.raiseLatch();
                }
            }
            System.out.println(str);
        }

        protected void raiseLatch() {
            this.timer.cancel();
            this.task.cancel();
            this.portsBindedLatch.countDown();
        }
    }

    protected static class StreamSink
    extends Thread {
        protected InputStream os = null;

        public StreamSink(InputStream os) {
            this.setName("Stream handler");
            this.os = os;
        }

        protected void handleInput(String str) {
            System.out.println(str);
        }

        public void run() {
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(this.os));
            String s = null;
            try {
                while ((s = stdInput.readLine()) != null) {
                    this.handleInput(s);
                }
                this.os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

