/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.Client;

import cz.cuni.astar.AStar;
import cz.cuni.astar.AStarResult;
import cz.cuni.pogamut.Client.AgentBody;
import cz.cuni.pogamut.Client.AgentMemory;
import cz.cuni.pogamut.Client.GameMapAStarGoal;
import cz.cuni.pogamut.Client.GameMapAStarMap;
import cz.cuni.pogamut.Client.GameMapSettings;
import cz.cuni.pogamut.Client.ItemDistance;
import cz.cuni.pogamut.Client.Navigation;
import cz.cuni.pogamut.Client.PathManager;
import cz.cuni.pogamut.Client.PathTypes;
import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.MessageObjects.Health;
import cz.cuni.pogamut.MessageObjects.Item;
import cz.cuni.pogamut.MessageObjects.MessageObject;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.Mover;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import cz.cuni.pogamut.MessageObjects.NeighNav;
import cz.cuni.pogamut.MessageObjects.Path;
import cz.cuni.pogamut.MessageObjects.Player;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.communication.CommunicationState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameMap
implements RcvMsgListener,
Navigation {
    protected Logger platformLog;
    private AgentBody body = null;
    private AgentMemory memory = null;
    private Item nextItem = null;
    private int nextItemIndex = 0;
    public PathManager pathManager = null;
    int tempCounter = 0;

    public GameMap(Logger logger) {
        this.platformLog = logger;
    }

    public GameMap(Logger logger, AgentBody body) {
        this.platformLog = logger;
        this.body = body;
        this.pathManager = new PathManager(this);
        this.body.addTypedRcvMsgListener(this, MessageType.PATH);
        this.body.addRcvMsgListener(this, EnumSet.of(MessageType.SPAWN));
    }

    public GameMap(Logger logger, AgentBody body, AgentMemory memory) {
        this.platformLog = logger;
        this.body = body;
        this.body.addTypedRcvMsgListener(this, MessageType.PATH);
        this.pathManager = new PathManager(this);
        this.memory = memory;
        this.body.addRcvMsgListener(this, EnumSet.of(MessageType.SPAWN));
    }

    @Override
    public ArrayList<Item> nearestHealth(int strength, int numberOfHealths) {
        ArrayList<Health> candidates = this.memory.getKnownHealths();
        ArrayList<Health> processedCandidates = new ArrayList<Health>();
        for (Health health : candidates) {
            if (health.strength < strength) continue;
            processedCandidates.add(health);
        }
        ArrayList<ItemDistance> res = new ArrayList<ItemDistance>();
        AStarResult aStarResult = null;
        for (Health health : processedCandidates) {
            aStarResult = this.getPathAStar(health.navPoint);
            if (!aStarResult.success) continue;
            res.add(new ItemDistance(health, aStarResult.getDistanceToGoal()));
        }
        Collections.sort(res);
        ArrayList<Item> result = new ArrayList<Item>();
        for (int i = 0; i < res.size() && i < numberOfHealths; ++i) {
            result.add(((ItemDistance)res.get((int)i)).item);
        }
        return result;
    }

    @Override
    public ArrayList<Item> nearestItems(MessageType type, int numberOfItems) {
        ArrayList<Item> candidates = this.memory.getKnownItemsOfType(type);
        ArrayList<ItemDistance> res = new ArrayList<ItemDistance>();
        AStarResult aStarResult = null;
        for (Item item : candidates) {
            aStarResult = this.getPathAStar(item.navPoint);
            if (!aStarResult.success) continue;
            res.add(new ItemDistance(item, aStarResult.getDistanceToGoal()));
        }
        Collections.sort(res);
        ArrayList<Item> result = new ArrayList<Item>();
        for (int i = 0; i < res.size() && i < numberOfItems; ++i) {
            result.add(((ItemDistance)res.get((int)i)).item);
        }
        return result;
    }

    @Override
    public NavPoint nearestNavPoint(Triple from) {
        return this.nearestNavPoint(from, 0);
    }

    @Override
    public NavPoint nearestNavPoint(Triple from, int minDistance) {
        double distance;
        ArrayList<MessageObject> candidates = this.body.knownObjects.getObjectsOfType(MessageType.NAV_POINT);
        double currentDistance = distance = Double.MAX_VALUE;
        NavPoint closest = null;
        NavPoint temp = null;
        for (MessageObject candidate : candidates) {
            temp = (NavPoint)candidate;
            if (temp.location == null || !(distance > (currentDistance = Triple.distanceInSpace(temp.location, from))) || !((double)minDistance < currentDistance)) continue;
            distance = currentDistance;
            closest = temp;
        }
        return closest;
    }

    @Override
    public void sendGetPathToNavPoint(NavPoint toWhat) {
        this.body.getPath(toWhat.getLocation(), toWhat.ID);
    }

    @Override
    public void sendGetPathToLocation(int ID, Triple toWhat) {
        this.body.getPath(toWhat, ID);
    }

    @Override
    public ArrayList<NavPoint> getPathOfID(int ID) {
        return this.pathManager.collectedPaths.get(ID);
    }

    @Override
    public AStarResult getPathAStar(NavPoint toWhat, int maxNumOfIterations) {
        if (toWhat == null) {
            return null;
        }
        GameMapAStarGoal goal = new GameMapAStarGoal(toWhat);
        GameMapAStarMap map = new GameMapAStarMap();
        NavPoint start = new NavPoint();
        start.location = this.memory.getAgentLocation();
        start.neighbours = new ArrayList();
        ArrayList<NavPoint> nvs = this.memory.seeAllNavPoints();
        for (int i = 0; i < nvs.size(); ++i) {
            NeighNav nn = new NeighNav();
            nn.neighbour = nvs.get(i);
            start.neighbours.add(nn);
        }
        assert (goal != null);
        assert (map != null);
        assert (start != null);
        return AStar.aStar(goal, map, start, maxNumOfIterations);
    }

    @Override
    public ArrayList<NavPoint> getNavPointsAStar(AStarResult result) {
        if (result.success) {
            ArrayList path = result.getPath();
            ArrayList<NavPoint> navPoints = new ArrayList<NavPoint>();
            for (Object pathNode : path) {
                if (pathNode instanceof NavPoint) {
                    navPoints.add((NavPoint)pathNode);
                    continue;
                }
                if (pathNode instanceof NeighNav) {
                    navPoints.add(((NeighNav)pathNode).neighbour);
                    continue;
                }
                this.platformLog.severe("Wrong object in the A* path (" + pathNode.toString() + ").");
            }
            return navPoints;
        }
        return null;
    }

    @Override
    public AStarResult getPathAStar(NavPoint toWhat) {
        AStarResult result = this.getPathAStar(toWhat, -1);
        if (!result.success) {
            this.platformLog.info("PATH A*: failed unable to get path A Star");
        }
        return result;
    }

    @Override
    public void receiveMessage(RcvMsgEvent e) {
        if (e.getCommunicationState() != CommunicationState.BOT_RUNNING) {
            return;
        }
        switch (e.getMessage().type) {
            case PATH: {
                this.pathManager.newGBPathReceived((Path)e.getMessage());
                break;
            }
            case SPAWN: {
                this.restartMap();
                break;
            }
            default: {
                this.platformLog.warning("Unexpected message!!!");
            }
        }
    }

    public void initializeGetPath() {
        this.pathManager.pathRequestSent = false;
    }

    public ArrayList<NavPoint> getPathToLocation(Triple location) {
        return this.pathManager.getPathToLocation(location);
    }

    @Override
    public boolean stuckCheck() {
        boolean stucked = this.antiStuckCheck(this.pathManager.getCurrentNavPointOfPath().location);
        boolean attempts = false;
        ++this.pathManager.walking;
        if (this.pathManager.walking > GameMapSettings.maxWalkingAttempts) {
            attempts = true;
        }
        if (attempts && stucked) {
            attempts = false;
            this.platformLog.fine("REPLAN because bot reached max ATTEMPTS and was STUCKED");
            return false;
        }
        return true;
    }

    @Override
    public boolean runAlongPath() {
        if (this.pathManager.pathToRunAlong == null) {
            this.platformLog.warning("procedure called when the variables were not properly initialized!");
            return false;
        }
        if (this.pathManager.getCurrentNavPointOfPath() == null) {
            this.platformLog.fine("runAlongPath - PATH END : " + this.pathManager.pathToRunAlong);
            return false;
        }
        NavPoint nav1 = this.pathManager.getCurrentNavPointOfPath();
        if (this.pathManager.getNextNavPointOfPath() == null && this.pathManager.nextNavPointIndex < this.pathManager.pathToRunAlong.size() && Triple.distanceInSpace(this.memory.getAgentLocation(), nav1.location) < (double)GameMapSettings.lastNavigationPointOfPathPrecision) {
            this.platformLog.info("Last nav point of the path approached.");
            this.pathManager.walking = 0;
            ++this.pathManager.nextNavPointIndex;
            return true;
        }
        if (Triple.distanceInSpace(this.memory.getAgentLocation(), nav1.location) < (double)GameMapSettings.switchingDistance) {
            this.platformLog.info("Switching to another navigation point. Last point: " + nav1.UnrealID);
            this.pathManager.walking = 0;
            ++this.pathManager.nextNavPointIndex;
            return true;
        }
        if (nav1 == null || nav1.UnrealID == null) {
            ++this.pathManager.nextNavPointIndex;
            return true;
        }
        if (nav1.UnrealID.indexOf("LiftCenter") != -1 && Triple.distanceInPlane(this.memory.getAgentLocation(), nav1.location) < (double)GameMapSettings.switchingDistance) {
            this.platformLog.info("Switching to another navigation point. Last point: " + nav1.UnrealID);
            this.pathManager.walking = 0;
            ++this.pathManager.nextNavPointIndex;
            return true;
        }
        if (this.pathManager.getNextNavPointOfPath() != null) {
            NavPoint nav2 = this.pathManager.getNextNavPointOfPath();
            try {
                if (nav1.UnrealID.indexOf("LiftCenter") != -1 && nav2.UnrealID.indexOf("LiftExit") != -1 && this.memory.getAgentLocation().z - nav1.location.z < 50.0) {
                    if (!this.memory.getSeeAnyMover()) {
                        return false;
                    }
                    Mover mov = this.memory.getSeeMover();
                    if (mov.location.z - this.memory.getAgentLocation().z > (double)GameMapSettings.levelForEnteringLift) {
                        this.platformLog.fine("Waiting for MOVER to come DOWN");
                        ++this.pathManager.walking;
                        if (this.pathManager.walking > GameMapSettings.maxWalkingAttempts) {
                            this.pathManager.walking = 0;
                            return false;
                        }
                        return true;
                    }
                    this.platformLog.fine("ENTERING the Mover");
                    this.body.runToNavPoint(nav1);
                    this.pathManager.isUpOnTheLift = true;
                    return this.stuckCheck();
                }
                if (this.pathManager.isUpOnTheLift && nav1.UnrealID.indexOf("LiftExit") != 1) {
                    if (!this.memory.getSeeAnyMover()) {
                        return false;
                    }
                    if (nav1.location.z - this.memory.getAgentLocation().z < (double)GameMapSettings.levelForLeavingLift) {
                        this.platformLog.fine("LEAVING MOVER!");
                        this.pathManager.isUpOnTheLift = false;
                        this.body.runToNavPoint(nav1);
                        return this.stuckCheck();
                    }
                    this.body.turnToLocation(nav1.location);
                    ++this.pathManager.walking;
                    if (this.pathManager.walking > GameMapSettings.maxWalkingAttempts) {
                        this.pathManager.walking = 0;
                        return false;
                    }
                    this.platformLog.fine("GOING UP " + (nav1.location.z - this.memory.getAgentLocation().z));
                    return true;
                }
                this.body.moveAlongNavPoints(1.0, nav1, nav2);
                return this.stuckCheck();
            }
            catch (NullPointerException e) {
                this.platformLog.warning("Null pointer exception in run along path " + e.getMessage());
            }
        } else if (this.pathManager.nextNavPointIndex < this.pathManager.pathToRunAlong.size()) {
            this.body.runToNavPoint(nav1);
            return this.stuckCheck();
        }
        return false;
    }

    @Override
    public void runAroundItemsInTheMap(List<? extends Item> itemsToRunAround, boolean AStar2) {
        if (itemsToRunAround.size() == 0) {
            this.platformLog.warning("no items to run around!!!");
            return;
        }
        if (this.nextItem == null) {
            this.platformLog.fine("TOTAL RESTART OF RUN AROUND ITEMS IN MAP");
            Collections.shuffle(itemsToRunAround);
            this.nextItem = itemsToRunAround.get(0);
            this.nextItemIndex = 0;
            return;
        }
        if (this.nextItem == null) {
            return;
        }
        if (this.pathManager.checkPath(PathTypes.ITEM, this.nextItem)) {
            if (this.pathManager.pathToRunAlong.size() < 1) {
                this.platformLog.info("too short path to run along to next - restart");
                this.nextItem = null;
                return;
            }
            if (this.runAlongPath()) {
                return;
            }
        } else {
            this.pathManager.preparePath(PathTypes.ITEM, this.nextItem, AStar2);
            return;
        }
        if (++this.nextItemIndex < itemsToRunAround.size()) {
            this.nextItem = itemsToRunAround.get(this.nextItemIndex);
            this.platformLog.info("SWITCHING - running to another item in the list. \nNext item is: " + this.nextItem.cls);
        } else {
            this.nextItem = null;
        }
    }

    public void restartMap() {
        this.nextItem = null;
        this.nextItemIndex = 0;
        this.pathManager = new PathManager(this);
    }

    public boolean antiStuckCheck(Triple goal) {
        Triple velocity = this.memory.getAgentVelocity();
        Triple location = this.memory.getAgentLocation();
        Triple nextPosition = Triple.add(velocity, location);
        double distanceDifference = Triple.vectorSize(Triple.subtract(goal, location));
        if ((distanceDifference -= Triple.vectorSize(Triple.subtract(goal, nextPosition))) < (double)GameMapSettings.distanceDifference) {
            this.platformLog.finest("DIFFERENCE " + this.tempCounter);
            ++this.tempCounter;
            return true;
        }
        if (Triple.vectorSize(velocity) < (double)GameMapSettings.minimalVelocity) {
            this.platformLog.finest("VELO " + Triple.vectorSize(velocity));
            return true;
        }
        if (goal.z - location.z > (double)GameMapSettings.heightLevel) {
            this.platformLog.finest("HIGH HIGH HIGH HIGH ");
            return true;
        }
        return false;
    }

    @Override
    public boolean safeRunToLocation(Triple location) {
        if (Triple.distanceInSpace(this.memory.getAgentLocation(), location) < 500.0) {
            this.body.runToLocation(location);
            return true;
        }
        if (!this.pathManager.checkPath(PathTypes.LOCATION, location)) {
            this.pathManager.preparePath(PathTypes.LOCATION, location, false);
            return true;
        }
        return this.runAlongPath();
    }

    public boolean safeRunToPlayer(Player plr) {
        if (!this.pathManager.checkPath(PathTypes.PLAYER, plr)) {
            this.pathManager.preparePath(PathTypes.PLAYER, plr, false);
            return true;
        }
        return this.runAlongPath();
    }

    public void initializeRunAlongPath(ArrayList<NavPoint> path) {
        this.pathManager.initializeRunAlongPathManually(path);
    }
}

