/*
 * Decompiled with CFR 0.152.
 */
package raycastingbot;

import cz.cuni.pogamut.Client.Agent;
import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.MessageObjects.AutoTraceRay;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.exceptions.PogamutException;
import java.util.HashMap;
import java.util.Map;

public class Main
extends Agent {
    private RayTraces traces = new RayTraces();
    private boolean init = true;

    private void init() {
        this.traces.botInit();
    }

    @Override
    protected void doLogic() {
        if (this.init) {
            this.init();
            this.init = false;
        }
        this.log.warning("LOGIC ITERATION");
        Map<Integer, AutoTraceRay> rays = this.traces.getTraceSnapshot();
        for (AutoTraceRay ray : rays.values()) {
            this.log.info(ray.toString());
        }
        if (rays.get((Object)Integer.valueOf((int)Ray.STRAIGHT_AHEAD_200.getId())).result) {
            this.body.turnHorizontal(90);
            return;
        }
        if (rays.get((Object)Integer.valueOf((int)Ray.LEFT90_200.getId())).result) {
            this.body.turnHorizontal(15);
            return;
        }
        if (rays.get((Object)Integer.valueOf((int)Ray.LEFT45_200.getId())).result) {
            this.body.turnHorizontal(45);
            return;
        }
        if (rays.get((Object)Integer.valueOf((int)Ray.RIGHT90_200.getId())).result) {
            this.body.turnHorizontal(-15);
            return;
        }
        if (rays.get((Object)Integer.valueOf((int)Ray.RIGHT45_200.getId())).result) {
            this.body.turnHorizontal(-45);
            return;
        }
        this.body.contMove(0.7f);
    }

    @Override
    protected void prePrepareAgent() throws PogamutException {
    }

    @Override
    protected void postPrepareAgent() throws PogamutException {
    }

    @Override
    protected void shutdownAgent() throws PogamutException {
    }

    public static void main(String[] args) {
    }

    private class RayTraces
    implements RcvMsgListener {
        private Map<Integer, AutoTraceRay> traces = new HashMap<Integer, AutoTraceRay>();

        public void botInit() {
            Main.this.log.info("RayTraces.botInit(): called");
            Main.this.body.startAutoTrace();
            Main.this.body.removeAllRaysFromAutoTrace();
            for (Ray ray : Ray.values()) {
                Main.this.body.addRayToAutoTrace(ray.getId(), ray.getVector(), ray.getLength(), false, false);
                this.traces.put(ray.getId(), new AutoTraceRay());
            }
            Main.this.body.addTypedRcvMsgListener(this, MessageType.AUTO_TRACE_RAY);
            Main.this.body.moveInch();
            Main.this.body.configureAutoTrace(false);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Main.this.body.configureAutoTrace(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receiveMessage(RcvMsgEvent e) {
            AutoTraceRay ray = (AutoTraceRay)e.getMessage();
            try {
                Map<Integer, AutoTraceRay> map = this.traces;
                synchronized (map) {
                    this.traces.put(Integer.parseInt(ray.UnrealID), ray);
                }
            }
            catch (Exception ex) {
                Main.this.log.severe(ex.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AutoTraceRay getTrace(Ray ray) {
            Map<Integer, AutoTraceRay> map = this.traces;
            synchronized (map) {
                return this.traces.get(ray.getId());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map<Integer, AutoTraceRay> getTraceSnapshot() {
            Map<Integer, AutoTraceRay> map = this.traces;
            synchronized (map) {
                return new HashMap<Integer, AutoTraceRay>(this.traces);
            }
        }
    }

    public static enum Ray {
        STRAIGHT_AHEAD_200(1, new Triple(1.0, 0.0, 0.0), 200.0),
        LEFT45_200(2, new Triple(1.0, 1.0, 0.0), 200.0),
        LEFT90_200(3, new Triple(0.0, 1.0, 0.0), 200.0),
        RIGHT45_200(4, new Triple(1.0, -1.0, 0.0), 200.0),
        RIGHT90_200(5, new Triple(0.0, -1.0, 0.0), 200.0);

        private int id;
        private Triple vector;
        private double length;

        private Ray(int id, Triple vector, double length) {
            this.id = id;
            this.vector = vector;
            this.length = length;
        }

        public int getId() {
            return this.id;
        }

        public Triple getVector() {
            return this.vector;
        }

        public double getLength() {
            return this.length;
        }
    }
}

