/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils.math.vertexSpace.vertex3Dspace;

import cz.cuni.utils.math.Tuple3D;
import cz.cuni.utils.math.extended.Vertex3D;
import cz.cuni.utils.math.vertexSpace.vertex3Dspace.Vertex3DFactory;
import cz.cuni.utils.math.vertexSpace.vertex3Dspace.Vertex3DFactoryInterface;
import cz.cuni.utils.math.vertexSpace.vertex3Dspace.Vertex3DSpaceInterface;
import java.util.HashMap;

public class Vertex3DSpaceSimple
implements Vertex3DSpaceInterface {
    public final Vertex3DFactoryInterface vertexFactory;
    public HashMap vertices = new HashMap();

    public Vertex3DSpaceSimple(Vertex3DFactoryInterface vfi) {
        this.vertexFactory = vfi;
    }

    public Vertex3D get(Tuple3D t) {
        Vertex3D v = this.vertexFactory.getNewInstance(t);
        if (this.vertices.containsKey(v)) {
            return (Vertex3D)this.vertices.get(v);
        }
        this.vertices.put(v, v);
        return v;
    }

    public Vertex3D get(double x, double y, double z) {
        return this.get(new Tuple3D(x, y, z));
    }

    public void set(Vertex3D v) {
        this.vertices.put(v, v);
    }

    public void remove(Vertex3D v) {
        this.vertices.remove(v);
    }

    public void clear() {
        this.vertices = new HashMap();
    }

    public static void main(String[] args) {
        Vertex3DSpaceSimple vs = new Vertex3DSpaceSimple(new Vertex3DFactory());
        Tuple3D[] tuples = new Tuple3D[]{new Tuple3D(1.0, 0.0, 0.0), new Tuple3D(0.0, 1.0, 0.0), new Tuple3D(0.0, 0.0, 1.0), new Tuple3D(1.0001, 0.0, 0.0), new Tuple3D(0.0, 1.0001, 0.0), new Tuple3D(0.0, 0.0, 1.0001), new Tuple3D(1.015, 0.0, 0.0), new Tuple3D(1.009, 0.0, 0.0), new Tuple3D(0.0095, 0.02, 0.05), new Tuple3D(0.01, 0.02, 0.05), new Tuple3D(0.015, 0.02, 0.05), new Tuple3D(0.02, 0.02, 0.05), new Tuple3D(0.025, 0.02, 0.05)};
        for (int i = 0; i < tuples.length; ++i) {
            System.out.println("Adding: " + tuples[i]);
            Vertex3D v = vs.get(tuples[i]);
            if (v == null) {
                System.out.println("Collision: " + tuples[i]);
                continue;
            }
            System.out.println("V" + i + "    = " + v);
        }
    }
}

