/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils.math;

import cz.cuni.utils.math.M;

public class Tuple3D
implements Cloneable {
    public double[] xyz = new double[]{0.0, 0.0, 0.0};

    public Tuple3D() {
    }

    public Tuple3D(double[] iXYZ) {
        this.xyz[0] = iXYZ[0];
        this.xyz[1] = iXYZ[1];
        this.xyz[2] = iXYZ[2];
    }

    public Tuple3D(double x, double y, double z) {
        this.xyz[0] = x;
        this.xyz[1] = y;
        this.xyz[2] = z;
    }

    public Tuple3D(Tuple3D tuple) {
        this.xyz[0] = tuple.xyz[0];
        this.xyz[1] = tuple.xyz[1];
        this.xyz[2] = tuple.xyz[2];
    }

    public Tuple3D(Tuple3D tuple1, Tuple3D tuple2) {
        this.xyz[0] = tuple1.xyz[0] - tuple2.xyz[0];
        this.xyz[1] = tuple1.xyz[1] - tuple2.xyz[1];
        this.xyz[2] = tuple1.xyz[2] - tuple2.xyz[2];
    }

    public Object clone() {
        return new Tuple3D(this);
    }

    public boolean equals(double x, double y, double z) {
        return Math.abs(this.xyz[0] - x) < M.EPSILON && Math.abs(this.xyz[1] - y) < M.EPSILON && Math.abs(this.xyz[2] - z) < M.EPSILON;
    }

    public boolean equals(Tuple3D t) {
        return Math.abs(this.xyz[0] - t.xyz[0]) < M.EPSILON && Math.abs(this.xyz[1] - t.xyz[1]) < M.EPSILON && Math.abs(this.xyz[2] - t.xyz[2]) < M.EPSILON;
    }

    public boolean equals(Tuple3D t, double precision) {
        return Math.abs(this.xyz[0] - t.xyz[0]) < precision && Math.abs(this.xyz[1] - t.xyz[1]) < M.EPSILON && Math.abs(this.xyz[2] - t.xyz[2]) < precision;
    }

    public Tuple3D assign(double x, double y, double z) {
        this.xyz[0] = x;
        this.xyz[1] = y;
        this.xyz[2] = z;
        return this;
    }

    public Tuple3D abs() {
        this.xyz[0] = Math.abs(this.xyz[0]);
        this.xyz[1] = Math.abs(this.xyz[1]);
        this.xyz[2] = Math.abs(this.xyz[2]);
        return this;
    }

    public Tuple3D assign(Tuple3D a) {
        this.xyz[0] = a.xyz[0];
        this.xyz[1] = a.xyz[1];
        this.xyz[2] = a.xyz[2];
        return this;
    }

    public Tuple3D plus(double[] xyz_) {
        this.xyz[0] = this.xyz[0] + xyz_[0];
        this.xyz[1] = this.xyz[1] + xyz_[1];
        this.xyz[2] = this.xyz[2] + xyz_[2];
        return this;
    }

    public Tuple3D plus(Tuple3D a) {
        this.xyz[0] = this.xyz[0] + a.xyz[0];
        this.xyz[1] = this.xyz[1] + a.xyz[1];
        this.xyz[2] = this.xyz[2] + a.xyz[2];
        return this;
    }

    public Tuple3D inverse() {
        this.xyz[0] = -this.xyz[0];
        this.xyz[1] = -this.xyz[1];
        this.xyz[2] = -this.xyz[2];
        return this;
    }

    public double sqrLength() {
        return this.xyz[0] * this.xyz[0] + this.xyz[1] * this.xyz[1] + this.xyz[2] * this.xyz[2];
    }

    public double length() {
        return Math.sqrt(this.xyz[0] * this.xyz[0] + this.xyz[1] * this.xyz[1] + this.xyz[2] * this.xyz[2]);
    }

    public Tuple3D normalize() {
        double len = this.length();
        if (Math.abs(len) < M.EPSILON) {
            this.xyz[0] = 0.0;
            this.xyz[1] = 0.0;
            this.xyz[2] = 0.0;
        } else {
            this.xyz[0] = this.xyz[0] / len;
            this.xyz[1] = this.xyz[1] / len;
            this.xyz[2] = this.xyz[2] / len;
        }
        return this;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(this.xyz[0]);
        sb.append(" / ");
        sb.append(this.xyz[1]);
        sb.append(" / ");
        sb.append(this.xyz[2]);
        sb.append("]");
        return sb.toString();
    }

    public Tuple3D getInverse() {
        return new Tuple3D(-this.xyz[0], -this.xyz[1], -this.xyz[2]);
    }
}

