/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils.math;

import cz.cuni.utils.math.M;

public class Tuple2D
implements Cloneable {
    public double[] xy = new double[]{0.0, 0.0};

    public Tuple2D() {
    }

    public Tuple2D(double[] iXY) {
        this.xy[0] = iXY[0];
        this.xy[1] = iXY[1];
    }

    public Tuple2D(double x, double y) {
        this.xy[0] = x;
        this.xy[1] = y;
    }

    public Tuple2D(Tuple2D tuple) {
        this.xy[0] = tuple.xy[0];
        this.xy[1] = tuple.xy[1];
    }

    public Tuple2D(Tuple2D tuple1, Tuple2D tuple2) {
        this.xy[0] = tuple1.xy[0] - tuple2.xy[0];
        this.xy[1] = tuple1.xy[1] - tuple2.xy[1];
    }

    public Object clone() {
        return new Tuple2D(this);
    }

    public boolean equals(double x, double y) {
        return Math.abs(this.xy[0] - x) < M.EPSILON && Math.abs(this.xy[1] - y) < M.EPSILON;
    }

    public boolean equals(Tuple2D t) {
        return this.equals(t, M.EPSILON);
    }

    public boolean equals(Tuple2D t, double precision) {
        return Math.abs(this.xy[0] - t.xy[0]) < precision && Math.abs(this.xy[1] - t.xy[1]) < precision;
    }

    public Tuple2D assign(double x, double y) {
        this.xy[0] = x;
        this.xy[1] = y;
        return this;
    }

    public Tuple2D assign(Tuple2D a) {
        this.xy[0] = a.xy[0];
        this.xy[1] = a.xy[1];
        return this;
    }

    public Tuple2D plus(double[] xy_) {
        this.xy[0] = this.xy[0] + xy_[0];
        this.xy[1] = this.xy[1] + xy_[1];
        return this;
    }

    public Tuple2D plus(Tuple2D a) {
        this.xy[0] = this.xy[0] + a.xy[0];
        this.xy[1] = this.xy[1] + a.xy[1];
        return this;
    }

    public Tuple2D inverse() {
        this.xy[0] = -this.xy[0];
        this.xy[1] = -this.xy[1];
        return this;
    }

    public double sqrLength() {
        return this.xy[0] * this.xy[0] + this.xy[1] * this.xy[1];
    }

    public double length() {
        return Math.sqrt(this.xy[0] * this.xy[0] + this.xy[1] * this.xy[1]);
    }

    public Tuple2D normalize() {
        double len = this.length();
        if (Math.abs(len) < M.EPSILON) {
            this.xy[0] = 0.0;
            this.xy[1] = 0.0;
        } else {
            this.xy[0] = this.xy[0] / len;
            this.xy[1] = this.xy[1] / len;
        }
        return this;
    }

    public Tuple2D getNormalized() {
        double len = this.length();
        if (Math.abs(len) < M.EPSILON) {
            return new Tuple2D(0.0, 0.0);
        }
        return new Tuple2D(this.xy[0] / len, this.xy[1] / len);
    }

    public Tuple2D abs() {
        this.xy[0] = Math.abs(this.xy[0]);
        this.xy[1] = Math.abs(this.xy[1]);
        return this;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(this.xy[0]);
        sb.append(" / ");
        sb.append(this.xy[1]);
        sb.append("]");
        return sb.toString();
    }

    public Tuple2D getInverse() {
        return new Tuple2D(this).inverse();
    }
}

