/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.MessageObjects;

import cz.cuni.pogamut.MessageObjects.Located;
import cz.cuni.pogamut.MessageObjects.MessageObject;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.Triple;

public class FlagInfo
extends MessageObject
implements Located {
    public Triple location = null;
    public int holderID = 0;
    public String holderUnrealID = null;
    public int team = -1;
    public boolean reachable = false;
    public String state = "";

    public FlagInfo() {
        super(MessageType.FLAG_INFO);
    }

    public FlagInfo(int ID, String UnrealID, Triple location, boolean reachable, int team, int holderID, String state, boolean visible, String holderUnrealID) {
        super(MessageType.FLAG_INFO, ID, UnrealID, visible);
        this.location = location != null ? (Triple)location.clone() : null;
        this.reachable = reachable;
        this.visible = visible;
        this.team = team;
        this.state = state;
        this.holderID = holderID;
        this.holderUnrealID = holderUnrealID;
    }

    public boolean hasID() {
        return true;
    }

    public String toString() {
        String result = super.toString();
        result = result + ", location: " + String.valueOf(this.location) + ", holder: " + String.valueOf(this.holderID) + ", holderUID: " + String.valueOf(this.holderUnrealID);
        result = result + ", team: " + String.valueOf(this.team) + ", reachable: " + String.valueOf(this.reachable);
        result = result + ", visible: " + String.valueOf(this.visible) + ", state: " + this.state;
        return result;
    }

    public Object clone() {
        return new FlagInfo(this.ID, this.UnrealID, this.location, this.reachable, this.team, this.holderID, this.state, this.visible, this.holderUnrealID);
    }

    public boolean diff(MessageObject old) {
        FlagInfo oldFlagInfo = (FlagInfo)old;
        boolean changed = false;
        if (oldFlagInfo.location != null && this.location != null) {
            if (oldFlagInfo.location.equals(this.location)) {
                this.location = null;
            } else {
                oldFlagInfo.location = this.location;
                changed = true;
            }
        }
        if (oldFlagInfo.reachable != this.reachable) {
            oldFlagInfo.reachable = this.reachable;
            changed = true;
        }
        if (oldFlagInfo.visible != this.visible) {
            oldFlagInfo.visible = this.visible;
            changed = true;
        }
        if (oldFlagInfo.holderID != this.holderID) {
            oldFlagInfo.holderID = this.holderID;
            changed = true;
        }
        if (oldFlagInfo.state.equals(this.state)) {
            this.state = null;
        } else {
            oldFlagInfo.state = this.state;
            changed = true;
        }
        return changed;
    }

    public void update(MessageObject newMsgObj) {
        FlagInfo newFlagInfo = (FlagInfo)newMsgObj;
        if (newMsgObj.UnrealID != null) {
            this.UnrealID = newFlagInfo.UnrealID;
        }
        if (newFlagInfo.location != null) {
            this.location = newFlagInfo.location;
        }
        if (newFlagInfo.state != null) {
            this.state = newFlagInfo.state;
        }
        this.reachable = newFlagInfo.reachable;
        this.visible = newFlagInfo.visible;
        this.holderID = newFlagInfo.holderID;
        this.team = newFlagInfo.team;
    }

    public Triple getLocation() {
        return this.location;
    }
}

