/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils.math.vertexSpace.vertex2Dspace;

import cz.cuni.utils.HashCodes;
import cz.cuni.utils.math.M;
import cz.cuni.utils.math.Tuple2D;
import cz.cuni.utils.math.extended.Vertex2D;
import java.util.ArrayList;
import java.util.HashSet;

public class Vertex2DSpaceSquare {
    protected double[] x;
    protected double[] y;
    protected int precisionInt;
    protected double precision;
    protected final int hashCode;
    protected HashSet vertices = new HashSet();

    public static int getHash(double x, double y, double size, int precisionInt) {
        long precision = Math.round(Math.pow(10.0, precisionInt));
        HashCodes hc = HashCodes.getNewCounter();
        long iX = Math.round(x * (double)precision);
        long iY = Math.round(y * (double)precision);
        hc.add(HashCodes.hash(iX));
        hc.add(HashCodes.hash(iY));
        long iPrec = Math.round(size * (double)precision);
        hc.add(HashCodes.hash(iPrec));
        return hc.getHashCode();
    }

    public Vertex2DSpaceSquare(double iX, double iY, double iSize, int iPrecisionInt) {
        this.precisionInt = iPrecisionInt;
        this.precision = Math.pow(10.0, -this.precisionInt);
        long temp = Math.round(Math.pow(10.0, this.precisionInt));
        iX = (double)Math.round(iX * (double)temp) * this.precision;
        iY = (double)Math.round(iY * (double)temp) * this.precision;
        this.x = new double[]{iX, iX + iSize};
        this.y = new double[]{iY, iY + iSize};
        this.hashCode = Vertex2DSpaceSquare.getHash(iX, iY, iSize, this.precisionInt);
    }

    public Vertex2DSpaceSquare(double[] xy, double iSize, int iPrecisionInt) {
        this.x = new double[]{xy[0], xy[0] + iSize};
        this.y = new double[]{xy[1], xy[1] + iSize};
        this.precisionInt = iPrecisionInt;
        this.precision = Math.pow(10.0, -this.precisionInt);
        this.hashCode = Vertex2DSpaceSquare.getHash(xy[0], xy[1], iSize, this.precisionInt);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Vertex2DSpaceSquare)) {
            return false;
        }
        Vertex2DSpaceSquare vsc = (Vertex2DSpaceSquare)obj;
        if (vsc.precisionInt != this.precisionInt) {
            return false;
        }
        return M.equals(vsc.x[0], this.x[0], this.precision) && M.equals(vsc.x[1], this.x[1], this.precision) && M.equals(vsc.y[0], this.y[0], this.precision);
    }

    public ArrayList check(Tuple2D tuple) {
        ArrayList<Tuple2D> al = new ArrayList<Tuple2D>();
        for (Tuple2D t : this.vertices) {
            if (!M.equals(tuple, t, this.precision)) continue;
            al.add(t);
        }
        return al;
    }

    public void remove(Vertex2D v) {
        this.vertices.remove(v);
    }

    public Vertex2D addReferenceUnsafe(Vertex2D v) {
        this.vertices.add(v);
        return v;
    }
}

