/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils.math.extended;

import cz.cuni.utils.HashCodes;
import cz.cuni.utils.math.M;
import cz.cuni.utils.math.Plane3D;
import cz.cuni.utils.math.Tuple3D;

public class Plane3DExtended
extends Plane3D {
    public final int hashCode;

    public Plane3DExtended(double x, double y, double z, double d) {
        super(x, y, z, d);
        this.normalizePlane();
        this.hashCode = this.countHashCode();
    }

    public String toString() {
        return "Plane3DExtended(" + this.t4d.xyzd[0] + "x+" + this.t4d.xyzd[1] + "y+" + this.t4d.xyzd[2] + "z+" + this.t4d.xyzd[3] + ")";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public Plane3DExtended(Tuple3D iNormal, double d) {
        super(iNormal, d);
        this.normalizePlane();
        this.hashCode = this.countHashCode();
    }

    public Plane3DExtended(Tuple3D iNormal, Tuple3D point) {
        super(iNormal, point);
        this.normalizePlane();
        this.hashCode = this.countHashCode();
    }

    public Plane3DExtended(Tuple3D a, Tuple3D b, Tuple3D c) {
        super(a, b, c);
        this.normalizePlane();
        this.hashCode = this.countHashCode();
    }

    public Plane3DExtended(Plane3D a) {
        super(a);
        this.normalizePlane();
        this.hashCode = this.countHashCode();
    }

    protected void normalizePlane() {
        this.recountPlane(M.normalizedNormal(this.normal));
    }

    public int getHashCode() {
        return this.hashCode;
    }

    protected int countHashCode() {
        HashCodes hc = HashCodes.getNewCounter();
        hc.add(HashCodes.hash(M.doubleToLong(this.normal.xyz[0])));
        hc.add(HashCodes.hash(M.doubleToLong(this.normal.xyz[1])));
        hc.add(HashCodes.hash(M.doubleToLong(this.normal.xyz[2])));
        return hc.getHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Plane3DExtended)) {
            return false;
        }
        Plane3DExtended plane = (Plane3DExtended)o;
        return M.equals(this.getCommonPoint(), plane.getCommonPoint());
    }
}

