/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.utils;

import cz.cuni.utils.Flag;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunnableTemplate
implements Runnable {
    private Flag<Boolean> threadAlive = new Flag<Boolean>(false);
    private CountDownLatch communicationLatch = new CountDownLatch(1);
    private Flag<Boolean> communicationAlive = new Flag<Boolean>(false);
    private Thread thread = null;

    public Flag<Boolean> getThreadAliveFlag() {
        return this.threadAlive;
    }

    public boolean isThreadAlive() {
        return this.threadAlive.getFlag();
    }

    public Flag<Boolean> getCommunicationAliveFlag() {
        return this.communicationAlive;
    }

    public boolean isCommunicationAlive() {
        return this.communicationAlive.getFlag();
    }

    public boolean waitForCommunication() {
        try {
            this.communicationLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.communicationAlive.getFlag();
    }

    public boolean waitForCommunication(long timeOut, TimeUnit unit) {
        try {
            this.communicationLatch.await(timeOut, unit);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return this.communicationAlive.getFlag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void communicationSettedUp() {
        this.communicationAlive.setFlag(true);
        CountDownLatch countDownLatch = this.communicationLatch;
        synchronized (countDownLatch) {
            while (this.communicationLatch.getCount() != 0L) {
                this.communicationLatch.countDown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void communicationDied() {
        this.communicationAlive.setFlag(false);
        CountDownLatch countDownLatch = this.communicationLatch;
        synchronized (countDownLatch) {
            while (this.communicationLatch.getCount() != 0L) {
                this.communicationLatch.countDown();
            }
            this.communicationLatch = new CountDownLatch(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread runThread() {
        Flag<Boolean> flag = this.threadAlive;
        synchronized (flag) {
            if (this.threadAlive.getFlag().booleanValue()) {
                return null;
            }
            this.thread = new Thread(this);
            this.thread.start();
        }
        return this.thread;
    }

    public Thread getThread() {
        return this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.thread == null) {
            System.out.println("run() wasn't called from runThread(), this.thread == null, returning");
            return;
        }
        this.threadAlive.setFlag(true);
        this.threadAlive.setFlag(false);
        Thread thread = this.thread;
        synchronized (thread) {
            this.thread = null;
        }
    }
}

