/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.server;

import cz.cuni.pogamut.exceptions.UCCStartException;
import cz.cuni.pogamut.server.UTServer;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UCCWrapper {
    protected Logger uccLog = Logger.getAnonymousLogger();
    public static final String UNREAL_HOME = "pogamut.unreal.home";
    public static final String UCC_EXEC = "pogamut.unreal.serverexec";
    protected static Collection<UCCWrapper> uccPool = Collections.synchronizedList(new ArrayList());
    protected static Collection<UCCWrapper> uccUnreleased = Collections.synchronizedList(new ArrayList());
    protected Timer poolCleanerTimer = new Timer("UCC pool cleaner");
    protected TimerTask terminationTask = null;
    protected static int fileCounter = 0;
    Process uccProcess = null;
    protected int gbPort = -1;
    protected int controlPort = -1;
    protected UTServer utServer = null;
    protected static final int basePort = 39782;
    protected static Integer nextUccWrapperUID = 0;
    protected int uccWrapperUID = 0;
    protected String mapName = "DM-DodgingMap01";
    protected String gameType = "BotDeathMatch";
    public static long stamp = System.currentTimeMillis();
    protected long killAfter = 120000L;
    private static Object poolRetrievalLock = new Object();
    protected boolean released = false;

    public Logger getLogger() {
        return this.uccLog;
    }

    public UTServer getUTServer() {
        return this.utServer;
    }

    protected static String getUnrealHome() {
        return System.getProperty(UNREAL_HOME);
    }

    public static UCCWrapper create(long maxTimeInPool) throws UCCStartException {
        return UCCWrapper.create(maxTimeInPool, null);
    }

    public static UCCWrapper create(long maxTimeInPool, Logger parent) throws UCCStartException {
        UCCWrapper ucc = UCCWrapper.create(parent);
        ucc.killAfter = maxTimeInPool;
        return ucc;
    }

    public static UCCWrapper create() throws UCCStartException {
        return UCCWrapper.create(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UCCWrapper create(Logger parent) throws UCCStartException {
        UCCWrapper ucc = null;
        System.out.println("UCCWRAP " + stamp);
        Object object = poolRetrievalLock;
        synchronized (object) {
            if (uccPool.isEmpty()) {
                ucc = new UCCWrapper(parent);
            } else {
                ucc = uccPool.iterator().next();
                ucc.terminationTask.cancel();
                uccPool.remove(ucc);
                if (ucc.poolCleanerTimer == null) {
                    ucc.poolCleanerTimer = new Timer("UCC pool cleaner");
                }
            }
            uccUnreleased.add(ucc);
            ucc.released = false;
        }
        return ucc;
    }

    protected void initUCCWrapper() throws UCCStartException {
        try {
            String id = System.currentTimeMillis() + "a" + fileCounter++;
            String fileWithPorts = "GBports" + id;
            String uccHomePath = UCCWrapper.getUnrealHome();
            String systemDirPath = uccHomePath + File.separator + "System" + File.separator;
            String execStr = systemDirPath + System.getProperty(UCC_EXEC);
            String options = "";
            if (!System.getProperty("os.name").contains("Windows")) {
                options = " -nohomedir";
            }
            ProcessBuilder procBuilder = new ProcessBuilder(execStr, "server", this.mapName + "?game=BotAPI." + this.gameType + "?PortsLog=" + fileWithPorts + "?bRandomPorts=true?Mutator=UnrealGame.MutGameSpeed?GameSpeed=1" + options);
            procBuilder.directory(new File(systemDirPath));
            this.uccProcess = procBuilder.start();
            ScannerSink scanner = new ScannerSink(this.uccProcess.getInputStream());
            scanner.start();
            new StreamSink(this.uccProcess.getErrorStream()).start();
            scanner.portsBindedLatch.await();
            if (scanner.exception != null) {
                this.uccProcess.destroy();
                throw scanner.exception;
            }
            this.utServer = new UTServer();
            this.utServer.setAutomaticallyReconnect(false);
            this.utServer.setGamebotsControlConnectionURI(URI.create("ut://localhost:" + scanner.controlPort));
            this.utServer.setGamebotsBotURI(URI.create("ut://localhost:" + scanner.botsPort));
        }
        catch (InterruptedException ex) {
            throw new UCCStartException("Interrupted.", ex);
        }
        catch (IOException ex) {
            throw new UCCStartException("IO Exception.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UCCWrapper(Logger parent) throws UCCStartException {
        Runtime.getRuntime().addShutdownHook(new Thread("UCC wrapper finalizer"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = poolRetrievalLock;
                synchronized (object) {
                    while (!uccPool.isEmpty()) {
                        uccPool.iterator().next().close();
                    }
                    while (!uccUnreleased.isEmpty()) {
                        uccUnreleased.iterator().next().close();
                    }
                }
            }
        });
        if (parent != null) {
            this.uccLog.setParent(parent);
        }
        Integer n = nextUccWrapperUID;
        synchronized (n) {
            Integer n2 = nextUccWrapperUID;
            Integer n3 = nextUccWrapperUID = Integer.valueOf(nextUccWrapperUID + 1);
            this.uccWrapperUID = n2;
        }
        this.initUCCWrapper();
    }

    public Process getProcess() {
        return this.uccProcess;
    }

    public void kill() {
        this.uccProcess.destroy();
    }

    protected void close() {
        if (uccPool.remove(this)) {
            this.utServer.terminate();
            this.uccProcess.destroy();
            this.poolCleanerTimer.cancel();
            this.poolCleanerTimer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release() {
        if (!this.released) {
            Object object = poolRetrievalLock;
            synchronized (object) {
                uccUnreleased.remove(this);
                uccPool.add(this);
                if (this.killAfter > 0L) {
                    this.terminationTask = new TimerTask(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            Object object = poolRetrievalLock;
                            synchronized (object) {
                                UCCWrapper.this.close();
                            }
                        }
                    };
                    this.poolCleanerTimer.schedule(this.terminationTask, this.killAfter);
                } else {
                    this.close();
                }
                this.released = true;
            }
        }
    }

    public int getGbPort() {
        return this.gbPort;
    }

    public int getControlPort() {
        return this.controlPort;
    }

    public class ScannerSink
    extends StreamSink {
        public long startingTimeout;
        public UCCStartException exception;
        public CountDownLatch portsBindedLatch;
        public int controlPort;
        public int botsPort;
        Timer timer;
        TimerTask task;
        private final Pattern portPattern;
        private final Pattern commandletNotFoundPattern;
        private final Pattern mapNotFoundPattern;
        private final Pattern matchStartedPattern;

        public ScannerSink(InputStream is) {
            super(is);
            this.startingTimeout = 120000L;
            this.exception = null;
            this.portsBindedLatch = new CountDownLatch(1);
            this.controlPort = -1;
            this.botsPort = -1;
            this.timer = new Timer("UCC start timeout");
            this.task = null;
            this.portPattern = Pattern.compile("ControlServerPort:(\\d*) BotServerPort:(\\d*)");
            this.commandletNotFoundPattern = Pattern.compile("Commandlet server not found");
            this.mapNotFoundPattern = Pattern.compile("No maplist entries found matching the current command line.*");
            this.matchStartedPattern = Pattern.compile("START MATCH");
            this.task = new TimerTask(){

                public void run() {
                    ScannerSink.this.exception = new UCCStartException("Starting timed out. Ports weren't bound in the required time (" + ScannerSink.this.startingTimeout + " ms).");
                    ScannerSink.this.timer.cancel();
                    ScannerSink.this.portsBindedLatch.countDown();
                }
            };
            this.timer.schedule(this.task, this.startingTimeout);
        }

        protected void handleInput(String str) {
            super.handleInput(str);
            if (this.portsBindedLatch.getCount() != 0L) {
                Matcher matcher = this.portPattern.matcher(str);
                if (matcher.find()) {
                    this.controlPort = Integer.parseInt(matcher.group(1));
                    this.botsPort = Integer.parseInt(matcher.group(2));
                }
                if ((matcher = this.commandletNotFoundPattern.matcher(str)).find()) {
                    this.exception = new UCCStartException("UCC failed to start due to: Commandlet server not found.");
                    this.raiseLatch();
                }
                if ((matcher = this.mapNotFoundPattern.matcher(str)).find()) {
                    this.exception = new UCCStartException("UCC failed to start due to: Map not found.");
                    this.raiseLatch();
                }
                if ((matcher = this.matchStartedPattern.matcher(str)).find()) {
                    this.raiseLatch();
                }
            }
        }

        protected void raiseLatch() {
            this.timer.cancel();
            this.task.cancel();
            this.portsBindedLatch.countDown();
        }
    }

    protected class StreamSink
    extends Thread {
        protected InputStream os = null;

        public StreamSink(InputStream os) {
            this.setName("Stream handler");
            this.os = os;
        }

        protected void handleInput(String str) {
            UCCWrapper.this.uccLog.info("ID" + UCCWrapper.this.uccWrapperUID + " " + str);
        }

        public void run() {
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(this.os));
            String s = null;
            try {
                while ((s = stdInput.readLine()) != null) {
                    this.handleInput(s);
                }
                this.os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

