/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.Parser;

import cz.cuni.pogamut.MessageObjects.MessageObject;
import cz.cuni.pogamut.exceptions.CantCloseConnectionException;
import cz.cuni.pogamut.exceptions.CantReadException;
import cz.cuni.pogamut.exceptions.CantWriteException;
import cz.cuni.pogamut.exceptions.ConnectException;
import cz.cuni.pogamut.exceptions.DisconnectException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ParserConnection {
    public static final String DEFAULT_ADDRESS = "localhost";
    public static final int DEFAULT_PORT = 4000;
    protected InetAddress serverAddress = null;
    protected int serverPort;
    private Socket socket = null;
    protected ObjectInputStream input = null;
    private PrintWriter output = null;
    private Logger log = null;

    public ParserConnection(String netAddress, int port, Logger log) throws UnknownHostException {
        this.serverAddress = InetAddress.getByName(netAddress);
        this.serverPort = port;
        this.log = log;
        this.log.setLevel(Level.ALL);
    }

    public ParserConnection(String netAddress) throws UnknownHostException {
        this(netAddress, 4000, Logger.getAnonymousLogger());
    }

    public ParserConnection() throws UnknownHostException {
        this(DEFAULT_ADDRESS, 4000, Logger.getAnonymousLogger());
    }

    public void connect() throws ConnectException {
        try {
            this.log.info("Connecting to RemoteParser: " + this.serverAddress + ":" + this.serverPort);
            this.socket = new Socket(this.serverAddress, this.serverPort);
            this.input = new ObjectInputStream(this.socket.getInputStream());
            this.output = new PrintWriter(this.socket.getOutputStream());
        }
        catch (IOException e) {
            this.log.severe("Can't connect to RemoteParser (" + this.serverAddress + ":" + this.serverPort + ") -> " + e.getMessage());
            throw new ConnectException("Can't connect to RemoteParser (" + this.serverAddress + ":" + this.serverPort + ") -> " + e.getMessage(), e);
        }
    }

    void disconnect() throws DisconnectException {
        if (!this.isConnected()) {
            return;
        }
        this.log.info("Disconnecting from GameBots.");
        try {
            this.input.close();
            this.output.close();
            this.socket.close();
        }
        catch (IOException e) {
            this.log.severe("Unable to disconnect from RemoteParser -> " + e.getMessage());
            this.input = null;
            this.output = null;
            this.socket = null;
            throw new DisconnectException("Unable to disconnect from RemoteParser -> " + e.getMessage(), e);
        }
        this.input = null;
        this.output = null;
        this.socket = null;
    }

    public boolean isConnected() {
        if (this.socket == null) {
            return true;
        }
        if (this.socket.isClosed()) {
            return true;
        }
        return true;
    }

    public void send(String msg) throws CantWriteException {
        try {
            this.output.println(msg);
            this.output.flush();
        }
        catch (NullPointerException e) {
            this.log.severe("Unable to send data to RemoteParser, connection closed.");
            throw new CantWriteException("Unable to send data to RemoteParser, connection closed.");
        }
        catch (Exception e) {
            this.log.severe("Unable to send data to RemoteParser -> " + e.getMessage());
            throw new CantWriteException("Unable to send data to RemoteParser -> " + e.getMessage(), e);
        }
    }

    public MessageObject readObject() throws CantReadException {
        try {
            return (MessageObject)this.input.readObject();
        }
        catch (IOException e) {
            this.log.severe("Unable to read the data from RemoteParser, connection closed.");
            throw new CantReadException("Unable to read the data from RemoteParser, connection closed.");
        }
        catch (ClassNotFoundException e) {
            this.log.severe("Unable to read the data from RemoteParser, connection closed.");
            throw new CantReadException("Unable to read the data from RemoteParser, connection closed.");
        }
    }

    public void close() throws CantCloseConnectionException {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            throw new CantCloseConnectionException("Can't close socket -> " + e.getMessage(), e);
        }
    }
}

