/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.Client;

import cz.cuni.pogamut.Client.Agent;
import cz.cuni.pogamut.Client.AgentBody;
import cz.cuni.pogamut.Client.AgentLauncher;
import cz.cuni.pogamut.Client.AgentMemory;
import cz.cuni.pogamut.Client.GameMap;
import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.MessageObjects.AddItem;
import cz.cuni.pogamut.MessageObjects.AddWeapon;
import cz.cuni.pogamut.MessageObjects.Ammo;
import cz.cuni.pogamut.MessageObjects.Health;
import cz.cuni.pogamut.MessageObjects.Item;
import cz.cuni.pogamut.MessageObjects.ItemType;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.NavPoint;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.MessageObjects.Weapon;
import cz.cuni.pogamut.exceptions.PogamutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestBot2
extends Agent {
    public static final int BOT_SKILL = 2;
    public static final double BOT_ACCURACY = 1.0;
    private static final double MinLoadedWeapon = 10.22;
    private static final int MinAgentHealthCriticalValue = 10;
    private static final int MinAgentHealthAndArmo = 25;
    private static final double MinArmoCoeficient = 0.3;
    private static final double visibledItemBonus = 0.8;
    private static final double ReachableItemBonus = 0.8;
    private static final double MaxNegativeBonus = 3000.0;
    private MyPathMaker myPathMaker;
    private static final int OnSamePlace = 60;
    private Item targetItem;
    private PickedItemsUpMemory pickedItems;
    private Object logicMutex;
    private KillListener killListener;
    private PickUpListener pickUpListener;
    private SeeItemListener seeItemListener;

    private void my_info(String text) {
        this.body.sendGlobalMessage(text);
        this.log.info(text);
    }

    public TestBot2() {
        this.myPathMaker = new MyPathMaker(this.gameMap, this.memory, this.body);
        this.targetItem = null;
        this.pickedItems = new PickedItemsUpMemory();
        this.logicMutex = new Object();
        this.killListener = new KillListener();
        this.pickUpListener = new PickUpListener();
        this.seeItemListener = new SeeItemListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doLogic() {
        Object object = this.logicMutex;
        synchronized (object) {
            this.pickedItems.doForgetItems();
            if (this.targetItemIsNegative()) {
                this.pickedItems.addHalf(this.targetItem.ID);
                this.targetItem = null;
            }
            this.doMinimumWeaponLogic();
        }
    }

    private boolean targetItemIsNegative() {
        if (this.targetItem == null) {
            return false;
        }
        if (Triple.distanceInSpace(this.memory.getAgentLocation(), this.targetItem.location) <= 60.0) {
            return true;
        }
        NavPoint np = this.memory.getSeeNavPoint(this.targetItem.navPoint.ID);
        if (np != null && np.visible) {
            this.my_info("I see target nav point but i don't see the item: " + this.targetItem.ID);
            return this.memory.getSeeItem(this.targetItem.ID) != null;
        }
        return false;
    }

    private boolean doMinimumWeaponLogic() {
        if (!this.hasMinimumWeaponAndAmmo()) {
            if (this.targetItem == null) {
                this.selectItemFromList(this.memory.getKnownAmmos(), this.selectItemFromList(this.memory.getKnownWeapons(), Double.MAX_VALUE));
                if (this.targetItem == null) {
                    this.my_info("There is no any  usedfull weapon or ammo !!!");
                    return false;
                }
                this.my_info("I choose this weapon/ammo: " + this.targetItem.toString());
            }
            if (this.targetItem != null && !this.myPathMaker.runToTarget(this.targetItem)) {
                this.my_info("I can't get to target location! " + this.targetItem.ID);
                this.pickedItems.addFull(this.targetItem.ID);
                this.targetItem = null;
            }
        }
        return false;
    }

    private boolean hasMinimumWeaponAndAmmo() {
        double minNumber = 0.0;
        ArrayList<AddWeapon> weapons = this.memory.getCopyOfAllWeapons();
        for (AddWeapon weapon : weapons) {
            if (weapon.getWeaponType() == ItemType.SHIELD_GUN || weapon.getWeaponType() == ItemType.ASSAULT_RIFLE) continue;
            minNumber += (double)weapon.currentAmmo / (double)weapon.maxAmmo;
        }
        return minNumber >= 10.22;
    }

    private double selectItemFromList(ArrayList<? extends Item> items, double distance) {
        for (Item item : items) {
            double d = Triple.distanceInSpace(this.memory.getAgentLocation(), item.location);
            if (item.isVisible()) {
                d *= 0.8;
            }
            if (item.isReachable()) {
                d *= 0.8;
            }
            if (this.pickedItems.contains(item.ID)) {
                d += 3000.0;
            }
            if (item instanceof Weapon && (((Weapon)item).getWeaponType() == ItemType.SHIELD_GUN || ((Weapon)item).getWeaponType() == ItemType.ASSAULT_RIFLE)) {
                d += 3000.0;
            }
            if (item instanceof Ammo) {
                if (this.memory.hasWeaponOfType(((Ammo)item).getAmmoType())) {
                    AddWeapon playerWeapon = this.getPlayerWeapon(((Ammo)item).getAmmoType());
                    d += Math.max(0.0, 1.0 - (double)((playerWeapon.maxAmmo - playerWeapon.currentAmmo) / ((Ammo)item).ammoAmount)) * 3000.0;
                } else {
                    d += 3000.0;
                }
            }
            if (item instanceof Health) {
                Health healt = (Health)item;
            }
            if (!(d < distance)) continue;
            this.targetItem = item;
            distance = d;
        }
        return distance;
    }

    private AddWeapon getPlayerWeapon(ItemType weaponType) {
        for (AddWeapon weapon : this.memory.getCopyOfAllWeapons()) {
            if (weapon.getWeaponType() != weaponType) continue;
            return weapon;
        }
        return null;
    }

    private boolean doMinimumHealthAndArmoLogic() {
        if (!this.hasMinimumHealthAndArmo()) {
            this.log.warning("I need some health!");
            if (this.targetItem == null) {
                this.selectItemFromList(this.memory.getKnownHealths(), Double.MAX_VALUE);
                if (this.targetItem == null) {
                    this.log.warning("There is no any  usedfull health !!!");
                    return false;
                }
                this.log.info("I choose this health: " + this.targetItem.toString());
            }
            if (this.targetItem != null && !this.gameMap.safeRunToLocation(this.targetItem.location)) {
                this.my_info("I can't get to target location! " + this.targetItem.ID);
                this.pickedItems.addFull(this.targetItem.ID);
                this.targetItem = null;
            }
            return true;
        }
        return false;
    }

    private boolean hasMinimumHealthAndArmo() {
        if (this.memory.getAgentHealth() < 10) {
            return false;
        }
        return (double)this.memory.getAgentHealth() + (double)this.memory.getAgentArmor() * 0.3 < 25.0;
    }

    @Override
    protected void prePrepareAgent() throws PogamutException {
    }

    @Override
    protected void postPrepareAgent() throws PogamutException {
    }

    @Override
    protected void shutdownAgent() throws PogamutException {
    }

    public static void main(String[] args) throws URISyntaxException {
        TestBot2 bot = new TestBot2();
        AgentLauncher launcher = new AgentLauncher(bot, new URI("ut://localhost"), true);
        launcher.launch();
    }

    private class SeeItemListener
    implements RcvMsgListener {
        public SeeItemListener() {
            TestBot2.this.body.addTypedRcvMsgListener(this, MessageType.ITEM);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receiveMessage(RcvMsgEvent e) {
            Object object = TestBot2.this.logicMutex;
            synchronized (object) {
                Item item = (Item)e.getMessage();
                if (item.ID != 0 && TestBot2.this.pickedItems.remove(item.ID) != null) {
                    TestBot2.this.my_info("I see forgot item: " + item.ID + " -> " + item.UnrealID);
                }
            }
        }
    }

    private class PickUpListener
    implements RcvMsgListener {
        public PickUpListener() {
            TestBot2.this.body.addTypedRcvMsgListener(this, MessageType.ADD_WEAPON);
            TestBot2.this.body.addTypedRcvMsgListener(this, MessageType.ADD_HEALTH);
            TestBot2.this.body.addTypedRcvMsgListener(this, MessageType.ADD_AMMO);
            TestBot2.this.body.addTypedRcvMsgListener(this, MessageType.ADD_ARMOR);
            TestBot2.this.body.addTypedRcvMsgListener(this, MessageType.ADD_EXTRA);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receiveMessage(RcvMsgEvent e) {
            Object object = TestBot2.this.logicMutex;
            synchronized (object) {
                AddItem item = (AddItem)e.getMessage();
                if (item.ID == 0) {
                    TestBot2.this.my_info("AIN: " + item.ID + " -> " + item.UnrealID);
                } else {
                    TestBot2.this.my_info("PICKUP: " + item.ID + " -> " + item.UnrealID);
                    TestBot2.this.pickedItems.addFull(item.ID);
                    if (((TestBot2)TestBot2.this).targetItem.ID == item.ID) {
                        TestBot2.this.targetItem = null;
                    }
                }
            }
        }
    }

    private class KillListener
    implements RcvMsgListener {
        public KillListener() {
            TestBot2.this.body.addTypedRcvMsgListener(this, MessageType.PLAYER_KILLED);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receiveMessage(RcvMsgEvent e) {
            Object object = TestBot2.this.logicMutex;
            synchronized (object) {
                TestBot2.this.targetItem = null;
                TestBot2.this.log.info("I has died!");
            }
        }
    }

    public class PickedItemsUpMemory {
        public long DefaultForgetTime = 27L;
        public long DeafultForgetTimeHalf = 13L;
        private long forgetTime;
        private long forgetTimeHalf;
        private Map<Integer, Long> items = new HashMap<Integer, Long>();

        PickedItemsUpMemory() {
            this.forgetTime = this.DefaultForgetTime * 1000L;
            this.forgetTimeHalf = this.DeafultForgetTimeHalf * 1000L;
        }

        PickedItemsUpMemory(long forgetTime_, long forgetTimeHalf_) {
            this.forgetTime = forgetTime_ * 1000L;
            this.forgetTimeHalf = forgetTimeHalf_ * 1000L;
        }

        private void add(int itemId, long time) {
            Long itemTime = this.items.get(itemId);
            if (itemTime != null) {
                itemTime = Math.max(itemTime, time);
            } else {
                this.items.put(itemId, time);
            }
        }

        public void addFull(int ItemID) {
            TestBot2.this.my_info("addFull(" + ItemID + ")");
            this.add(ItemID, System.currentTimeMillis() + this.forgetTime);
        }

        public void addHalf(int ItemID) {
            TestBot2.this.my_info("addHalf(" + ItemID + ")");
            this.add(ItemID, System.currentTimeMillis() + this.forgetTimeHalf);
        }

        public Long remove(int ItemID) {
            return this.items.remove(ItemID);
        }

        public boolean contains(int itemID) {
            return this.items.containsKey(itemID);
        }

        public void doForgetItems() {
            Iterator<Long> iter = this.items.values().iterator();
            while (iter.hasNext()) {
                long time = iter.next();
                if (time > System.currentTimeMillis()) continue;
                iter.remove();
            }
        }

        public int size() {
            return this.items.size();
        }
    }

    public class MyPathMaker {
        private static final int OnSamePlace = 210;
        private static final int maxTimeIterRun = 6;
        private Triple lastLocation = null;
        private int iterace = 0;
        private Item targetItem = null;
        private GameMap gameMap;
        private AgentMemory memory;
        private AgentBody body;

        MyPathMaker(GameMap gameMap, AgentMemory memory, AgentBody body) {
            this.gameMap = gameMap;
            this.memory = memory;
            this.body = body;
        }

        void reset() {
            this.targetItem = null;
            this.iterace = 0;
            this.lastLocation = this.memory.getAgentLocation();
        }

        boolean runToTarget(Item target) {
            if (target != this.targetItem) {
                this.reset();
                this.targetItem = target;
            }
            if (this.memory.isColliding()) {
                this.body.doubleJump();
            }
            if (++this.iterace >= 6) {
                if (Triple.distanceInSpace(this.memory.getAgentLocation(), this.lastLocation) < 210.0) {
                    return false;
                }
                this.lastLocation = this.memory.getAgentLocation();
                this.iterace = 0;
            }
            return this.gameMap.safeRunToLocation(this.targetItem.location);
        }
    }
}

