/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.Client;

import cz.cuni.pogamut.Client.Agent;
import cz.cuni.pogamut.Client.AgentLauncher;
import cz.cuni.pogamut.MessageObjects.AutoTraceRay;
import cz.cuni.pogamut.MessageObjects.Triple;
import cz.cuni.pogamut.exceptions.PogamutException;
import cz.cuni.pogamut.introspection.PogProp;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;

public class TestBot
extends Agent {
    public static final int LEFT_SENSOR = 1;
    public static final int FRONT_SENSOR = 2;
    public static final int RIGHT_SENSOR = 3;
    public static final double SENSOR_LENGTH = 130.0;
    @PogProp
    public boolean sensorLeft = false;
    @PogProp
    public boolean sensorRight = false;
    @PogProp
    public boolean sensorFront = false;
    @PogProp
    public boolean moving = false;
    @PogProp
    public boolean sensor = false;
    @PogProp
    public int turnSleep = 250;
    @PogProp
    public float moveSpeed = 0.6f;
    @PogProp
    public int smallTurn = 30;
    @PogProp
    public int bigTurn = 90;
    boolean traceRun = false;
    ArrayList<AutoTraceRay> traces = null;
    boolean first = true;

    protected void doLogic() {
        if (this.first) {
            this.first = false;
            this.body.configureDrawTraceLines(true);
            return;
        }
        this.traceRun = false;
        this.traces = this.memory.getAutoTraces();
        this.sensorFront = this.memory.getAutoTrace((int)2).result;
        this.sensorLeft = this.memory.getAutoTrace((int)1).result;
        this.sensorRight = this.memory.getAutoTrace((int)3).result;
        this.sensor = this.sensorFront || this.sensorLeft || this.sensorRight;
        try {
            if (this.sensor) {
                if (this.moving) {
                    this.body.stop();
                    this.moving = false;
                }
                if (this.sensorFront) {
                    if (this.sensorLeft) {
                        if (this.sensorRight) {
                            this.body.turnHorizontal(this.bigTurn);
                            Thread.sleep(this.turnSleep);
                        } else {
                            this.body.turnHorizontal(this.smallTurn);
                            Thread.sleep(this.turnSleep);
                        }
                    } else if (this.sensorRight) {
                        this.body.turnHorizontal(-this.smallTurn);
                        Thread.sleep(this.turnSleep);
                    } else {
                        this.body.turnHorizontal(this.smallTurn);
                        Thread.sleep(this.turnSleep);
                    }
                } else if (this.sensorLeft) {
                    if (this.sensorRight) {
                        this.body.contMove(this.moveSpeed);
                        this.moving = true;
                    } else {
                        this.body.turnHorizontal(this.smallTurn);
                        Thread.sleep(this.turnSleep);
                    }
                } else if (this.sensorRight) {
                    this.body.turnHorizontal(-this.smallTurn);
                    Thread.sleep(this.turnSleep);
                } else {
                    this.body.contMove(this.moveSpeed);
                    this.moving = true;
                }
            } else {
                this.body.contMove(this.moveSpeed);
                this.moving = true;
            }
        }
        catch (Exception e) {
            this.log.severe("Exception ...");
        }
    }

    protected void prePrepareAgent() throws PogamutException {
    }

    protected void postPrepareAgent() throws PogamutException {
        this.body.removeAllRaysFromAutoTrace();
        this.body.addRayToAutoTrace(1, new Triple(1.0, -1.0, 0.0), 130.0, false, true);
        this.body.addRayToAutoTrace(3, new Triple(1.0, 1.0, 0.0), 130.0, false, true);
        this.body.addRayToAutoTrace(2, new Triple(1.0, 0.0, 0.0), 130.0, false, true);
        this.body.initializer.setAutoTrace(true);
    }

    protected void shutdownAgent() throws PogamutException {
    }

    public static void main(String[] args) throws URISyntaxException {
        TestBot bot = new TestBot();
        AgentLauncher launcher = new AgentLauncher(bot, new URI("ut://localhost"), true);
        launcher.launch();
    }
}

