/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.Client;

import cz.cuni.pogamut.Client.Agent;
import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.MessageObjects.BotDamaged;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.PlayerDamaged;
import cz.cuni.pogamut.MessageObjects.PlayerKilled;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AgentStats
implements Serializable {
    protected transient Agent agent = null;
    protected int frags = 0;
    protected int deaths = 0;
    protected int damageCaused = 0;
    protected int damageSuffered = 0;
    protected int wallHits = 0;
    protected double teamScore = 0.0;
    protected double enemyTeamScore = 0.0;
    protected int rocketHits = 0;
    protected Serializable extra = null;

    protected Agent getAgent() {
        return this.agent;
    }

    public AgentStats(Agent agent) {
        this.setAgent(agent);
    }

    public AgentStats() {
    }

    public void setAgent(Agent agent) {
        if (this.agent != null) {
            throw new IllegalArgumentException("Agent already set.");
        }
        this.agent = agent;
        this.registerListeners();
    }

    private void registerListeners() {
        this.getAgent().getBody().addTypedRcvMsgListener(new RcvMsgListener(){

            public void receiveMessage(RcvMsgEvent e) {
                PlayerKilled killed = (PlayerKilled)e.getMessage();
                if (killed.killerID == AgentStats.this.getAgent().getMemory().getAgentID()) {
                    ++AgentStats.this.frags;
                }
            }
        }, MessageType.PLAYER_KILLED);
        this.getAgent().getBody().addTypedRcvMsgListener(new RcvMsgListener(){

            public void receiveMessage(RcvMsgEvent e) {
                PlayerDamaged damaged = (PlayerDamaged)e.getMessage();
                if (damaged.hitID != AgentStats.this.getAgent().getMemory().getAgentID()) {
                    AgentStats.this.damageCaused += damaged.damage;
                }
            }
        }, MessageType.PLAYER_DAMAGED);
        this.getAgent().getBody().addTypedRcvMsgListener(new RcvMsgListener(){

            public void receiveMessage(RcvMsgEvent e) {
                ++AgentStats.this.deaths;
            }
        }, MessageType.BOT_KILLED);
        this.getAgent().getBody().addTypedRcvMsgListener(new RcvMsgListener(){

            public void receiveMessage(RcvMsgEvent e) {
                BotDamaged damaged = (BotDamaged)e.getMessage();
                AgentStats.this.damageSuffered += damaged.damage;
            }
        }, MessageType.BOT_DAMAGED);
        this.getAgent().getBody().addTypedRcvMsgListener(new RcvMsgListener(){

            public void receiveMessage(RcvMsgEvent e) {
                double ts = AgentStats.this.getAgent().getMemory().getAgentTeamScore();
                double ets = AgentStats.this.getAgent().getMemory().getOpposingTeamScore();
                if (ts >= 0.0) {
                    AgentStats.this.teamScore = ts;
                }
                if (ets >= 0.0) {
                    AgentStats.this.enemyTeamScore = ets;
                }
            }
        }, MessageType.GAME_STATUS);
        this.getAgent().getBody().addTypedRcvMsgListener(new RcvMsgListener(){

            public void receiveMessage(RcvMsgEvent e) {
                ++AgentStats.this.wallHits;
            }
        }, MessageType.WALL_COLLISION);
    }

    public int getFrags() {
        return this.frags;
    }

    public Serializable getExtra() {
        return this.extra;
    }

    public void setExtra(Serializable extra) {
        this.extra = extra;
    }

    public int getDeaths() {
        return this.deaths;
    }

    public int getDamageCaused() {
        return this.damageCaused;
    }

    public int getDamageSuffered() {
        return this.damageSuffered;
    }

    public String toString() {
        String str = "";
        try {
            BeanInfo info = Introspector.getBeanInfo(this.getClass());
            for (PropertyDescriptor desc : info.getPropertyDescriptors()) {
                if (desc.getName().equals("agent")) continue;
                str = str + desc.getShortDescription() + " = " + desc.getReadMethod().invoke((Object)this, null).toString() + ", ";
            }
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(AgentStats.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(AgentStats.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(AgentStats.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IntrospectionException ex) {
            Logger.getLogger(AgentStats.class.getName()).log(Level.SEVERE, null, ex);
        }
        return str;
    }

    public double getTeamScore() {
        return this.teamScore;
    }

    public double getEnemyTeamScore() {
        return this.enemyTeamScore;
    }

    public void plus(AgentStats s) {
        this.damageCaused += s.getDamageCaused();
        this.damageSuffered += s.getDamageSuffered();
        this.teamScore += s.getTeamScore();
        this.enemyTeamScore += s.getEnemyTeamScore();
        this.deaths += s.getDeaths();
        this.frags += s.getFrags();
        this.wallHits += s.getWallHits();
    }

    public int getWallHits() {
        return this.wallHits;
    }
}

