/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.Client;

import cz.cuni.pogamut.Client.AgentBody;
import cz.cuni.pogamut.Client.AgentIterationEndEvent;
import cz.cuni.pogamut.Client.AgentIterationEndListener;
import cz.cuni.pogamut.Client.AgentMemory;
import cz.cuni.pogamut.Client.GameMap;
import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.MessageObjects.Command;
import cz.cuni.pogamut.MessageObjects.CommandTypes;
import cz.cuni.pogamut.MessageObjects.GameInfo;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.Parser.GameBotConnection;
import cz.cuni.pogamut.Parser.Parser;
import cz.cuni.pogamut.Parser.ParserConnection;
import cz.cuni.pogamut.Parser.UnrealIDMap;
import cz.cuni.pogamut.communication.CommunicationState;
import cz.cuni.pogamut.communication.Mediator;
import cz.cuni.pogamut.communication.RemoteParserForMediator;
import cz.cuni.pogamut.exceptions.CantWriteException;
import cz.cuni.pogamut.exceptions.ConnectException;
import cz.cuni.pogamut.exceptions.PogamutException;
import cz.cuni.pogamut.introspection.Introspectable;
import cz.cuni.pogamut.introspection.IntrospectableProxy;
import cz.cuni.pogamut.introspection.PogProp;
import cz.cuni.pogamut.introspection.java.JavaReflectionProxy;
import cz.cuni.pogamut.server.ParserType;
import cz.cuni.utils.ExceptionToString;
import cz.cuni.utils.Flag;
import cz.cuni.utils.FlagListener;
import java.io.IOException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class Agent
implements Runnable,
RcvMsgListener,
Introspectable {
    @PogProp
    public static int instancesAlive = 0;
    public static int GARBAGE_COLLECTOR_FREQUENCY = 100;
    @PogProp
    public double logicFrequency = 8.0;
    private static int botNum = 0;
    private Flag<Boolean> threadLogicAlive = new Flag<Boolean>(false);
    private boolean exceptionOccured = false;
    private boolean logicShouldRun = true;
    private Thread threadLogic = null;
    private String defaultBotName = "PogamutBot";
    private CountDownLatch logicStartLatch = null;
    private CountDownLatch logicPauseLatch = null;
    private boolean logicIsPaused = false;
    protected ArrayList<AgentIterationEndListener> iterationEndListeners = new ArrayList();
    protected AgentBody body = null;
    protected AgentMemory memory = null;
    protected GameMap gameMap = null;
    public Logger log;
    protected Logger platformLog;
    protected Logger parserLogger = null;
    protected Random random = new Random();
    protected ParserType bindedParserType = null;
    protected GameBotConnection gameBotConnection = null;
    protected Logger rawGBLog = Logger.getAnonymousLogger();
    public boolean flagLogicTemporalyStopped = false;
    protected boolean logicFrequencyChanged = false;
    protected double oldLogicFrequency = 0.0;
    private JavaReflectionProxy javaReflectionProxy = null;
    protected Collection pauseHolders = new HashSet();

    public boolean getFlagLogicTemporalyStopped() {
        return this.flagLogicTemporalyStopped;
    }

    public void setFlagLogicTemporalyStopped(boolean value) {
        this.flagLogicTemporalyStopped = value;
    }

    protected void initMemory() {
        this.memory = new AgentMemory(this.platformLog, this.body, this);
    }

    protected void initBody() {
        this.body = new AgentBody(this.platformLog);
        this.body.addRcvMsgListener(this);
        this.body.exceptionOccured.addListener(new FlagListener<Boolean>(){

            @Override
            public void flagChanged(Boolean changedValue, int listenerParam) {
                if (changedValue.booleanValue()) {
                    Agent.this.platformLog.severe("Exception occured, stopping agent.");
                    Agent.this.exceptionOccured = true;
                }
            }
        });
    }

    protected void initGameMap() {
        this.gameMap = new GameMap(this.platformLog, this.body, this.memory);
    }

    public AgentBody getBody() {
        return this.body;
    }

    public AgentMemory getMemory() {
        return this.memory;
    }

    public GameMap getMap() {
        return this.gameMap;
    }

    public Thread getLogicThread() {
        return this.threadLogic;
    }

    public CommunicationState getCommunicationState() {
        return this.body.communicationState.getFlag();
    }

    public Mediator getMediator() {
        return this.body.mediator;
    }

    public String getName() {
        String name = this.memory.getAgentName();
        if (name != null) {
            return name;
        }
        return this.defaultBotName;
    }

    protected void initLogging() {
        this.log = Logger.getAnonymousLogger();
        this.platformLog = Logger.getAnonymousLogger();
        this.log.setLevel(Level.ALL);
        this.platformLog.setLevel(Level.ALL);
        this.platformLog.config("Start of logging");
    }

    public Agent() {
        ++instancesAlive;
        this.initLogging();
        this.initBody();
        this.initMemory();
        this.initGameMap();
        this.body.addTypedRcvMsgListener(this, MessageType.MAP_FINISHED);
    }

    public void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        --instancesAlive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addIterationEndListener(AgentIterationEndListener listener) {
        ArrayList<AgentIterationEndListener> arrayList = this.iterationEndListeners;
        synchronized (arrayList) {
            ArrayList clone = (ArrayList)this.iterationEndListeners.clone();
            clone.add(listener);
            this.iterationEndListeners = clone;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeIterationEndListener(AgentIterationEndListener listener) {
        ArrayList<AgentIterationEndListener> arrayList = this.iterationEndListeners;
        synchronized (arrayList) {
            ArrayList clone = (ArrayList)this.iterationEndListeners.clone();
            clone.remove(listener);
            this.iterationEndListeners = clone;
            return true;
        }
    }

    public void setLogicStartLatch(CountDownLatch latch) {
        this.logicStartLatch = latch;
    }

    public final void bindLocalParser(URI gameBots) throws IOException, ConnectException {
        GameBotConnection gb;
        if (this.body.mediator != null) {
            this.platformLog.severe("AgentBody's mediator already initialized - assuming second bindLocalParser() was called - forbidden!");
            return;
        }
        if (this.threadLogicAlive.getFlag().booleanValue()) {
            this.platformLog.severe("Logic thread flag is TRUE - logic should be already running, assuming second startAgentLocalParser() was called - forbidden! Agent's not started.");
        }
        this.platformLog.info("Binding local parser.");
        this.platformLog.info("Connecting to GameBots at " + gameBots.toString());
        this.gameBotConnection = gb = new GameBotConnection(gameBots.getHost(), gameBots.getPort() == -1 ? 3000 : gameBots.getPort());
        gb.connect();
        UnrealIDMap idMap = new UnrealIDMap();
        this.platformLog.info("Creating local parser.");
        Parser parser = new Parser(gb, idMap, this.platformLog);
        this.platformLog.info("Creating communication mediator.");
        Mediator mediator = new Mediator(this.body, parser, parser, this.platformLog);
        this.body.bindMediator(mediator);
        this.bindedParserType = ParserType.LOCAL;
    }

    public final void bindRemoteParser(URI parser) throws ConnectException, UnknownHostException {
        if (this.body.mediator != null) {
            this.platformLog.severe("AgentBody's mediator already initialized - assuming second bindRemoteParser() was called - forbidden!");
            return;
        }
        if (this.threadLogicAlive.getFlag().booleanValue()) {
            this.platformLog.severe("Logic thread flag is TRUE - logic should be already running, assuming second bindRemoteParser() was called - forbidden!");
            return;
        }
        this.platformLog.info("Binding remote parser.");
        this.platformLog.info("Connecting to RemotePaser at " + parser.toString());
        ParserConnection remoteParser = new ParserConnection(parser.getHost());
        remoteParser.connect();
        this.platformLog.info("Creating remote parser interface.");
        RemoteParserForMediator parserInterface = new RemoteParserForMediator(remoteParser);
        this.platformLog.info("Creating communication mediator.");
        Mediator mediator = new Mediator(this.body, parserInterface, parserInterface, this.platformLog);
        this.body.bindMediator(mediator);
        this.bindedParserType = ParserType.REMOTE;
    }

    public Logger getRawDataLog() {
        return this.rawGBLog;
    }

    public Thread startAgent(String botName) {
        if (this.body.mediator == null) {
            this.platformLog.severe("Can't start agent. Parser wasn't bind to the body.");
            return null;
        }
        if (botName == null) {
            botName = this.body.isNameBinded() ? this.body.getBindedName() : "PogamutBot";
        }
        this.defaultBotName = botName = botName + "_" + String.valueOf(botNum++);
        this.body.bindName(botName);
        this.platformLog.info("Starting agent.");
        this.platformLog.info("Calling prePrepareAgent().");
        try {
            this.prePrepareAgent();
        }
        catch (PogamutException e1) {
            this.platformLog.severe(ExceptionToString.process("Exception occured in prePrepareAgent(), agent can't be started.", e1));
            try {
                this.body.mediator.sendMessageToGB(new Command("QUIT", CommandTypes.QUIT));
            }
            catch (CantWriteException e2) {
                // empty catch block
            }
            this.body.mediator.stopMediator();
            this.platformLog.finest("Switching communication state to EXCEPTION.");
            this.body.communicationState.setFlag(CommunicationState.EXCEPTION);
            return null;
        }
        this.platformLog.info("Starting the mediator.");
        this.body.mediator.startMediator();
        this.body.mediator.pauseClientParserThread();
        try {
            this.body.navpointsItemsReceivedLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.platformLog.info("Handshake with gamebots successfull, running postPrepareAgent().");
        try {
            this.postPrepareAgent();
        }
        catch (PogamutException e) {
            this.platformLog.severe(ExceptionToString.process("Exception occured in postPrepareAgent(), can't start the agent.", e));
            try {
                this.body.mediator.sendMessageToGB(new Command("QUIT", CommandTypes.QUIT));
            }
            catch (CantWriteException cantWriteException) {
                // empty catch block
            }
            this.body.mediator.stopMediator();
            this.platformLog.finest("Switching communication state to EXCEPTION.");
            this.body.communicationState.setFlag(CommunicationState.EXCEPTION);
            return null;
        }
        this.body.fireLogicLatch.countDown();
        this.platformLog.info("postPrepareAgent() finished, starting logic thread.");
        this.threadLogic = new Thread((Runnable)this, "Bot: " + botName + " - logic");
        this.threadLogicAlive.setFlag(true);
        this.threadLogic.start();
        return this.threadLogic;
    }

    public Thread startAgent() {
        if (this.body.isNameBinded()) {
            return this.startAgent(null);
        }
        return this.startAgent("PogamutBot");
    }

    public Logger getLogger() {
        return this.log;
    }

    public Logger getPlatformLog() {
        return this.platformLog;
    }

    public boolean logicReady() {
        if (this.memory.memoryRestarted) {
            this.memory.switchMemories();
            return false;
        }
        if (!this.memory.hasSelf()) {
            return false;
        }
        return !this.flagLogicTemporalyStopped;
    }

    protected long getMilisecToSleep(long passedMillisec) {
        long result;
        if (this.logicFrequency != this.oldLogicFrequency) {
            this.oldLogicFrequency = this.logicFrequency;
            this.logicFrequencyChanged = true;
        }
        int milisecToSleep = 1;
        if (this.logicFrequency < 1000.0 && this.logicFrequency > 0.0) {
            milisecToSleep = (int)(1000.0 / this.logicFrequency);
        }
        if (this.logicFrequency > 20.0 && this.logicFrequencyChanged) {
            this.platformLog.info("Logic frequency is too high. Recommended frequency is between 5 to 20Hz");
            this.logicFrequencyChanged = false;
        }
        if (this.logicFrequency < 5.0 && this.logicFrequencyChanged) {
            this.platformLog.info("Logic frequency is too low. Recommended frequency is between 5 to 20Hz");
            this.logicFrequencyChanged = false;
        }
        if ((result = (long)milisecToSleep - passedMillisec) < 0L) {
            result = 0L;
        }
        return result;
    }

    public void run() {
        if (this.threadLogic == null) {
            this.platformLog.severe("Agent run() called but threadLogic == null, aborting.");
            return;
        }
        this.platformLog.info("Logic thread started.");
        long cycleTime = 0L;
        long tempTime = 0L;
        int garbageCollector = 0;
        try {
            if (this.logicStartLatch != null) {
                this.platformLog.info("Awaiting on the logic latch.");
                this.logicStartLatch.await();
                this.platformLog.info("Latch raised, agent logic started.");
            }
            if (this.memory.getGameInfo().botsPaused) {
                this.pauseLogic(this);
            }
            while (this.isRunning()) {
                tempTime = System.currentTimeMillis();
                if (this.logicIsPaused) {
                    this.platformLog.finest("Switching communication state to PAUSED.");
                    this.body.getCommunicationStateFlag().setFlag(CommunicationState.PAUSED);
                    this.logicPauseLatch.await();
                    this.platformLog.finest("Switching communication state to BOT_RUNNING.");
                    this.body.getCommunicationStateFlag().setFlag(CommunicationState.BOT_RUNNING);
                }
                if (this.logicReady()) {
                    this.doLogic();
                } else {
                    this.platformLog.info("Waiting for the SELF message.");
                }
                if (++garbageCollector == GARBAGE_COLLECTOR_FREQUENCY) {
                    this.platformLog.config("Garbage collector run.");
                    System.gc();
                    garbageCollector = 0;
                }
                for (AgentIterationEndListener listener : this.iterationEndListeners) {
                    listener.iterationEnds(new AgentIterationEndEvent(this));
                }
                cycleTime = System.currentTimeMillis() - tempTime;
                try {
                    Thread.sleep(this.getMilisecToSleep(cycleTime));
                }
                catch (InterruptedException e) {
                    this.log.severe(ExceptionToString.process("Agent was ruthlessly interrupted during the sleep!", e));
                }
            }
        }
        catch (Exception e) {
            this.platformLog.severe(ExceptionToString.process("Exception occured - shutting down the agent.", e));
            this.platformLog.finest("Switching communication state to EXCEPTION.");
            this.body.communicationState.setFlag(CommunicationState.EXCEPTION);
        }
        if (this.body.mediator.isCommunicationAlive()) {
            this.platformLog.info("Logic stopped, closing agent connection to UT.");
            this.body.mediator.stopMediator();
        } else if (this.body.communicationState.getFlag() != CommunicationState.MAP_FINISHED) {
            this.platformLog.severe("Connection lost, stopping logic, probably communication exception");
            this.platformLog.finest("Switching communication state to EXCEPTION.");
            this.body.communicationState.setFlag(CommunicationState.EXCEPTION);
        } else {
            this.platformLog.severe("Communication stopped.");
        }
        this.body.mediator.resumeClientParserThread();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e1) {
            // empty catch block
        }
        if (!CommunicationState.getEndStates().contains((Object)this.body.communicationState.getFlag())) {
            this.platformLog.finest("Switching communication state to TERMINATED.");
            this.body.communicationState.setFlag(CommunicationState.TERMINATED);
        }
        this.platformLog.info("Calling shutdownAgent().");
        try {
            this.shutdownAgent();
        }
        catch (PogamutException e) {
            this.platformLog.severe(ExceptionToString.process("Exception in shutdownAgent() occured.", e));
            this.platformLog.finest("Switching communication state to EXCEPTION.");
            this.body.communicationState.setFlag(CommunicationState.EXCEPTION);
        }
        this.platformLog.info("shutdownAgent() finished.");
        this.platformLog.info("Deregistering various listeners.");
        this.clearListeners();
        this.javaReflectionProxy = null;
        this.platformLog.info("Agent finished.");
        this.closeAllStreamHandlers();
        this.threadLogicAlive.setFlag(false);
    }

    private void closeAllStreamHandlers() {
        this.closeStreamHandlersOfLog(this.getLogger());
        this.closeStreamHandlersOfLog(this.getPlatformLog());
        this.closeStreamHandlersOfLog(this.getRawDataLog());
    }

    private void closeStreamHandlersOfLog(Logger log) {
        if (log != null) {
            for (Handler handler : log.getHandlers()) {
                if (!StreamHandler.class.isInstance(handler)) continue;
                ((StreamHandler)handler).close();
            }
        }
    }

    protected void prePrepareAgent() throws PogamutException {
    }

    protected void postPrepareAgent() throws PogamutException {
    }

    protected void shutdownAgent() throws PogamutException {
    }

    protected void doLogic() throws PogamutException {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            this.log.severe(ExceptionToString.process("Agent interrupted during sleep in doLogic", e));
        }
    }

    public boolean isRunning() {
        return this.body.mediator.isCommunicationAlive() && this.logicShouldRun && !this.exceptionOccured;
    }

    public void disconnect() {
        this.stopAgentSoft();
    }

    public void stopAgentSoft() {
        this.platformLog.info("stopAgentSoft() called, stopping logic thread (soft).");
        this.logicShouldRun = false;
        if (this.logicIsPaused) {
            this.resumeLogic(this);
        }
        if (this.logicPauseLatch != null) {
            this.logicPauseLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveMessage(RcvMsgEvent e) {
        switch (e.getMessage().getType()) {
            case MAP_FINISHED: {
                this.platformLog.severe("Map finished.");
                this.platformLog.finest("Switching communication state to MAP_FINIESHED");
                this.body.communicationState.setFlag(CommunicationState.MAP_FINISHED);
                this.stopAgentSoft();
                break;
            }
            case GAME_PAUSED: {
                GameInfo info1;
                GameInfo gameInfo = info1 = this.memory.getGameInfo();
                synchronized (gameInfo) {
                    info1.gamePaused = true;
                    this.pauseLogic(this);
                    break;
                }
            }
            case GAME_RESUMED: {
                GameInfo info2;
                GameInfo gameInfo = info2 = this.memory.getGameInfo();
                synchronized (gameInfo) {
                    info2.gamePaused = false;
                    this.resumeLogic(this);
                    break;
                }
            }
        }
    }

    public synchronized IntrospectableProxy getIntrospectableProxy() {
        return new JavaReflectionProxy(this);
    }

    public synchronized void pauseLogic(Object holder) {
        this.pauseHolders.add(holder);
        if (this.logicIsPaused) {
            this.platformLog.config("pauseLogic() called on already paused Agent");
            return;
        }
        this.platformLog.config("pauseLogic() called, raising flag");
        this.logicPauseLatch = new CountDownLatch(1);
        this.logicIsPaused = true;
    }

    public synchronized void resumeLogic(Object holder) {
        if (!this.pauseHolders.contains(holder)) {
            return;
        }
        this.pauseHolders.remove(holder);
        if (!this.logicIsPaused) {
            return;
        }
        if (this.pauseHolders.isEmpty()) {
            this.platformLog.config("pauseLogic() called, dropping flag");
            this.logicIsPaused = false;
            this.logicPauseLatch.countDown();
        } else {
            this.platformLog.config("pauseLogic() called, but there are more pause holder");
        }
    }

    public ParserType getBindedParserType() {
        return this.bindedParserType;
    }

    public void sendMessageToGB(String str) throws CantWriteException {
        this.gameBotConnection.send(str);
    }

    protected void clearListeners() {
        this.threadLogicAlive.clearListeners();
        this.iterationEndListeners.clear();
        this.body.clearListeners();
        this.memory.clearListeners();
    }
}

